/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route table route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRouteTableRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRouteTableRoute.Builder, AnalysisRouteTableRoute> {
    private static final SdkField<String> DESTINATION_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidr")
            .getter(getter(AnalysisRouteTableRoute::destinationCidr))
            .setter(setter(Builder::destinationCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidr")
                    .unmarshallLocationName("destinationCidr").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefixListId")
            .getter(getter(AnalysisRouteTableRoute::destinationPrefixListId))
            .setter(setter(Builder::destinationPrefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId")
                    .unmarshallLocationName("destinationPrefixListId").build()).build();

    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressOnlyInternetGatewayId")
            .getter(getter(AnalysisRouteTableRoute::egressOnlyInternetGatewayId))
            .setter(setter(Builder::egressOnlyInternetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId")
                    .unmarshallLocationName("egressOnlyInternetGatewayId").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GatewayId")
            .getter(getter(AnalysisRouteTableRoute::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId")
                    .unmarshallLocationName("gatewayId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(AnalysisRouteTableRoute::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId")
            .getter(getter(AnalysisRouteTableRoute::natGatewayId))
            .setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId")
                    .unmarshallLocationName("natGatewayId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AnalysisRouteTableRoute::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Origin")
            .getter(getter(AnalysisRouteTableRoute::origin))
            .setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin")
                    .unmarshallLocationName("origin").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(AnalysisRouteTableRoute::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(AnalysisRouteTableRoute::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("vpcPeeringConnectionId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(AnalysisRouteTableRoute::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> CARRIER_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CarrierGatewayId")
            .getter(getter(AnalysisRouteTableRoute::carrierGatewayId))
            .setter(setter(Builder::carrierGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewayId")
                    .unmarshallLocationName("carrierGatewayId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkArn")
            .getter(getter(AnalysisRouteTableRoute::coreNetworkArn))
            .setter(setter(Builder::coreNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn")
                    .unmarshallLocationName("coreNetworkArn").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(AnalysisRouteTableRoute::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_FIELD,
            DESTINATION_PREFIX_LIST_ID_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, INSTANCE_ID_FIELD,
            NAT_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, ORIGIN_FIELD, TRANSIT_GATEWAY_ID_FIELD,
            VPC_PEERING_CONNECTION_ID_FIELD, STATE_FIELD, CARRIER_GATEWAY_ID_FIELD, CORE_NETWORK_ARN_FIELD,
            LOCAL_GATEWAY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationCidr;

    private final String destinationPrefixListId;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final String natGatewayId;

    private final String networkInterfaceId;

    private final String origin;

    private final String transitGatewayId;

    private final String vpcPeeringConnectionId;

    private final String state;

    private final String carrierGatewayId;

    private final String coreNetworkArn;

    private final String localGatewayId;

    private AnalysisRouteTableRoute(BuilderImpl builder) {
        this.destinationCidr = builder.destinationCidr;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.origin = builder.origin;
        this.transitGatewayId = builder.transitGatewayId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.state = builder.state;
        this.carrierGatewayId = builder.carrierGatewayId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.localGatewayId = builder.localGatewayId;
    }

    /**
     * <p>
     * The destination IPv4 address, in CIDR notation.
     * </p>
     * 
     * @return The destination IPv4 address, in CIDR notation.
     */
    public final String destinationCidr() {
        return destinationCidr;
    }

    /**
     * <p>
     * The prefix of the Amazon Web Services service.
     * </p>
     * 
     * @return The prefix of the Amazon Web Services service.
     */
    public final String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * The ID of an egress-only internet gateway.
     * </p>
     * 
     * @return The ID of an egress-only internet gateway.
     */
    public final String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of the gateway, such as an internet gateway or virtual private gateway.
     * </p>
     * 
     * @return The ID of the gateway, such as an internet gateway or virtual private gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of the instance, such as a NAT instance.
     * </p>
     * 
     * @return The ID of the instance, such as a NAT instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of a NAT gateway.
     * </p>
     * 
     * @return The ID of a NAT gateway.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of a network interface.
     * </p>
     * 
     * @return The ID of a network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Describes how the route was created. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CreateRouteTable - The route was automatically created when the route table was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * CreateRoute - The route was manually added to the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * EnableVgwRoutePropagation - The route was propagated by route propagation.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes how the route was created. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CreateRouteTable - The route was automatically created when the route table was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CreateRoute - The route was manually added to the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EnableVgwRoutePropagation - The route was propagated by route propagation.
     *         </p>
     *         </li>
     */
    public final String origin() {
        return origin;
    }

    /**
     * <p>
     * The ID of a transit gateway.
     * </p>
     * 
     * @return The ID of a transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of a VPC peering connection.
     * </p>
     * 
     * @return The ID of a VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The state. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * active
     * </p>
     * </li>
     * <li>
     * <p>
     * blackhole
     * </p>
     * </li>
     * </ul>
     * 
     * @return The state. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         active
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         blackhole
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The ID of a carrier gateway.
     * </p>
     * 
     * @return The ID of a carrier gateway.
     */
    public final String carrierGatewayId() {
        return carrierGatewayId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a core network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a core network.
     */
    public final String coreNetworkArn() {
        return coreNetworkArn;
    }

    /**
     * <p>
     * The ID of a local gateway.
     * </p>
     * 
     * @return The ID of a local gateway.
     */
    public final String localGatewayId() {
        return localGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidr());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(carrierGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRouteTableRoute)) {
            return false;
        }
        AnalysisRouteTableRoute other = (AnalysisRouteTableRoute) obj;
        return Objects.equals(destinationCidr(), other.destinationCidr())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId())
                && Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(origin(), other.origin())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId())
                && Objects.equals(state(), other.state()) && Objects.equals(carrierGatewayId(), other.carrierGatewayId())
                && Objects.equals(coreNetworkArn(), other.coreNetworkArn())
                && Objects.equals(localGatewayId(), other.localGatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRouteTableRoute").add("DestinationCidr", destinationCidr())
                .add("DestinationPrefixListId", destinationPrefixListId())
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).add("GatewayId", gatewayId())
                .add("InstanceId", instanceId()).add("NatGatewayId", natGatewayId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("Origin", origin())
                .add("TransitGatewayId", transitGatewayId()).add("VpcPeeringConnectionId", vpcPeeringConnectionId())
                .add("State", state()).add("CarrierGatewayId", carrierGatewayId()).add("CoreNetworkArn", coreNetworkArn())
                .add("LocalGatewayId", localGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidr":
            return Optional.ofNullable(clazz.cast(destinationCidr()));
        case "DestinationPrefixListId":
            return Optional.ofNullable(clazz.cast(destinationPrefixListId()));
        case "EgressOnlyInternetGatewayId":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGatewayId()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "CarrierGatewayId":
            return Optional.ofNullable(clazz.cast(carrierGatewayId()));
        case "CoreNetworkArn":
            return Optional.ofNullable(clazz.cast(coreNetworkArn()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationCidr", DESTINATION_CIDR_FIELD);
        map.put("DestinationPrefixListId", DESTINATION_PREFIX_LIST_ID_FIELD);
        map.put("EgressOnlyInternetGatewayId", EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD);
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("VpcPeeringConnectionId", VPC_PEERING_CONNECTION_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CarrierGatewayId", CARRIER_GATEWAY_ID_FIELD);
        map.put("CoreNetworkArn", CORE_NETWORK_ARN_FIELD);
        map.put("LocalGatewayId", LOCAL_GATEWAY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRouteTableRoute, T> g) {
        return obj -> g.apply((AnalysisRouteTableRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRouteTableRoute> {
        /**
         * <p>
         * The destination IPv4 address, in CIDR notation.
         * </p>
         * 
         * @param destinationCidr
         *        The destination IPv4 address, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidr(String destinationCidr);

        /**
         * <p>
         * The prefix of the Amazon Web Services service.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The prefix of the Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * The ID of an egress-only internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of an egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of the gateway, such as an internet gateway or virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway, such as an internet gateway or virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of the instance, such as a NAT instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance, such as a NAT instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of a network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Describes how the route was created. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CreateRouteTable - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * CreateRoute - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * EnableVgwRoutePropagation - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CreateRouteTable - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CreateRoute - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EnableVgwRoutePropagation - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(String origin);

        /**
         * <p>
         * The ID of a transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of a transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of a VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of a VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        /**
         * <p>
         * The state. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * active
         * </p>
         * </li>
         * <li>
         * <p>
         * blackhole
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        active
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        blackhole
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The ID of a carrier gateway.
         * </p>
         * 
         * @param carrierGatewayId
         *        The ID of a carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGatewayId(String carrierGatewayId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a core network.
         * </p>
         * 
         * @param coreNetworkArn
         *        The Amazon Resource Name (ARN) of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkArn(String coreNetworkArn);

        /**
         * <p>
         * The ID of a local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of a local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidr;

        private String destinationPrefixListId;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private String natGatewayId;

        private String networkInterfaceId;

        private String origin;

        private String transitGatewayId;

        private String vpcPeeringConnectionId;

        private String state;

        private String carrierGatewayId;

        private String coreNetworkArn;

        private String localGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRouteTableRoute model) {
            destinationCidr(model.destinationCidr);
            destinationPrefixListId(model.destinationPrefixListId);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            gatewayId(model.gatewayId);
            instanceId(model.instanceId);
            natGatewayId(model.natGatewayId);
            networkInterfaceId(model.networkInterfaceId);
            origin(model.origin);
            transitGatewayId(model.transitGatewayId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            state(model.state);
            carrierGatewayId(model.carrierGatewayId);
            coreNetworkArn(model.coreNetworkArn);
            localGatewayId(model.localGatewayId);
        }

        public final String getDestinationCidr() {
            return destinationCidr;
        }

        public final void setDestinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
        }

        @Override
        public final Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getCarrierGatewayId() {
            return carrierGatewayId;
        }

        public final void setCarrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
        }

        @Override
        public final Builder carrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        @Override
        public AnalysisRouteTableRoute build() {
            return new AnalysisRouteTableRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
