/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageUsageReportEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageUsageReportEntry> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ImageUsageReportEntry.getter(ImageUsageReportEntry::resourceType)).setter(ImageUsageReportEntry.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportId").getter(ImageUsageReportEntry.getter(ImageUsageReportEntry::reportId)).setter(ImageUsageReportEntry.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").unmarshallLocationName("reportId").build()}).build();
    private static final SdkField<Long> USAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UsageCount").getter(ImageUsageReportEntry.getter(ImageUsageReportEntry::usageCount)).setter(ImageUsageReportEntry.setter(Builder::usageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageCount").unmarshallLocationName("usageCount").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ImageUsageReportEntry.getter(ImageUsageReportEntry::accountId)).setter(ImageUsageReportEntry.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").unmarshallLocationName("accountId").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ImageUsageReportEntry.getter(ImageUsageReportEntry::imageId)).setter(ImageUsageReportEntry.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<Instant> REPORT_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReportCreationTime").getter(ImageUsageReportEntry.getter(ImageUsageReportEntry::reportCreationTime)).setter(ImageUsageReportEntry.setter(Builder::reportCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportCreationTime").unmarshallLocationName("reportCreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, REPORT_ID_FIELD, USAGE_COUNT_FIELD, ACCOUNT_ID_FIELD, IMAGE_ID_FIELD, REPORT_CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageUsageReportEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String reportId;
    private final Long usageCount;
    private final String accountId;
    private final String imageId;
    private final Instant reportCreationTime;

    private ImageUsageReportEntry(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.reportId = builder.reportId;
        this.usageCount = builder.usageCount;
        this.accountId = builder.accountId;
        this.imageId = builder.imageId;
        this.reportCreationTime = builder.reportCreationTime;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final Long usageCount() {
        return this.usageCount;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final Instant reportCreationTime() {
        return this.reportCreationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportCreationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageUsageReportEntry)) {
            return false;
        }
        ImageUsageReportEntry other = (ImageUsageReportEntry)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.usageCount(), other.usageCount()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.reportCreationTime(), other.reportCreationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ImageUsageReportEntry").add("ResourceType", (Object)this.resourceType()).add("ReportId", (Object)this.reportId()).add("UsageCount", (Object)this.usageCount()).add("AccountId", (Object)this.accountId()).add("ImageId", (Object)this.imageId()).add("ReportCreationTime", (Object)this.reportCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ReportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "UsageCount": {
                return Optional.ofNullable(clazz.cast(this.usageCount()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ReportCreationTime": {
                return Optional.ofNullable(clazz.cast(this.reportCreationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("UsageCount", USAGE_COUNT_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ReportCreationTime", REPORT_CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageUsageReportEntry, T> g) {
        return obj -> g.apply((ImageUsageReportEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String reportId;
        private Long usageCount;
        private String accountId;
        private String imageId;
        private Instant reportCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageUsageReportEntry model) {
            this.resourceType(model.resourceType);
            this.reportId(model.reportId);
            this.usageCount(model.usageCount);
            this.accountId(model.accountId);
            this.imageId(model.imageId);
            this.reportCreationTime(model.reportCreationTime);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final Long getUsageCount() {
            return this.usageCount;
        }

        public final void setUsageCount(Long usageCount) {
            this.usageCount = usageCount;
        }

        @Override
        public final Builder usageCount(Long usageCount) {
            this.usageCount = usageCount;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Instant getReportCreationTime() {
            return this.reportCreationTime;
        }

        public final void setReportCreationTime(Instant reportCreationTime) {
            this.reportCreationTime = reportCreationTime;
        }

        @Override
        public final Builder reportCreationTime(Instant reportCreationTime) {
            this.reportCreationTime = reportCreationTime;
            return this;
        }

        public ImageUsageReportEntry build() {
            return new ImageUsageReportEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageUsageReportEntry> {
        public Builder resourceType(String var1);

        public Builder reportId(String var1);

        public Builder usageCount(Long var1);

        public Builder accountId(String var1);

        public Builder imageId(String var1);

        public Builder reportCreationTime(Instant var1);
    }
}

