/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityManagerStatus;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IngestionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCapacityManagerAttributesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetCapacityManagerAttributesResponse> {
    private static final SdkField<String> CAPACITY_MANAGER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityManagerStatus").getter(GetCapacityManagerAttributesResponse.getter(GetCapacityManagerAttributesResponse::capacityManagerStatusAsString)).setter(GetCapacityManagerAttributesResponse.setter(Builder::capacityManagerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerStatus").unmarshallLocationName("capacityManagerStatus").build()}).build();
    private static final SdkField<Boolean> ORGANIZATIONS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OrganizationsAccess").getter(GetCapacityManagerAttributesResponse.getter(GetCapacityManagerAttributesResponse::organizationsAccess)).setter(GetCapacityManagerAttributesResponse.setter(Builder::organizationsAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsAccess").unmarshallLocationName("organizationsAccess").build()}).build();
    private static final SdkField<Integer> DATA_EXPORT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataExportCount").getter(GetCapacityManagerAttributesResponse.getter(GetCapacityManagerAttributesResponse::dataExportCount)).setter(GetCapacityManagerAttributesResponse.setter(Builder::dataExportCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExportCount").unmarshallLocationName("dataExportCount").build()}).build();
    private static final SdkField<String> INGESTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionStatus").getter(GetCapacityManagerAttributesResponse.getter(GetCapacityManagerAttributesResponse::ingestionStatusAsString)).setter(GetCapacityManagerAttributesResponse.setter(Builder::ingestionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatus").unmarshallLocationName("ingestionStatus").build()}).build();
    private static final SdkField<String> INGESTION_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionStatusMessage").getter(GetCapacityManagerAttributesResponse.getter(GetCapacityManagerAttributesResponse::ingestionStatusMessage)).setter(GetCapacityManagerAttributesResponse.setter(Builder::ingestionStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatusMessage").unmarshallLocationName("ingestionStatusMessage").build()}).build();
    private static final SdkField<Instant> EARLIEST_DATAPOINT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EarliestDatapointTimestamp").getter(GetCapacityManagerAttributesResponse.getter(GetCapacityManagerAttributesResponse::earliestDatapointTimestamp)).setter(GetCapacityManagerAttributesResponse.setter(Builder::earliestDatapointTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestDatapointTimestamp").unmarshallLocationName("earliestDatapointTimestamp").build()}).build();
    private static final SdkField<Instant> LATEST_DATAPOINT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestDatapointTimestamp").getter(GetCapacityManagerAttributesResponse.getter(GetCapacityManagerAttributesResponse::latestDatapointTimestamp)).setter(GetCapacityManagerAttributesResponse.setter(Builder::latestDatapointTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDatapointTimestamp").unmarshallLocationName("latestDatapointTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_MANAGER_STATUS_FIELD, ORGANIZATIONS_ACCESS_FIELD, DATA_EXPORT_COUNT_FIELD, INGESTION_STATUS_FIELD, INGESTION_STATUS_MESSAGE_FIELD, EARLIEST_DATAPOINT_TIMESTAMP_FIELD, LATEST_DATAPOINT_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCapacityManagerAttributesResponse.memberNameToFieldInitializer();
    private final String capacityManagerStatus;
    private final Boolean organizationsAccess;
    private final Integer dataExportCount;
    private final String ingestionStatus;
    private final String ingestionStatusMessage;
    private final Instant earliestDatapointTimestamp;
    private final Instant latestDatapointTimestamp;

    private GetCapacityManagerAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.capacityManagerStatus = builder.capacityManagerStatus;
        this.organizationsAccess = builder.organizationsAccess;
        this.dataExportCount = builder.dataExportCount;
        this.ingestionStatus = builder.ingestionStatus;
        this.ingestionStatusMessage = builder.ingestionStatusMessage;
        this.earliestDatapointTimestamp = builder.earliestDatapointTimestamp;
        this.latestDatapointTimestamp = builder.latestDatapointTimestamp;
    }

    public final CapacityManagerStatus capacityManagerStatus() {
        return CapacityManagerStatus.fromValue(this.capacityManagerStatus);
    }

    public final String capacityManagerStatusAsString() {
        return this.capacityManagerStatus;
    }

    public final Boolean organizationsAccess() {
        return this.organizationsAccess;
    }

    public final Integer dataExportCount() {
        return this.dataExportCount;
    }

    public final IngestionStatus ingestionStatus() {
        return IngestionStatus.fromValue(this.ingestionStatus);
    }

    public final String ingestionStatusAsString() {
        return this.ingestionStatus;
    }

    public final String ingestionStatusMessage() {
        return this.ingestionStatusMessage;
    }

    public final Instant earliestDatapointTimestamp() {
        return this.earliestDatapointTimestamp;
    }

    public final Instant latestDatapointTimestamp() {
        return this.latestDatapointTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityManagerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationsAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataExportCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestDatapointTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDatapointTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityManagerAttributesResponse)) {
            return false;
        }
        GetCapacityManagerAttributesResponse other = (GetCapacityManagerAttributesResponse)((Object)obj);
        return Objects.equals(this.capacityManagerStatusAsString(), other.capacityManagerStatusAsString()) && Objects.equals(this.organizationsAccess(), other.organizationsAccess()) && Objects.equals(this.dataExportCount(), other.dataExportCount()) && Objects.equals(this.ingestionStatusAsString(), other.ingestionStatusAsString()) && Objects.equals(this.ingestionStatusMessage(), other.ingestionStatusMessage()) && Objects.equals(this.earliestDatapointTimestamp(), other.earliestDatapointTimestamp()) && Objects.equals(this.latestDatapointTimestamp(), other.latestDatapointTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetCapacityManagerAttributesResponse").add("CapacityManagerStatus", (Object)this.capacityManagerStatusAsString()).add("OrganizationsAccess", (Object)this.organizationsAccess()).add("DataExportCount", (Object)this.dataExportCount()).add("IngestionStatus", (Object)this.ingestionStatusAsString()).add("IngestionStatusMessage", (Object)this.ingestionStatusMessage()).add("EarliestDatapointTimestamp", (Object)this.earliestDatapointTimestamp()).add("LatestDatapointTimestamp", (Object)this.latestDatapointTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityManagerStatus": {
                return Optional.ofNullable(clazz.cast(this.capacityManagerStatusAsString()));
            }
            case "OrganizationsAccess": {
                return Optional.ofNullable(clazz.cast(this.organizationsAccess()));
            }
            case "DataExportCount": {
                return Optional.ofNullable(clazz.cast(this.dataExportCount()));
            }
            case "IngestionStatus": {
                return Optional.ofNullable(clazz.cast(this.ingestionStatusAsString()));
            }
            case "IngestionStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.ingestionStatusMessage()));
            }
            case "EarliestDatapointTimestamp": {
                return Optional.ofNullable(clazz.cast(this.earliestDatapointTimestamp()));
            }
            case "LatestDatapointTimestamp": {
                return Optional.ofNullable(clazz.cast(this.latestDatapointTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityManagerStatus", CAPACITY_MANAGER_STATUS_FIELD);
        map.put("OrganizationsAccess", ORGANIZATIONS_ACCESS_FIELD);
        map.put("DataExportCount", DATA_EXPORT_COUNT_FIELD);
        map.put("IngestionStatus", INGESTION_STATUS_FIELD);
        map.put("IngestionStatusMessage", INGESTION_STATUS_MESSAGE_FIELD);
        map.put("EarliestDatapointTimestamp", EARLIEST_DATAPOINT_TIMESTAMP_FIELD);
        map.put("LatestDatapointTimestamp", LATEST_DATAPOINT_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityManagerAttributesResponse, T> g) {
        return obj -> g.apply((GetCapacityManagerAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String capacityManagerStatus;
        private Boolean organizationsAccess;
        private Integer dataExportCount;
        private String ingestionStatus;
        private String ingestionStatusMessage;
        private Instant earliestDatapointTimestamp;
        private Instant latestDatapointTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityManagerAttributesResponse model) {
            super(model);
            this.capacityManagerStatus(model.capacityManagerStatus);
            this.organizationsAccess(model.organizationsAccess);
            this.dataExportCount(model.dataExportCount);
            this.ingestionStatus(model.ingestionStatus);
            this.ingestionStatusMessage(model.ingestionStatusMessage);
            this.earliestDatapointTimestamp(model.earliestDatapointTimestamp);
            this.latestDatapointTimestamp(model.latestDatapointTimestamp);
        }

        public final String getCapacityManagerStatus() {
            return this.capacityManagerStatus;
        }

        public final void setCapacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
        }

        @Override
        public final Builder capacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
            return this;
        }

        @Override
        public final Builder capacityManagerStatus(CapacityManagerStatus capacityManagerStatus) {
            this.capacityManagerStatus(capacityManagerStatus == null ? null : capacityManagerStatus.toString());
            return this;
        }

        public final Boolean getOrganizationsAccess() {
            return this.organizationsAccess;
        }

        public final void setOrganizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
        }

        @Override
        public final Builder organizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
            return this;
        }

        public final Integer getDataExportCount() {
            return this.dataExportCount;
        }

        public final void setDataExportCount(Integer dataExportCount) {
            this.dataExportCount = dataExportCount;
        }

        @Override
        public final Builder dataExportCount(Integer dataExportCount) {
            this.dataExportCount = dataExportCount;
            return this;
        }

        public final String getIngestionStatus() {
            return this.ingestionStatus;
        }

        public final void setIngestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
        }

        @Override
        public final Builder ingestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
            return this;
        }

        @Override
        public final Builder ingestionStatus(IngestionStatus ingestionStatus) {
            this.ingestionStatus(ingestionStatus == null ? null : ingestionStatus.toString());
            return this;
        }

        public final String getIngestionStatusMessage() {
            return this.ingestionStatusMessage;
        }

        public final void setIngestionStatusMessage(String ingestionStatusMessage) {
            this.ingestionStatusMessage = ingestionStatusMessage;
        }

        @Override
        public final Builder ingestionStatusMessage(String ingestionStatusMessage) {
            this.ingestionStatusMessage = ingestionStatusMessage;
            return this;
        }

        public final Instant getEarliestDatapointTimestamp() {
            return this.earliestDatapointTimestamp;
        }

        public final void setEarliestDatapointTimestamp(Instant earliestDatapointTimestamp) {
            this.earliestDatapointTimestamp = earliestDatapointTimestamp;
        }

        @Override
        public final Builder earliestDatapointTimestamp(Instant earliestDatapointTimestamp) {
            this.earliestDatapointTimestamp = earliestDatapointTimestamp;
            return this;
        }

        public final Instant getLatestDatapointTimestamp() {
            return this.latestDatapointTimestamp;
        }

        public final void setLatestDatapointTimestamp(Instant latestDatapointTimestamp) {
            this.latestDatapointTimestamp = latestDatapointTimestamp;
        }

        @Override
        public final Builder latestDatapointTimestamp(Instant latestDatapointTimestamp) {
            this.latestDatapointTimestamp = latestDatapointTimestamp;
            return this;
        }

        @Override
        public GetCapacityManagerAttributesResponse build() {
            return new GetCapacityManagerAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCapacityManagerAttributesResponse> {
        public Builder capacityManagerStatus(String var1);

        public Builder capacityManagerStatus(CapacityManagerStatus var1);

        public Builder organizationsAccess(Boolean var1);

        public Builder dataExportCount(Integer var1);

        public Builder ingestionStatus(String var1);

        public Builder ingestionStatus(IngestionStatus var1);

        public Builder ingestionStatusMessage(String var1);

        public Builder earliestDatapointTimestamp(Instant var1);

        public Builder latestDatapointTimestamp(Instant var1);
    }
}

