/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum VpcBlockPublicAccessExclusionState {
    CREATE_IN_PROGRESS("create-in-progress"),

    CREATE_COMPLETE("create-complete"),

    CREATE_FAILED("create-failed"),

    UPDATE_IN_PROGRESS("update-in-progress"),

    UPDATE_COMPLETE("update-complete"),

    UPDATE_FAILED("update-failed"),

    DELETE_IN_PROGRESS("delete-in-progress"),

    DELETE_COMPLETE("delete-complete"),

    DISABLE_IN_PROGRESS("disable-in-progress"),

    DISABLE_COMPLETE("disable-complete"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VpcBlockPublicAccessExclusionState> VALUE_MAP = EnumUtils.uniqueIndex(
            VpcBlockPublicAccessExclusionState.class, VpcBlockPublicAccessExclusionState::toString);

    private final String value;

    private VpcBlockPublicAccessExclusionState(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return VpcBlockPublicAccessExclusionState corresponding to the value
     */
    public static VpcBlockPublicAccessExclusionState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link VpcBlockPublicAccessExclusionState}s
     */
    public static Set<VpcBlockPublicAccessExclusionState> knownValues() {
        Set<VpcBlockPublicAccessExclusionState> knownValues = EnumSet.allOf(VpcBlockPublicAccessExclusionState.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
