/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpnGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpnGatewaysResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpnGatewaysResponse.Builder, DescribeVpnGatewaysResponse> {
    private static final SdkField<List<VpnGateway>> VPN_GATEWAYS_FIELD = SdkField
            .<List<VpnGateway>> builder(MarshallingType.LIST)
            .memberName("VpnGateways")
            .getter(getter(DescribeVpnGatewaysResponse::vpnGateways))
            .setter(setter(Builder::vpnGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewaySet")
                    .unmarshallLocationName("vpnGatewaySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpnGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpnGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_GATEWAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VpnGateway> vpnGateways;

    private DescribeVpnGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.vpnGateways = builder.vpnGateways;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpnGateways property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpnGateways() {
        return vpnGateways != null && !(vpnGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about one or more virtual private gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpnGateways} method.
     * </p>
     * 
     * @return Information about one or more virtual private gateways.
     */
    public final List<VpnGateway> vpnGateways() {
        return vpnGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpnGateways() ? vpnGateways() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysResponse)) {
            return false;
        }
        DescribeVpnGatewaysResponse other = (DescribeVpnGatewaysResponse) obj;
        return hasVpnGateways() == other.hasVpnGateways() && Objects.equals(vpnGateways(), other.vpnGateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpnGatewaysResponse").add("VpnGateways", hasVpnGateways() ? vpnGateways() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnGateways":
            return Optional.ofNullable(clazz.cast(vpnGateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpnGatewaySet", VPN_GATEWAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeVpnGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpnGatewaysResponse> {
        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * 
         * @param vpnGateways
         *        Information about one or more virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateways(Collection<VpnGateway> vpnGateways);

        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * 
         * @param vpnGateways
         *        Information about one or more virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateways(VpnGateway... vpnGateways);

        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VpnGateway.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.VpnGateway#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VpnGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #vpnGateways(List<VpnGateway>)}.
         * 
         * @param vpnGateways
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VpnGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnGateways(java.util.Collection<VpnGateway>)
         */
        Builder vpnGateways(Consumer<VpnGateway.Builder>... vpnGateways);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VpnGateway> vpnGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysResponse model) {
            super(model);
            vpnGateways(model.vpnGateways);
        }

        public final List<VpnGateway.Builder> getVpnGateways() {
            List<VpnGateway.Builder> result = VpnGatewayListCopier.copyToBuilder(this.vpnGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpnGateways(Collection<VpnGateway.BuilderImpl> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copyFromBuilder(vpnGateways);
        }

        @Override
        public final Builder vpnGateways(Collection<VpnGateway> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copy(vpnGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(VpnGateway... vpnGateways) {
            vpnGateways(Arrays.asList(vpnGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(Consumer<VpnGateway.Builder>... vpnGateways) {
            vpnGateways(Stream.of(vpnGateways).map(c -> VpnGateway.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpnGatewaysResponse build() {
            return new DescribeVpnGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
