/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for Verified Access logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessLogs implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessLogs.Builder, VerifiedAccessLogs> {
    private static final SdkField<VerifiedAccessLogS3Destination> S3_FIELD = SdkField
            .<VerifiedAccessLogS3Destination> builder(MarshallingType.SDK_POJO)
            .memberName("S3")
            .getter(getter(VerifiedAccessLogs::s3))
            .setter(setter(Builder::s3))
            .constructor(VerifiedAccessLogS3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").unmarshallLocationName("s3")
                    .build()).build();

    private static final SdkField<VerifiedAccessLogCloudWatchLogsDestination> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<VerifiedAccessLogCloudWatchLogsDestination> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLogs")
            .getter(getter(VerifiedAccessLogs::cloudWatchLogs))
            .setter(setter(Builder::cloudWatchLogs))
            .constructor(VerifiedAccessLogCloudWatchLogsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogs")
                    .unmarshallLocationName("cloudWatchLogs").build()).build();

    private static final SdkField<VerifiedAccessLogKinesisDataFirehoseDestination> KINESIS_DATA_FIREHOSE_FIELD = SdkField
            .<VerifiedAccessLogKinesisDataFirehoseDestination> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisDataFirehose")
            .getter(getter(VerifiedAccessLogs::kinesisDataFirehose))
            .setter(setter(Builder::kinesisDataFirehose))
            .constructor(VerifiedAccessLogKinesisDataFirehoseDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataFirehose")
                    .unmarshallLocationName("kinesisDataFirehose").build()).build();

    private static final SdkField<String> LOG_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LogVersion")
            .getter(getter(VerifiedAccessLogs::logVersion))
            .setter(setter(Builder::logVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogVersion")
                    .unmarshallLocationName("logVersion").build()).build();

    private static final SdkField<Boolean> INCLUDE_TRUST_CONTEXT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeTrustContext")
            .getter(getter(VerifiedAccessLogs::includeTrustContext))
            .setter(setter(Builder::includeTrustContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTrustContext")
                    .unmarshallLocationName("includeTrustContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD,
            CLOUD_WATCH_LOGS_FIELD, KINESIS_DATA_FIREHOSE_FIELD, LOG_VERSION_FIELD, INCLUDE_TRUST_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VerifiedAccessLogS3Destination s3;

    private final VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs;

    private final VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose;

    private final String logVersion;

    private final Boolean includeTrustContext;

    private VerifiedAccessLogs(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.kinesisDataFirehose = builder.kinesisDataFirehose;
        this.logVersion = builder.logVersion;
        this.includeTrustContext = builder.includeTrustContext;
    }

    /**
     * <p>
     * Amazon S3 logging options.
     * </p>
     * 
     * @return Amazon S3 logging options.
     */
    public final VerifiedAccessLogS3Destination s3() {
        return s3;
    }

    /**
     * <p>
     * CloudWatch Logs logging destination.
     * </p>
     * 
     * @return CloudWatch Logs logging destination.
     */
    public final VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Kinesis logging destination.
     * </p>
     * 
     * @return Kinesis logging destination.
     */
    public final VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose() {
        return kinesisDataFirehose;
    }

    /**
     * <p>
     * The log version.
     * </p>
     * 
     * @return The log version.
     */
    public final String logVersion() {
        return logVersion;
    }

    /**
     * <p>
     * Indicates whether trust data is included in the logs.
     * </p>
     * 
     * @return Indicates whether trust data is included in the logs.
     */
    public final Boolean includeTrustContext() {
        return includeTrustContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisDataFirehose());
        hashCode = 31 * hashCode + Objects.hashCode(logVersion());
        hashCode = 31 * hashCode + Objects.hashCode(includeTrustContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessLogs)) {
            return false;
        }
        VerifiedAccessLogs other = (VerifiedAccessLogs) obj;
        return Objects.equals(s3(), other.s3()) && Objects.equals(cloudWatchLogs(), other.cloudWatchLogs())
                && Objects.equals(kinesisDataFirehose(), other.kinesisDataFirehose())
                && Objects.equals(logVersion(), other.logVersion())
                && Objects.equals(includeTrustContext(), other.includeTrustContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessLogs").add("S3", s3()).add("CloudWatchLogs", cloudWatchLogs())
                .add("KinesisDataFirehose", kinesisDataFirehose()).add("LogVersion", logVersion())
                .add("IncludeTrustContext", includeTrustContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "CloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "KinesisDataFirehose":
            return Optional.ofNullable(clazz.cast(kinesisDataFirehose()));
        case "LogVersion":
            return Optional.ofNullable(clazz.cast(logVersion()));
        case "IncludeTrustContext":
            return Optional.ofNullable(clazz.cast(includeTrustContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3", S3_FIELD);
        map.put("CloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("KinesisDataFirehose", KINESIS_DATA_FIREHOSE_FIELD);
        map.put("LogVersion", LOG_VERSION_FIELD);
        map.put("IncludeTrustContext", INCLUDE_TRUST_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessLogs, T> g) {
        return obj -> g.apply((VerifiedAccessLogs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessLogs> {
        /**
         * <p>
         * Amazon S3 logging options.
         * </p>
         * 
         * @param s3
         *        Amazon S3 logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(VerifiedAccessLogS3Destination s3);

        /**
         * <p>
         * Amazon S3 logging options.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerifiedAccessLogS3Destination.Builder}
         * avoiding the need to create one manually via {@link VerifiedAccessLogS3Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessLogS3Destination.Builder#build()} is called
         * immediately and its result is passed to {@link #s3(VerifiedAccessLogS3Destination)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link VerifiedAccessLogS3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(VerifiedAccessLogS3Destination)
         */
        default Builder s3(Consumer<VerifiedAccessLogS3Destination.Builder> s3) {
            return s3(VerifiedAccessLogS3Destination.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * CloudWatch Logs logging destination.
         * </p>
         * 
         * @param cloudWatchLogs
         *        CloudWatch Logs logging destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs);

        /**
         * <p>
         * CloudWatch Logs logging destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessLogCloudWatchLogsDestination.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessLogCloudWatchLogsDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessLogCloudWatchLogsDestination.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link VerifiedAccessLogCloudWatchLogsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination)
         */
        default Builder cloudWatchLogs(Consumer<VerifiedAccessLogCloudWatchLogsDestination.Builder> cloudWatchLogs) {
            return cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * Kinesis logging destination.
         * </p>
         * 
         * @param kinesisDataFirehose
         *        Kinesis logging destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose);

        /**
         * <p>
         * Kinesis logging destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessLogKinesisDataFirehoseDestination.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessLogKinesisDataFirehoseDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessLogKinesisDataFirehoseDestination.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination)}.
         * 
         * @param kinesisDataFirehose
         *        a consumer that will call methods on {@link VerifiedAccessLogKinesisDataFirehoseDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination)
         */
        default Builder kinesisDataFirehose(Consumer<VerifiedAccessLogKinesisDataFirehoseDestination.Builder> kinesisDataFirehose) {
            return kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination.builder()
                    .applyMutation(kinesisDataFirehose).build());
        }

        /**
         * <p>
         * The log version.
         * </p>
         * 
         * @param logVersion
         *        The log version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logVersion(String logVersion);

        /**
         * <p>
         * Indicates whether trust data is included in the logs.
         * </p>
         * 
         * @param includeTrustContext
         *        Indicates whether trust data is included in the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTrustContext(Boolean includeTrustContext);
    }

    static final class BuilderImpl implements Builder {
        private VerifiedAccessLogS3Destination s3;

        private VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs;

        private VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose;

        private String logVersion;

        private Boolean includeTrustContext;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessLogs model) {
            s3(model.s3);
            cloudWatchLogs(model.cloudWatchLogs);
            kinesisDataFirehose(model.kinesisDataFirehose);
            logVersion(model.logVersion);
            includeTrustContext(model.includeTrustContext);
        }

        public final VerifiedAccessLogS3Destination.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(VerifiedAccessLogS3Destination.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(VerifiedAccessLogS3Destination s3) {
            this.s3 = s3;
            return this;
        }

        public final VerifiedAccessLogCloudWatchLogsDestination.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final VerifiedAccessLogKinesisDataFirehoseDestination.Builder getKinesisDataFirehose() {
            return kinesisDataFirehose != null ? kinesisDataFirehose.toBuilder() : null;
        }

        public final void setKinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination.BuilderImpl kinesisDataFirehose) {
            this.kinesisDataFirehose = kinesisDataFirehose != null ? kinesisDataFirehose.build() : null;
        }

        @Override
        public final Builder kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose) {
            this.kinesisDataFirehose = kinesisDataFirehose;
            return this;
        }

        public final String getLogVersion() {
            return logVersion;
        }

        public final void setLogVersion(String logVersion) {
            this.logVersion = logVersion;
        }

        @Override
        public final Builder logVersion(String logVersion) {
            this.logVersion = logVersion;
            return this;
        }

        public final Boolean getIncludeTrustContext() {
            return includeTrustContext;
        }

        public final void setIncludeTrustContext(Boolean includeTrustContext) {
            this.includeTrustContext = includeTrustContext;
        }

        @Override
        public final Builder includeTrustContext(Boolean includeTrustContext) {
            this.includeTrustContext = includeTrustContext;
            return this;
        }

        @Override
        public VerifiedAccessLogs build() {
            return new VerifiedAccessLogs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
