/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes associated with an Elastic IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<AddressAttribute.Builder, AddressAttribute> {
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(AddressAttribute::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(AddressAttribute::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("allocationId").build()).build();

    private static final SdkField<String> PTR_RECORD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PtrRecord")
            .getter(getter(AddressAttribute::ptrRecord))
            .setter(setter(Builder::ptrRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PtrRecord")
                    .unmarshallLocationName("ptrRecord").build()).build();

    private static final SdkField<PtrUpdateStatus> PTR_RECORD_UPDATE_FIELD = SdkField
            .<PtrUpdateStatus> builder(MarshallingType.SDK_POJO)
            .memberName("PtrRecordUpdate")
            .getter(getter(AddressAttribute::ptrRecordUpdate))
            .setter(setter(Builder::ptrRecordUpdate))
            .constructor(PtrUpdateStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PtrRecordUpdate")
                    .unmarshallLocationName("ptrRecordUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IP_FIELD,
            ALLOCATION_ID_FIELD, PTR_RECORD_FIELD, PTR_RECORD_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String publicIp;

    private final String allocationId;

    private final String ptrRecord;

    private final PtrUpdateStatus ptrRecordUpdate;

    private AddressAttribute(BuilderImpl builder) {
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.ptrRecord = builder.ptrRecord;
        this.ptrRecordUpdate = builder.ptrRecordUpdate;
    }

    /**
     * <p>
     * The public IP address.
     * </p>
     * 
     * @return The public IP address.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * [EC2-VPC] The allocation ID.
     * </p>
     * 
     * @return [EC2-VPC] The allocation ID.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The pointer (PTR) record for the IP address.
     * </p>
     * 
     * @return The pointer (PTR) record for the IP address.
     */
    public final String ptrRecord() {
        return ptrRecord;
    }

    /**
     * <p>
     * The updated PTR record for the IP address.
     * </p>
     * 
     * @return The updated PTR record for the IP address.
     */
    public final PtrUpdateStatus ptrRecordUpdate() {
        return ptrRecordUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(ptrRecord());
        hashCode = 31 * hashCode + Objects.hashCode(ptrRecordUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressAttribute)) {
            return false;
        }
        AddressAttribute other = (AddressAttribute) obj;
        return Objects.equals(publicIp(), other.publicIp()) && Objects.equals(allocationId(), other.allocationId())
                && Objects.equals(ptrRecord(), other.ptrRecord()) && Objects.equals(ptrRecordUpdate(), other.ptrRecordUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressAttribute").add("PublicIp", publicIp()).add("AllocationId", allocationId())
                .add("PtrRecord", ptrRecord()).add("PtrRecordUpdate", ptrRecordUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "PtrRecord":
            return Optional.ofNullable(clazz.cast(ptrRecord()));
        case "PtrRecordUpdate":
            return Optional.ofNullable(clazz.cast(ptrRecordUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublicIp", PUBLIC_IP_FIELD);
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("PtrRecord", PTR_RECORD_FIELD);
        map.put("PtrRecordUpdate", PTR_RECORD_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressAttribute, T> g) {
        return obj -> g.apply((AddressAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressAttribute> {
        /**
         * <p>
         * The public IP address.
         * </p>
         * 
         * @param publicIp
         *        The public IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * [EC2-VPC] The allocation ID.
         * </p>
         * 
         * @param allocationId
         *        [EC2-VPC] The allocation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The pointer (PTR) record for the IP address.
         * </p>
         * 
         * @param ptrRecord
         *        The pointer (PTR) record for the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ptrRecord(String ptrRecord);

        /**
         * <p>
         * The updated PTR record for the IP address.
         * </p>
         * 
         * @param ptrRecordUpdate
         *        The updated PTR record for the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ptrRecordUpdate(PtrUpdateStatus ptrRecordUpdate);

        /**
         * <p>
         * The updated PTR record for the IP address.
         * </p>
         * This is a convenience method that creates an instance of the {@link PtrUpdateStatus.Builder} avoiding the
         * need to create one manually via {@link PtrUpdateStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PtrUpdateStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #ptrRecordUpdate(PtrUpdateStatus)}.
         * 
         * @param ptrRecordUpdate
         *        a consumer that will call methods on {@link PtrUpdateStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ptrRecordUpdate(PtrUpdateStatus)
         */
        default Builder ptrRecordUpdate(Consumer<PtrUpdateStatus.Builder> ptrRecordUpdate) {
            return ptrRecordUpdate(PtrUpdateStatus.builder().applyMutation(ptrRecordUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String publicIp;

        private String allocationId;

        private String ptrRecord;

        private PtrUpdateStatus ptrRecordUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressAttribute model) {
            publicIp(model.publicIp);
            allocationId(model.allocationId);
            ptrRecord(model.ptrRecord);
            ptrRecordUpdate(model.ptrRecordUpdate);
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getPtrRecord() {
            return ptrRecord;
        }

        public final void setPtrRecord(String ptrRecord) {
            this.ptrRecord = ptrRecord;
        }

        @Override
        public final Builder ptrRecord(String ptrRecord) {
            this.ptrRecord = ptrRecord;
            return this;
        }

        public final PtrUpdateStatus.Builder getPtrRecordUpdate() {
            return ptrRecordUpdate != null ? ptrRecordUpdate.toBuilder() : null;
        }

        public final void setPtrRecordUpdate(PtrUpdateStatus.BuilderImpl ptrRecordUpdate) {
            this.ptrRecordUpdate = ptrRecordUpdate != null ? ptrRecordUpdate.build() : null;
        }

        @Override
        public final Builder ptrRecordUpdate(PtrUpdateStatus ptrRecordUpdate) {
            this.ptrRecordUpdate = ptrRecordUpdate;
            return this;
        }

        @Override
        public AddressAttribute build() {
            return new AddressAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
