/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterfaceAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterfaceAssociation> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(NetworkInterfaceAssociation.getter(NetworkInterfaceAssociation::allocationId)).setter(NetworkInterfaceAssociation.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(NetworkInterfaceAssociation.getter(NetworkInterfaceAssociation::associationId)).setter(NetworkInterfaceAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> IP_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpOwnerId").getter(NetworkInterfaceAssociation.getter(NetworkInterfaceAssociation::ipOwnerId)).setter(NetworkInterfaceAssociation.setter(Builder::ipOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpOwnerId").unmarshallLocationName("ipOwnerId").build()}).build();
    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicDnsName").getter(NetworkInterfaceAssociation.getter(NetworkInterfaceAssociation::publicDnsName)).setter(NetworkInterfaceAssociation.setter(Builder::publicDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDnsName").unmarshallLocationName("publicDnsName").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(NetworkInterfaceAssociation.getter(NetworkInterfaceAssociation::publicIp)).setter(NetworkInterfaceAssociation.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIp").getter(NetworkInterfaceAssociation.getter(NetworkInterfaceAssociation::customerOwnedIp)).setter(NetworkInterfaceAssociation.setter(Builder::customerOwnedIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIp").unmarshallLocationName("customerOwnedIp").build()}).build();
    private static final SdkField<String> CARRIER_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CarrierIp").getter(NetworkInterfaceAssociation.getter(NetworkInterfaceAssociation::carrierIp)).setter(NetworkInterfaceAssociation.setter(Builder::carrierIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierIp").unmarshallLocationName("carrierIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, ASSOCIATION_ID_FIELD, IP_OWNER_ID_FIELD, PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_FIELD, CUSTOMER_OWNED_IP_FIELD, CARRIER_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkInterfaceAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String allocationId;
    private final String associationId;
    private final String ipOwnerId;
    private final String publicDnsName;
    private final String publicIp;
    private final String customerOwnedIp;
    private final String carrierIp;

    private NetworkInterfaceAssociation(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
        this.customerOwnedIp = builder.customerOwnedIp;
        this.carrierIp = builder.carrierIp;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String ipOwnerId() {
        return this.ipOwnerId;
    }

    public final String publicDnsName() {
        return this.publicDnsName;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final String customerOwnedIp() {
        return this.customerOwnedIp;
    }

    public final String carrierIp() {
        return this.carrierIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrierIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAssociation)) {
            return false;
        }
        NetworkInterfaceAssociation other = (NetworkInterfaceAssociation)obj;
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.ipOwnerId(), other.ipOwnerId()) && Objects.equals(this.publicDnsName(), other.publicDnsName()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.customerOwnedIp(), other.customerOwnedIp()) && Objects.equals(this.carrierIp(), other.carrierIp());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInterfaceAssociation").add("AllocationId", (Object)this.allocationId()).add("AssociationId", (Object)this.associationId()).add("IpOwnerId", (Object)this.ipOwnerId()).add("PublicDnsName", (Object)this.publicDnsName()).add("PublicIp", (Object)this.publicIp()).add("CustomerOwnedIp", (Object)this.customerOwnedIp()).add("CarrierIp", (Object)this.carrierIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "IpOwnerId": {
                return Optional.ofNullable(clazz.cast(this.ipOwnerId()));
            }
            case "PublicDnsName": {
                return Optional.ofNullable(clazz.cast(this.publicDnsName()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "CustomerOwnedIp": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIp()));
            }
            case "CarrierIp": {
                return Optional.ofNullable(clazz.cast(this.carrierIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("IpOwnerId", IP_OWNER_ID_FIELD);
        map.put("PublicDnsName", PUBLIC_DNS_NAME_FIELD);
        map.put("PublicIp", PUBLIC_IP_FIELD);
        map.put("CustomerOwnedIp", CUSTOMER_OWNED_IP_FIELD);
        map.put("CarrierIp", CARRIER_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfaceAssociation, T> g) {
        return obj -> g.apply((NetworkInterfaceAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String associationId;
        private String ipOwnerId;
        private String publicDnsName;
        private String publicIp;
        private String customerOwnedIp;
        private String carrierIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAssociation model) {
            this.allocationId(model.allocationId);
            this.associationId(model.associationId);
            this.ipOwnerId(model.ipOwnerId);
            this.publicDnsName(model.publicDnsName);
            this.publicIp(model.publicIp);
            this.customerOwnedIp(model.customerOwnedIp);
            this.carrierIp(model.carrierIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getIpOwnerId() {
            return this.ipOwnerId;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getCustomerOwnedIp() {
            return this.customerOwnedIp;
        }

        public final void setCustomerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
        }

        @Override
        public final Builder customerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
            return this;
        }

        public final String getCarrierIp() {
            return this.carrierIp;
        }

        public final void setCarrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
        }

        @Override
        public final Builder carrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
            return this;
        }

        public NetworkInterfaceAssociation build() {
            return new NetworkInterfaceAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterfaceAssociation> {
        public Builder allocationId(String var1);

        public Builder associationId(String var1);

        public Builder ipOwnerId(String var1);

        public Builder publicDnsName(String var1);

        public Builder publicIp(String var1);

        public Builder customerOwnedIp(String var1);

        public Builder carrierIp(String var1);
    }
}

