/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single entry in an image usage report, detailing how an image is being used by a specific Amazon Web Services
 * account and resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageUsageReportEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageUsageReportEntry.Builder, ImageUsageReportEntry> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(ImageUsageReportEntry::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> REPORT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReportId")
            .getter(getter(ImageUsageReportEntry::reportId))
            .setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId")
                    .unmarshallLocationName("reportId").build()).build();

    private static final SdkField<Long> USAGE_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("UsageCount")
            .getter(getter(ImageUsageReportEntry::usageCount))
            .setter(setter(Builder::usageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageCount")
                    .unmarshallLocationName("usageCount").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(ImageUsageReportEntry::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId")
                    .unmarshallLocationName("accountId").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ImageUsageReportEntry::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<Instant> REPORT_CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReportCreationTime")
            .getter(getter(ImageUsageReportEntry::reportCreationTime))
            .setter(setter(Builder::reportCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportCreationTime")
                    .unmarshallLocationName("reportCreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            REPORT_ID_FIELD, USAGE_COUNT_FIELD, ACCOUNT_ID_FIELD, IMAGE_ID_FIELD, REPORT_CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String reportId;

    private final Long usageCount;

    private final String accountId;

    private final String imageId;

    private final Instant reportCreationTime;

    private ImageUsageReportEntry(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.reportId = builder.reportId;
        this.usageCount = builder.usageCount;
        this.accountId = builder.accountId;
        this.imageId = builder.imageId;
        this.reportCreationTime = builder.reportCreationTime;
    }

    /**
     * <p>
     * The type of resource (<code>ec2:Instance</code> or <code>ec2:LaunchTemplate</code>).
     * </p>
     * 
     * @return The type of resource (<code>ec2:Instance</code> or <code>ec2:LaunchTemplate</code>).
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the report.
     * </p>
     * 
     * @return The ID of the report.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * The number of times resources of this type reference this image in the account.
     * </p>
     * 
     * @return The number of times resources of this type reference this image in the account.
     */
    public final Long usageCount() {
        return usageCount;
    }

    /**
     * <p>
     * The ID of the account that uses the image.
     * </p>
     * 
     * @return The ID of the account that uses the image.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the image.
     * </p>
     * 
     * @return The ID of the image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The date and time the report creation was initiated.
     * </p>
     * 
     * @return The date and time the report creation was initiated.
     */
    public final Instant reportCreationTime() {
        return reportCreationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(usageCount());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(reportCreationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageUsageReportEntry)) {
            return false;
        }
        ImageUsageReportEntry other = (ImageUsageReportEntry) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(reportId(), other.reportId())
                && Objects.equals(usageCount(), other.usageCount()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(reportCreationTime(), other.reportCreationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageUsageReportEntry").add("ResourceType", resourceType()).add("ReportId", reportId())
                .add("UsageCount", usageCount()).add("AccountId", accountId()).add("ImageId", imageId())
                .add("ReportCreationTime", reportCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ReportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "UsageCount":
            return Optional.ofNullable(clazz.cast(usageCount()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ReportCreationTime":
            return Optional.ofNullable(clazz.cast(reportCreationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("UsageCount", USAGE_COUNT_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ReportCreationTime", REPORT_CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageUsageReportEntry, T> g) {
        return obj -> g.apply((ImageUsageReportEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageUsageReportEntry> {
        /**
         * <p>
         * The type of resource (<code>ec2:Instance</code> or <code>ec2:LaunchTemplate</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (<code>ec2:Instance</code> or <code>ec2:LaunchTemplate</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the report.
         * </p>
         * 
         * @param reportId
         *        The ID of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * The number of times resources of this type reference this image in the account.
         * </p>
         * 
         * @param usageCount
         *        The number of times resources of this type reference this image in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageCount(Long usageCount);

        /**
         * <p>
         * The ID of the account that uses the image.
         * </p>
         * 
         * @param accountId
         *        The ID of the account that uses the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the image.
         * </p>
         * 
         * @param imageId
         *        The ID of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The date and time the report creation was initiated.
         * </p>
         * 
         * @param reportCreationTime
         *        The date and time the report creation was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportCreationTime(Instant reportCreationTime);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String reportId;

        private Long usageCount;

        private String accountId;

        private String imageId;

        private Instant reportCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageUsageReportEntry model) {
            resourceType(model.resourceType);
            reportId(model.reportId);
            usageCount(model.usageCount);
            accountId(model.accountId);
            imageId(model.imageId);
            reportCreationTime(model.reportCreationTime);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final Long getUsageCount() {
            return usageCount;
        }

        public final void setUsageCount(Long usageCount) {
            this.usageCount = usageCount;
        }

        @Override
        public final Builder usageCount(Long usageCount) {
            this.usageCount = usageCount;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Instant getReportCreationTime() {
            return reportCreationTime;
        }

        public final void setReportCreationTime(Instant reportCreationTime) {
            this.reportCreationTime = reportCreationTime;
        }

        @Override
        public final Builder reportCreationTime(Instant reportCreationTime) {
            this.reportCreationTime = reportCreationTime;
            return this;
        }

        @Override
        public ImageUsageReportEntry build() {
            return new ImageUsageReportEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
