/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maximum age for allowed images.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreationDateConditionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CreationDateConditionRequest.Builder, CreationDateConditionRequest> {
    private static final SdkField<Integer> MAXIMUM_DAYS_SINCE_CREATED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumDaysSinceCreated")
            .getter(getter(CreationDateConditionRequest::maximumDaysSinceCreated))
            .setter(setter(Builder::maximumDaysSinceCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumDaysSinceCreated")
                    .unmarshallLocationName("MaximumDaysSinceCreated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MAXIMUM_DAYS_SINCE_CREATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumDaysSinceCreated;

    private CreationDateConditionRequest(BuilderImpl builder) {
        this.maximumDaysSinceCreated = builder.maximumDaysSinceCreated;
    }

    /**
     * <p>
     * The maximum number of days that have elapsed since the image was created. For example, a value of
     * <code>300</code> allows images that were created within the last 300 days.
     * </p>
     * 
     * @return The maximum number of days that have elapsed since the image was created. For example, a value of
     *         <code>300</code> allows images that were created within the last 300 days.
     */
    public final Integer maximumDaysSinceCreated() {
        return maximumDaysSinceCreated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumDaysSinceCreated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreationDateConditionRequest)) {
            return false;
        }
        CreationDateConditionRequest other = (CreationDateConditionRequest) obj;
        return Objects.equals(maximumDaysSinceCreated(), other.maximumDaysSinceCreated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreationDateConditionRequest").add("MaximumDaysSinceCreated", maximumDaysSinceCreated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumDaysSinceCreated":
            return Optional.ofNullable(clazz.cast(maximumDaysSinceCreated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaximumDaysSinceCreated", MAXIMUM_DAYS_SINCE_CREATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreationDateConditionRequest, T> g) {
        return obj -> g.apply((CreationDateConditionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreationDateConditionRequest> {
        /**
         * <p>
         * The maximum number of days that have elapsed since the image was created. For example, a value of
         * <code>300</code> allows images that were created within the last 300 days.
         * </p>
         * 
         * @param maximumDaysSinceCreated
         *        The maximum number of days that have elapsed since the image was created. For example, a value of
         *        <code>300</code> allows images that were created within the last 300 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumDaysSinceCreated(Integer maximumDaysSinceCreated);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumDaysSinceCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(CreationDateConditionRequest model) {
            maximumDaysSinceCreated(model.maximumDaysSinceCreated);
        }

        public final Integer getMaximumDaysSinceCreated() {
            return maximumDaysSinceCreated;
        }

        public final void setMaximumDaysSinceCreated(Integer maximumDaysSinceCreated) {
            this.maximumDaysSinceCreated = maximumDaysSinceCreated;
        }

        @Override
        public final Builder maximumDaysSinceCreated(Integer maximumDaysSinceCreated) {
            this.maximumDaysSinceCreated = maximumDaysSinceCreated;
            return this;
        }

        @Override
        public CreationDateConditionRequest build() {
            return new CreationDateConditionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
