/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReplacementStrategy {
    LAUNCH("launch"),
    LAUNCH_BEFORE_TERMINATE("launch-before-terminate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReplacementStrategy> VALUE_MAP;
    private final String value;

    private ReplacementStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReplacementStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReplacementStrategy> knownValues() {
        EnumSet<ReplacementStrategy> knownValues = EnumSet.allOf(ReplacementStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReplacementStrategy.class, ReplacementStrategy::toString);
    }
}

