/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImageReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageReferencesResponse;
import software.amazon.awssdk.services.ec2.model.ImageReference;

public class DescribeImageReferencesIterable
implements SdkIterable<DescribeImageReferencesResponse> {
    private final Ec2Client client;
    private final DescribeImageReferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImageReferencesIterable(Ec2Client client, DescribeImageReferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImageReferencesResponseFetcher();
    }

    public Iterator<DescribeImageReferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageReference> imageReferences() {
        Function<DescribeImageReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageReferences() != null) {
                return response.imageReferences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImageReferencesResponseFetcher
    implements SyncPageFetcher<DescribeImageReferencesResponse> {
        private DescribeImageReferencesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImageReferencesResponse nextPage(DescribeImageReferencesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageReferencesIterable.this.client.describeImageReferences(DescribeImageReferencesIterable.this.firstRequest);
            }
            return DescribeImageReferencesIterable.this.client.describeImageReferences((DescribeImageReferencesRequest)((Object)DescribeImageReferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

