/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.FleetStateCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFleetSuccessItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteFleetSuccessItem> {
    private static final SdkField<String> CURRENT_FLEET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentFleetState").getter(DeleteFleetSuccessItem.getter(DeleteFleetSuccessItem::currentFleetStateAsString)).setter(DeleteFleetSuccessItem.setter(Builder::currentFleetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFleetState").unmarshallLocationName("currentFleetState").build()}).build();
    private static final SdkField<String> PREVIOUS_FLEET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousFleetState").getter(DeleteFleetSuccessItem.getter(DeleteFleetSuccessItem::previousFleetStateAsString)).setter(DeleteFleetSuccessItem.setter(Builder::previousFleetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousFleetState").unmarshallLocationName("previousFleetState").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(DeleteFleetSuccessItem.getter(DeleteFleetSuccessItem::fleetId)).setter(DeleteFleetSuccessItem.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").unmarshallLocationName("fleetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FLEET_STATE_FIELD, PREVIOUS_FLEET_STATE_FIELD, FLEET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteFleetSuccessItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currentFleetState;
    private final String previousFleetState;
    private final String fleetId;

    private DeleteFleetSuccessItem(BuilderImpl builder) {
        this.currentFleetState = builder.currentFleetState;
        this.previousFleetState = builder.previousFleetState;
        this.fleetId = builder.fleetId;
    }

    public final FleetStateCode currentFleetState() {
        return FleetStateCode.fromValue(this.currentFleetState);
    }

    public final String currentFleetStateAsString() {
        return this.currentFleetState;
    }

    public final FleetStateCode previousFleetState() {
        return FleetStateCode.fromValue(this.previousFleetState);
    }

    public final String previousFleetStateAsString() {
        return this.previousFleetState;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetSuccessItem)) {
            return false;
        }
        DeleteFleetSuccessItem other = (DeleteFleetSuccessItem)obj;
        return Objects.equals(this.currentFleetStateAsString(), other.currentFleetStateAsString()) && Objects.equals(this.previousFleetStateAsString(), other.previousFleetStateAsString()) && Objects.equals(this.fleetId(), other.fleetId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFleetSuccessItem").add("CurrentFleetState", (Object)this.currentFleetStateAsString()).add("PreviousFleetState", (Object)this.previousFleetStateAsString()).add("FleetId", (Object)this.fleetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentFleetState": {
                return Optional.ofNullable(clazz.cast(this.currentFleetStateAsString()));
            }
            case "PreviousFleetState": {
                return Optional.ofNullable(clazz.cast(this.previousFleetStateAsString()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CurrentFleetState", CURRENT_FLEET_STATE_FIELD);
        map.put("PreviousFleetState", PREVIOUS_FLEET_STATE_FIELD);
        map.put("FleetId", FLEET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetSuccessItem, T> g) {
        return obj -> g.apply((DeleteFleetSuccessItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentFleetState;
        private String previousFleetState;
        private String fleetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetSuccessItem model) {
            this.currentFleetState(model.currentFleetState);
            this.previousFleetState(model.previousFleetState);
            this.fleetId(model.fleetId);
        }

        public final String getCurrentFleetState() {
            return this.currentFleetState;
        }

        public final void setCurrentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
        }

        @Override
        public final Builder currentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
            return this;
        }

        @Override
        public final Builder currentFleetState(FleetStateCode currentFleetState) {
            this.currentFleetState(currentFleetState == null ? null : currentFleetState.toString());
            return this;
        }

        public final String getPreviousFleetState() {
            return this.previousFleetState;
        }

        public final void setPreviousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
        }

        @Override
        public final Builder previousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
            return this;
        }

        @Override
        public final Builder previousFleetState(FleetStateCode previousFleetState) {
            this.previousFleetState(previousFleetState == null ? null : previousFleetState.toString());
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public DeleteFleetSuccessItem build() {
            return new DeleteFleetSuccessItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteFleetSuccessItem> {
        public Builder currentFleetState(String var1);

        public Builder currentFleetState(FleetStateCode var1);

        public Builder previousFleetState(String var1);

        public Builder previousFleetState(FleetStateCode var1);

        public Builder fleetId(String var1);
    }
}

