/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityManagerCondition;
import software.amazon.awssdk.services.ec2.model.CapacityManagerConditionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GroupBy;
import software.amazon.awssdk.services.ec2.model.GroupBySetCopier;
import software.amazon.awssdk.services.ec2.model.Metric;
import software.amazon.awssdk.services.ec2.model.MetricSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCapacityManagerMetricDataRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetCapacityManagerMetricDataRequest> {
    private static final SdkField<List<String>> METRIC_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricNames").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::metricNamesAsStrings)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::metricNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").unmarshallLocationName("MetricName").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::startTime)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::endTime)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("EndTime").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::period)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").unmarshallLocationName("Period").build()}).build();
    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupBy").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::groupByAsStrings)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::groupByWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").unmarshallLocationName("GroupBy").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<CapacityManagerCondition>> FILTER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterBy").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::filterBy)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::filterBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBy").unmarshallLocationName("FilterBy").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityManagerCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::maxResults)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::nextToken)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetCapacityManagerMetricDataRequest.getter(GetCapacityManagerMetricDataRequest::dryRun)).setter(GetCapacityManagerMetricDataRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAMES_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD, GROUP_BY_FIELD, FILTER_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCapacityManagerMetricDataRequest.memberNameToFieldInitializer();
    private final List<String> metricNames;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer period;
    private final List<String> groupBy;
    private final List<CapacityManagerCondition> filterBy;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean dryRun;

    private GetCapacityManagerMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.metricNames = builder.metricNames;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.groupBy = builder.groupBy;
        this.filterBy = builder.filterBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.dryRun = builder.dryRun;
    }

    public final List<Metric> metricNames() {
        return MetricSetCopier.copyStringToEnum(this.metricNames);
    }

    public final boolean hasMetricNames() {
        return this.metricNames != null && !(this.metricNames instanceof SdkAutoConstructList);
    }

    public final List<String> metricNamesAsStrings() {
        return this.metricNames;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer period() {
        return this.period;
    }

    public final List<GroupBy> groupBy() {
        return GroupBySetCopier.copyStringToEnum(this.groupBy);
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<String> groupByAsStrings() {
        return this.groupBy;
    }

    public final boolean hasFilterBy() {
        return this.filterBy != null && !(this.filterBy instanceof SdkAutoConstructList);
    }

    public final List<CapacityManagerCondition> filterBy() {
        return this.filterBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricNames() ? this.metricNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterBy() ? this.filterBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityManagerMetricDataRequest)) {
            return false;
        }
        GetCapacityManagerMetricDataRequest other = (GetCapacityManagerMetricDataRequest)((Object)obj);
        return this.hasMetricNames() == other.hasMetricNames() && Objects.equals(this.metricNamesAsStrings(), other.metricNamesAsStrings()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.period(), other.period()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupByAsStrings(), other.groupByAsStrings()) && this.hasFilterBy() == other.hasFilterBy() && Objects.equals(this.filterBy(), other.filterBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"GetCapacityManagerMetricDataRequest").add("MetricNames", this.hasMetricNames() ? this.metricNamesAsStrings() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Period", (Object)this.period()).add("GroupBy", this.hasGroupBy() ? this.groupByAsStrings() : null).add("FilterBy", this.hasFilterBy() ? this.filterBy() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricNames": {
                return Optional.ofNullable(clazz.cast(this.metricNamesAsStrings()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsStrings()));
            }
            case "FilterBy": {
                return Optional.ofNullable(clazz.cast(this.filterBy()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricName", METRIC_NAMES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("FilterBy", FILTER_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityManagerMetricDataRequest, T> g) {
        return obj -> g.apply((GetCapacityManagerMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> metricNames = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private Integer period;
        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();
        private List<CapacityManagerCondition> filterBy = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityManagerMetricDataRequest model) {
            super(model);
            this.metricNamesWithStrings(model.metricNames);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.period(model.period);
            this.groupByWithStrings(model.groupBy);
            this.filterBy(model.filterBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.dryRun(model.dryRun);
        }

        public final Collection<String> getMetricNames() {
            if (this.metricNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricNames;
        }

        public final void setMetricNames(Collection<String> metricNames) {
            this.metricNames = MetricSetCopier.copy(metricNames);
        }

        @Override
        public final Builder metricNamesWithStrings(Collection<String> metricNames) {
            this.metricNames = MetricSetCopier.copy(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNamesWithStrings(String ... metricNames) {
            this.metricNamesWithStrings(Arrays.asList(metricNames));
            return this;
        }

        @Override
        public final Builder metricNames(Collection<Metric> metricNames) {
            this.metricNames = MetricSetCopier.copyEnumToString(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNames(Metric ... metricNames) {
            this.metricNames(Arrays.asList(metricNames));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (this.groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = GroupBySetCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = GroupBySetCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String ... groupBy) {
            this.groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<GroupBy> groupBy) {
            this.groupBy = GroupBySetCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupBy ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final List<CapacityManagerCondition.Builder> getFilterBy() {
            List<CapacityManagerCondition.Builder> result = CapacityManagerConditionSetCopier.copyToBuilder(this.filterBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterBy(Collection<CapacityManagerCondition.BuilderImpl> filterBy) {
            this.filterBy = CapacityManagerConditionSetCopier.copyFromBuilder(filterBy);
        }

        @Override
        public final Builder filterBy(Collection<CapacityManagerCondition> filterBy) {
            this.filterBy = CapacityManagerConditionSetCopier.copy(filterBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(CapacityManagerCondition ... filterBy) {
            this.filterBy(Arrays.asList(filterBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(Consumer<CapacityManagerCondition.Builder> ... filterBy) {
            this.filterBy(Stream.of(filterBy).map(c -> (CapacityManagerCondition)((CapacityManagerCondition.Builder)CapacityManagerCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCapacityManagerMetricDataRequest build() {
            return new GetCapacityManagerMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCapacityManagerMetricDataRequest> {
        public Builder metricNamesWithStrings(Collection<String> var1);

        public Builder metricNamesWithStrings(String ... var1);

        public Builder metricNames(Collection<Metric> var1);

        public Builder metricNames(Metric ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder period(Integer var1);

        public Builder groupByWithStrings(Collection<String> var1);

        public Builder groupByWithStrings(String ... var1);

        public Builder groupBy(Collection<GroupBy> var1);

        public Builder groupBy(GroupBy ... var1);

        public Builder filterBy(Collection<CapacityManagerCondition> var1);

        public Builder filterBy(CapacityManagerCondition ... var1);

        public Builder filterBy(Consumer<CapacityManagerCondition.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

