/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.MacSystemIntegrityProtectionSettingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MacSystemIntegrityProtectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MacSystemIntegrityProtectionConfiguration> {
    private static final SdkField<String> APPLE_INTERNAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppleInternal").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::appleInternalAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::appleInternal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppleInternal").unmarshallLocationName("appleInternal").build()}).build();
    private static final SdkField<String> BASE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseSystem").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::baseSystemAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::baseSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseSystem").unmarshallLocationName("baseSystem").build()}).build();
    private static final SdkField<String> DEBUGGING_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DebuggingRestrictions").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::debuggingRestrictionsAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::debuggingRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebuggingRestrictions").unmarshallLocationName("debuggingRestrictions").build()}).build();
    private static final SdkField<String> D_TRACE_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DTraceRestrictions").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::dTraceRestrictionsAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::dTraceRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DTraceRestrictions").unmarshallLocationName("dTraceRestrictions").build()}).build();
    private static final SdkField<String> FILESYSTEM_PROTECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilesystemProtections").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::filesystemProtectionsAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::filesystemProtections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesystemProtections").unmarshallLocationName("filesystemProtections").build()}).build();
    private static final SdkField<String> KEXT_SIGNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KextSigning").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::kextSigningAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::kextSigning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KextSigning").unmarshallLocationName("kextSigning").build()}).build();
    private static final SdkField<String> NVRAM_PROTECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NvramProtections").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::nvramProtectionsAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::nvramProtections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NvramProtections").unmarshallLocationName("nvramProtections").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MacSystemIntegrityProtectionConfiguration.getter(MacSystemIntegrityProtectionConfiguration::statusAsString)).setter(MacSystemIntegrityProtectionConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLE_INTERNAL_FIELD, BASE_SYSTEM_FIELD, DEBUGGING_RESTRICTIONS_FIELD, D_TRACE_RESTRICTIONS_FIELD, FILESYSTEM_PROTECTIONS_FIELD, KEXT_SIGNING_FIELD, NVRAM_PROTECTIONS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MacSystemIntegrityProtectionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appleInternal;
    private final String baseSystem;
    private final String debuggingRestrictions;
    private final String dTraceRestrictions;
    private final String filesystemProtections;
    private final String kextSigning;
    private final String nvramProtections;
    private final String status;

    private MacSystemIntegrityProtectionConfiguration(BuilderImpl builder) {
        this.appleInternal = builder.appleInternal;
        this.baseSystem = builder.baseSystem;
        this.debuggingRestrictions = builder.debuggingRestrictions;
        this.dTraceRestrictions = builder.dTraceRestrictions;
        this.filesystemProtections = builder.filesystemProtections;
        this.kextSigning = builder.kextSigning;
        this.nvramProtections = builder.nvramProtections;
        this.status = builder.status;
    }

    public final MacSystemIntegrityProtectionSettingStatus appleInternal() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.appleInternal);
    }

    public final String appleInternalAsString() {
        return this.appleInternal;
    }

    public final MacSystemIntegrityProtectionSettingStatus baseSystem() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.baseSystem);
    }

    public final String baseSystemAsString() {
        return this.baseSystem;
    }

    public final MacSystemIntegrityProtectionSettingStatus debuggingRestrictions() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.debuggingRestrictions);
    }

    public final String debuggingRestrictionsAsString() {
        return this.debuggingRestrictions;
    }

    public final MacSystemIntegrityProtectionSettingStatus dTraceRestrictions() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.dTraceRestrictions);
    }

    public final String dTraceRestrictionsAsString() {
        return this.dTraceRestrictions;
    }

    public final MacSystemIntegrityProtectionSettingStatus filesystemProtections() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.filesystemProtections);
    }

    public final String filesystemProtectionsAsString() {
        return this.filesystemProtections;
    }

    public final MacSystemIntegrityProtectionSettingStatus kextSigning() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.kextSigning);
    }

    public final String kextSigningAsString() {
        return this.kextSigning;
    }

    public final MacSystemIntegrityProtectionSettingStatus nvramProtections() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.nvramProtections);
    }

    public final String nvramProtectionsAsString() {
        return this.nvramProtections;
    }

    public final MacSystemIntegrityProtectionSettingStatus status() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appleInternalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.debuggingRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dTraceRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesystemProtectionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kextSigningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nvramProtectionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacSystemIntegrityProtectionConfiguration)) {
            return false;
        }
        MacSystemIntegrityProtectionConfiguration other = (MacSystemIntegrityProtectionConfiguration)obj;
        return Objects.equals(this.appleInternalAsString(), other.appleInternalAsString()) && Objects.equals(this.baseSystemAsString(), other.baseSystemAsString()) && Objects.equals(this.debuggingRestrictionsAsString(), other.debuggingRestrictionsAsString()) && Objects.equals(this.dTraceRestrictionsAsString(), other.dTraceRestrictionsAsString()) && Objects.equals(this.filesystemProtectionsAsString(), other.filesystemProtectionsAsString()) && Objects.equals(this.kextSigningAsString(), other.kextSigningAsString()) && Objects.equals(this.nvramProtectionsAsString(), other.nvramProtectionsAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MacSystemIntegrityProtectionConfiguration").add("AppleInternal", (Object)this.appleInternalAsString()).add("BaseSystem", (Object)this.baseSystemAsString()).add("DebuggingRestrictions", (Object)this.debuggingRestrictionsAsString()).add("DTraceRestrictions", (Object)this.dTraceRestrictionsAsString()).add("FilesystemProtections", (Object)this.filesystemProtectionsAsString()).add("KextSigning", (Object)this.kextSigningAsString()).add("NvramProtections", (Object)this.nvramProtectionsAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppleInternal": {
                return Optional.ofNullable(clazz.cast(this.appleInternalAsString()));
            }
            case "BaseSystem": {
                return Optional.ofNullable(clazz.cast(this.baseSystemAsString()));
            }
            case "DebuggingRestrictions": {
                return Optional.ofNullable(clazz.cast(this.debuggingRestrictionsAsString()));
            }
            case "DTraceRestrictions": {
                return Optional.ofNullable(clazz.cast(this.dTraceRestrictionsAsString()));
            }
            case "FilesystemProtections": {
                return Optional.ofNullable(clazz.cast(this.filesystemProtectionsAsString()));
            }
            case "KextSigning": {
                return Optional.ofNullable(clazz.cast(this.kextSigningAsString()));
            }
            case "NvramProtections": {
                return Optional.ofNullable(clazz.cast(this.nvramProtectionsAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AppleInternal", APPLE_INTERNAL_FIELD);
        map.put("BaseSystem", BASE_SYSTEM_FIELD);
        map.put("DebuggingRestrictions", DEBUGGING_RESTRICTIONS_FIELD);
        map.put("DTraceRestrictions", D_TRACE_RESTRICTIONS_FIELD);
        map.put("FilesystemProtections", FILESYSTEM_PROTECTIONS_FIELD);
        map.put("KextSigning", KEXT_SIGNING_FIELD);
        map.put("NvramProtections", NVRAM_PROTECTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MacSystemIntegrityProtectionConfiguration, T> g) {
        return obj -> g.apply((MacSystemIntegrityProtectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appleInternal;
        private String baseSystem;
        private String debuggingRestrictions;
        private String dTraceRestrictions;
        private String filesystemProtections;
        private String kextSigning;
        private String nvramProtections;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MacSystemIntegrityProtectionConfiguration model) {
            this.appleInternal(model.appleInternal);
            this.baseSystem(model.baseSystem);
            this.debuggingRestrictions(model.debuggingRestrictions);
            this.dTraceRestrictions(model.dTraceRestrictions);
            this.filesystemProtections(model.filesystemProtections);
            this.kextSigning(model.kextSigning);
            this.nvramProtections(model.nvramProtections);
            this.status(model.status);
        }

        public final String getAppleInternal() {
            return this.appleInternal;
        }

        public final void setAppleInternal(String appleInternal) {
            this.appleInternal = appleInternal;
        }

        @Override
        public final Builder appleInternal(String appleInternal) {
            this.appleInternal = appleInternal;
            return this;
        }

        @Override
        public final Builder appleInternal(MacSystemIntegrityProtectionSettingStatus appleInternal) {
            this.appleInternal(appleInternal == null ? null : appleInternal.toString());
            return this;
        }

        public final String getBaseSystem() {
            return this.baseSystem;
        }

        public final void setBaseSystem(String baseSystem) {
            this.baseSystem = baseSystem;
        }

        @Override
        public final Builder baseSystem(String baseSystem) {
            this.baseSystem = baseSystem;
            return this;
        }

        @Override
        public final Builder baseSystem(MacSystemIntegrityProtectionSettingStatus baseSystem) {
            this.baseSystem(baseSystem == null ? null : baseSystem.toString());
            return this;
        }

        public final String getDebuggingRestrictions() {
            return this.debuggingRestrictions;
        }

        public final void setDebuggingRestrictions(String debuggingRestrictions) {
            this.debuggingRestrictions = debuggingRestrictions;
        }

        @Override
        public final Builder debuggingRestrictions(String debuggingRestrictions) {
            this.debuggingRestrictions = debuggingRestrictions;
            return this;
        }

        @Override
        public final Builder debuggingRestrictions(MacSystemIntegrityProtectionSettingStatus debuggingRestrictions) {
            this.debuggingRestrictions(debuggingRestrictions == null ? null : debuggingRestrictions.toString());
            return this;
        }

        public final String getDTraceRestrictions() {
            return this.dTraceRestrictions;
        }

        public final void setDTraceRestrictions(String dTraceRestrictions) {
            this.dTraceRestrictions = dTraceRestrictions;
        }

        @Override
        public final Builder dTraceRestrictions(String dTraceRestrictions) {
            this.dTraceRestrictions = dTraceRestrictions;
            return this;
        }

        @Override
        public final Builder dTraceRestrictions(MacSystemIntegrityProtectionSettingStatus dTraceRestrictions) {
            this.dTraceRestrictions(dTraceRestrictions == null ? null : dTraceRestrictions.toString());
            return this;
        }

        public final String getFilesystemProtections() {
            return this.filesystemProtections;
        }

        public final void setFilesystemProtections(String filesystemProtections) {
            this.filesystemProtections = filesystemProtections;
        }

        @Override
        public final Builder filesystemProtections(String filesystemProtections) {
            this.filesystemProtections = filesystemProtections;
            return this;
        }

        @Override
        public final Builder filesystemProtections(MacSystemIntegrityProtectionSettingStatus filesystemProtections) {
            this.filesystemProtections(filesystemProtections == null ? null : filesystemProtections.toString());
            return this;
        }

        public final String getKextSigning() {
            return this.kextSigning;
        }

        public final void setKextSigning(String kextSigning) {
            this.kextSigning = kextSigning;
        }

        @Override
        public final Builder kextSigning(String kextSigning) {
            this.kextSigning = kextSigning;
            return this;
        }

        @Override
        public final Builder kextSigning(MacSystemIntegrityProtectionSettingStatus kextSigning) {
            this.kextSigning(kextSigning == null ? null : kextSigning.toString());
            return this;
        }

        public final String getNvramProtections() {
            return this.nvramProtections;
        }

        public final void setNvramProtections(String nvramProtections) {
            this.nvramProtections = nvramProtections;
        }

        @Override
        public final Builder nvramProtections(String nvramProtections) {
            this.nvramProtections = nvramProtections;
            return this;
        }

        @Override
        public final Builder nvramProtections(MacSystemIntegrityProtectionSettingStatus nvramProtections) {
            this.nvramProtections(nvramProtections == null ? null : nvramProtections.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MacSystemIntegrityProtectionSettingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public MacSystemIntegrityProtectionConfiguration build() {
            return new MacSystemIntegrityProtectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MacSystemIntegrityProtectionConfiguration> {
        public Builder appleInternal(String var1);

        public Builder appleInternal(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder baseSystem(String var1);

        public Builder baseSystem(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder debuggingRestrictions(String var1);

        public Builder debuggingRestrictions(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder dTraceRestrictions(String var1);

        public Builder dTraceRestrictions(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder filesystemProtections(String var1);

        public Builder filesystemProtections(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder kextSigning(String var1);

        public Builder kextSigning(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder nvramProtections(String var1);

        public Builder nvramProtections(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder status(String var1);

        public Builder status(MacSystemIntegrityProtectionSettingStatus var1);
    }
}

