/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRouteServersResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeRouteServersResponse.Builder, DescribeRouteServersResponse> {
    private static final SdkField<List<RouteServer>> ROUTE_SERVERS_FIELD = SdkField
            .<List<RouteServer>> builder(MarshallingType.LIST)
            .memberName("RouteServers")
            .getter(getter(DescribeRouteServersResponse::routeServers))
            .setter(setter(Builder::routeServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerSet")
                    .unmarshallLocationName("routeServerSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RouteServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeRouteServersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RouteServer> routeServers;

    private final String nextToken;

    private DescribeRouteServersResponse(BuilderImpl builder) {
        super(builder);
        this.routeServers = builder.routeServers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteServers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteServers() {
        return routeServers != null && !(routeServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the described route servers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteServers} method.
     * </p>
     * 
     * @return Information about the described route servers.
     */
    public final List<RouteServer> routeServers() {
        return routeServers;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteServers() ? routeServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteServersResponse)) {
            return false;
        }
        DescribeRouteServersResponse other = (DescribeRouteServersResponse) obj;
        return hasRouteServers() == other.hasRouteServers() && Objects.equals(routeServers(), other.routeServers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRouteServersResponse").add("RouteServers", hasRouteServers() ? routeServers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServers":
            return Optional.ofNullable(clazz.cast(routeServers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerSet", ROUTE_SERVERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteServersResponse, T> g) {
        return obj -> g.apply((DescribeRouteServersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRouteServersResponse> {
        /**
         * <p>
         * Information about the described route servers.
         * </p>
         * 
         * @param routeServers
         *        Information about the described route servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServers(Collection<RouteServer> routeServers);

        /**
         * <p>
         * Information about the described route servers.
         * </p>
         * 
         * @param routeServers
         *        Information about the described route servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServers(RouteServer... routeServers);

        /**
         * <p>
         * Information about the described route servers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RouteServer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RouteServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RouteServer.Builder#build()} is called immediately and its
         * result is passed to {@link #routeServers(List<RouteServer>)}.
         * 
         * @param routeServers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RouteServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServers(java.util.Collection<RouteServer>)
         */
        Builder routeServers(Consumer<RouteServer.Builder>... routeServers);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<RouteServer> routeServers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteServersResponse model) {
            super(model);
            routeServers(model.routeServers);
            nextToken(model.nextToken);
        }

        public final List<RouteServer.Builder> getRouteServers() {
            List<RouteServer.Builder> result = RouteServersListCopier.copyToBuilder(this.routeServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteServers(Collection<RouteServer.BuilderImpl> routeServers) {
            this.routeServers = RouteServersListCopier.copyFromBuilder(routeServers);
        }

        @Override
        public final Builder routeServers(Collection<RouteServer> routeServers) {
            this.routeServers = RouteServersListCopier.copy(routeServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServers(RouteServer... routeServers) {
            routeServers(Arrays.asList(routeServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServers(Consumer<RouteServer.Builder>... routeServers) {
            routeServers(Stream.of(routeServers).map(c -> RouteServer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRouteServersResponse build() {
            return new DescribeRouteServersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
