/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.services.ec2.model.InstanceAttachmentEnaSrdSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceNetworkInterfaceAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceNetworkInterfaceAttachment> {
    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AttachTime").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::attachTime)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::attachTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").unmarshallLocationName("attachTime").build()}).build();
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::attachmentId)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").unmarshallLocationName("attachmentId").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::deleteOnTermination)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeviceIndex").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::deviceIndex)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("deviceIndex").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::statusAsString)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::networkCardIndex)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("networkCardIndex").build()}).build();
    private static final SdkField<InstanceAttachmentEnaSrdSpecification> ENA_SRD_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnaSrdSpecification").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::enaSrdSpecification)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::enaSrdSpecification)).constructor(InstanceAttachmentEnaSrdSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification").unmarshallLocationName("enaSrdSpecification").build()}).build();
    private static final SdkField<Integer> ENA_QUEUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EnaQueueCount").getter(InstanceNetworkInterfaceAttachment.getter(InstanceNetworkInterfaceAttachment::enaQueueCount)).setter(InstanceNetworkInterfaceAttachment.setter(Builder::enaQueueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaQueueCount").unmarshallLocationName("enaQueueCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TIME_FIELD, ATTACHMENT_ID_FIELD, DELETE_ON_TERMINATION_FIELD, DEVICE_INDEX_FIELD, STATUS_FIELD, NETWORK_CARD_INDEX_FIELD, ENA_SRD_SPECIFICATION_FIELD, ENA_QUEUE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceNetworkInterfaceAttachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant attachTime;
    private final String attachmentId;
    private final Boolean deleteOnTermination;
    private final Integer deviceIndex;
    private final String status;
    private final Integer networkCardIndex;
    private final InstanceAttachmentEnaSrdSpecification enaSrdSpecification;
    private final Integer enaQueueCount;

    private InstanceNetworkInterfaceAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.status = builder.status;
        this.networkCardIndex = builder.networkCardIndex;
        this.enaSrdSpecification = builder.enaSrdSpecification;
        this.enaQueueCount = builder.enaQueueCount;
    }

    public final Instant attachTime() {
        return this.attachTime;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final Integer deviceIndex() {
        return this.deviceIndex;
    }

    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public final InstanceAttachmentEnaSrdSpecification enaSrdSpecification() {
        return this.enaSrdSpecification;
    }

    public final Integer enaQueueCount() {
        return this.enaQueueCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSrdSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaQueueCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceAttachment)) {
            return false;
        }
        InstanceNetworkInterfaceAttachment other = (InstanceNetworkInterfaceAttachment)obj;
        return Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.networkCardIndex(), other.networkCardIndex()) && Objects.equals(this.enaSrdSpecification(), other.enaSrdSpecification()) && Objects.equals(this.enaQueueCount(), other.enaQueueCount());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceNetworkInterfaceAttachment").add("AttachTime", (Object)this.attachTime()).add("AttachmentId", (Object)this.attachmentId()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("DeviceIndex", (Object)this.deviceIndex()).add("Status", (Object)this.statusAsString()).add("NetworkCardIndex", (Object)this.networkCardIndex()).add("EnaSrdSpecification", (Object)this.enaSrdSpecification()).add("EnaQueueCount", (Object)this.enaQueueCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachTime": {
                return Optional.ofNullable(clazz.cast(this.attachTime()));
            }
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
            case "EnaSrdSpecification": {
                return Optional.ofNullable(clazz.cast(this.enaSrdSpecification()));
            }
            case "EnaQueueCount": {
                return Optional.ofNullable(clazz.cast(this.enaQueueCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachTime", ATTACH_TIME_FIELD);
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("DeviceIndex", DEVICE_INDEX_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        map.put("EnaSrdSpecification", ENA_SRD_SPECIFICATION_FIELD);
        map.put("EnaQueueCount", ENA_QUEUE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterfaceAttachment, T> g) {
        return obj -> g.apply((InstanceNetworkInterfaceAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private String attachmentId;
        private Boolean deleteOnTermination;
        private Integer deviceIndex;
        private String status;
        private Integer networkCardIndex;
        private InstanceAttachmentEnaSrdSpecification enaSrdSpecification;
        private Integer enaQueueCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceAttachment model) {
            this.attachTime(model.attachTime);
            this.attachmentId(model.attachmentId);
            this.deleteOnTermination(model.deleteOnTermination);
            this.deviceIndex(model.deviceIndex);
            this.status(model.status);
            this.networkCardIndex(model.networkCardIndex);
            this.enaSrdSpecification(model.enaSrdSpecification);
            this.enaQueueCount(model.enaQueueCount);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final InstanceAttachmentEnaSrdSpecification.Builder getEnaSrdSpecification() {
            return this.enaSrdSpecification != null ? this.enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(InstanceAttachmentEnaSrdSpecification.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(InstanceAttachmentEnaSrdSpecification enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        public final Integer getEnaQueueCount() {
            return this.enaQueueCount;
        }

        public final void setEnaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
        }

        @Override
        public final Builder enaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
            return this;
        }

        public InstanceNetworkInterfaceAttachment build() {
            return new InstanceNetworkInterfaceAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceNetworkInterfaceAttachment> {
        public Builder attachTime(Instant var1);

        public Builder attachmentId(String var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder deviceIndex(Integer var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);

        public Builder networkCardIndex(Integer var1);

        public Builder enaSrdSpecification(InstanceAttachmentEnaSrdSpecification var1);

        default public Builder enaSrdSpecification(Consumer<InstanceAttachmentEnaSrdSpecification.Builder> enaSrdSpecification) {
            return this.enaSrdSpecification((InstanceAttachmentEnaSrdSpecification)((InstanceAttachmentEnaSrdSpecification.Builder)InstanceAttachmentEnaSrdSpecification.builder().applyMutation(enaSrdSpecification)).build());
        }

        public Builder enaQueueCount(Integer var1);
    }
}

