/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSubnetCidrBlockRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
    private static final SdkField<String> IPV6_IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6IpamPoolId").getter(AssociateSubnetCidrBlockRequest.getter(AssociateSubnetCidrBlockRequest::ipv6IpamPoolId)).setter(AssociateSubnetCidrBlockRequest.setter(Builder::ipv6IpamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6IpamPoolId").unmarshallLocationName("Ipv6IpamPoolId").build()}).build();
    private static final SdkField<Integer> IPV6_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6NetmaskLength").getter(AssociateSubnetCidrBlockRequest.getter(AssociateSubnetCidrBlockRequest::ipv6NetmaskLength)).setter(AssociateSubnetCidrBlockRequest.setter(Builder::ipv6NetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6NetmaskLength").unmarshallLocationName("Ipv6NetmaskLength").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(AssociateSubnetCidrBlockRequest.getter(AssociateSubnetCidrBlockRequest::subnetId)).setter(AssociateSubnetCidrBlockRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(AssociateSubnetCidrBlockRequest.getter(AssociateSubnetCidrBlockRequest::ipv6CidrBlock)).setter(AssociateSubnetCidrBlockRequest.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("ipv6CidrBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_IPAM_POOL_ID_FIELD, IPV6_NETMASK_LENGTH_FIELD, SUBNET_ID_FIELD, IPV6_CIDR_BLOCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateSubnetCidrBlockRequest.memberNameToFieldInitializer();
    private final String ipv6IpamPoolId;
    private final Integer ipv6NetmaskLength;
    private final String subnetId;
    private final String ipv6CidrBlock;

    private AssociateSubnetCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6IpamPoolId = builder.ipv6IpamPoolId;
        this.ipv6NetmaskLength = builder.ipv6NetmaskLength;
        this.subnetId = builder.subnetId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
    }

    public final String ipv6IpamPoolId() {
        return this.ipv6IpamPoolId;
    }

    public final Integer ipv6NetmaskLength() {
        return this.ipv6NetmaskLength;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSubnetCidrBlockRequest)) {
            return false;
        }
        AssociateSubnetCidrBlockRequest other = (AssociateSubnetCidrBlockRequest)((Object)obj);
        return Objects.equals(this.ipv6IpamPoolId(), other.ipv6IpamPoolId()) && Objects.equals(this.ipv6NetmaskLength(), other.ipv6NetmaskLength()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSubnetCidrBlockRequest").add("Ipv6IpamPoolId", (Object)this.ipv6IpamPoolId()).add("Ipv6NetmaskLength", (Object)this.ipv6NetmaskLength()).add("SubnetId", (Object)this.subnetId()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipv6IpamPoolId()));
            }
            case "Ipv6NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.ipv6NetmaskLength()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Ipv6IpamPoolId", IPV6_IPAM_POOL_ID_FIELD);
        map.put("Ipv6NetmaskLength", IPV6_NETMASK_LENGTH_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSubnetCidrBlockRequest, T> g) {
        return obj -> g.apply((AssociateSubnetCidrBlockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String ipv6IpamPoolId;
        private Integer ipv6NetmaskLength;
        private String subnetId;
        private String ipv6CidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSubnetCidrBlockRequest model) {
            super(model);
            this.ipv6IpamPoolId(model.ipv6IpamPoolId);
            this.ipv6NetmaskLength(model.ipv6NetmaskLength);
            this.subnetId(model.subnetId);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
        }

        public final String getIpv6IpamPoolId() {
            return this.ipv6IpamPoolId;
        }

        public final void setIpv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
        }

        @Override
        public final Builder ipv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
            return this;
        }

        public final Integer getIpv6NetmaskLength() {
            return this.ipv6NetmaskLength;
        }

        public final void setIpv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
        }

        @Override
        public final Builder ipv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSubnetCidrBlockRequest build() {
            return new AssociateSubnetCidrBlockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
        public Builder ipv6IpamPoolId(String var1);

        public Builder ipv6NetmaskLength(Integer var1);

        public Builder subnetId(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

