/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ImageReferenceResourceType;
import software.amazon.awssdk.services.ec2.model.ResourceTypeOption;
import software.amazon.awssdk.services.ec2.model.ResourceTypeOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceTypeRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceTypeRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceTypeRequest.getter(ResourceTypeRequest::resourceTypeAsString)).setter(ResourceTypeRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("ResourceType").build()}).build();
    private static final SdkField<List<ResourceTypeOption>> RESOURCE_TYPE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypeOptions").getter(ResourceTypeRequest.getter(ResourceTypeRequest::resourceTypeOptions)).setter(ResourceTypeRequest.setter(Builder::resourceTypeOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeOption").unmarshallLocationName("ResourceTypeOption").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTypeOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_TYPE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceTypeRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final List<ResourceTypeOption> resourceTypeOptions;

    private ResourceTypeRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceTypeOptions = builder.resourceTypeOptions;
    }

    public final ImageReferenceResourceType resourceType() {
        return ImageReferenceResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasResourceTypeOptions() {
        return this.resourceTypeOptions != null && !(this.resourceTypeOptions instanceof SdkAutoConstructList);
    }

    public final List<ResourceTypeOption> resourceTypeOptions() {
        return this.resourceTypeOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeOptions() ? this.resourceTypeOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTypeRequest)) {
            return false;
        }
        ResourceTypeRequest other = (ResourceTypeRequest)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasResourceTypeOptions() == other.hasResourceTypeOptions() && Objects.equals(this.resourceTypeOptions(), other.resourceTypeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceTypeRequest").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceTypeOptions", this.hasResourceTypeOptions() ? this.resourceTypeOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceTypeOptions": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceTypeOption", RESOURCE_TYPE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceTypeRequest, T> g) {
        return obj -> g.apply((ResourceTypeRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private List<ResourceTypeOption> resourceTypeOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTypeRequest model) {
            this.resourceType(model.resourceType);
            this.resourceTypeOptions(model.resourceTypeOptions);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ImageReferenceResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<ResourceTypeOption.Builder> getResourceTypeOptions() {
            List<ResourceTypeOption.Builder> result = ResourceTypeOptionListCopier.copyToBuilder(this.resourceTypeOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypeOptions(Collection<ResourceTypeOption.BuilderImpl> resourceTypeOptions) {
            this.resourceTypeOptions = ResourceTypeOptionListCopier.copyFromBuilder(resourceTypeOptions);
        }

        @Override
        public final Builder resourceTypeOptions(Collection<ResourceTypeOption> resourceTypeOptions) {
            this.resourceTypeOptions = ResourceTypeOptionListCopier.copy(resourceTypeOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeOptions(ResourceTypeOption ... resourceTypeOptions) {
            this.resourceTypeOptions(Arrays.asList(resourceTypeOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeOptions(Consumer<ResourceTypeOption.Builder> ... resourceTypeOptions) {
            this.resourceTypeOptions(Stream.of(resourceTypeOptions).map(c -> (ResourceTypeOption)((ResourceTypeOption.Builder)ResourceTypeOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceTypeRequest build() {
            return new ResourceTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceTypeRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(ImageReferenceResourceType var1);

        public Builder resourceTypeOptions(Collection<ResourceTypeOption> var1);

        public Builder resourceTypeOptions(ResourceTypeOption ... var1);

        public Builder resourceTypeOptions(Consumer<ResourceTypeOption.Builder> ... var1);
    }
}

