/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyRouteServerRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyRouteServerRequest.Builder, ModifyRouteServerRequest> {
    private static final SdkField<String> ROUTE_SERVER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteServerId")
            .getter(getter(ModifyRouteServerRequest::routeServerId))
            .setter(setter(Builder::routeServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerId")
                    .unmarshallLocationName("RouteServerId").build()).build();

    private static final SdkField<String> PERSIST_ROUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PersistRoutes")
            .getter(getter(ModifyRouteServerRequest::persistRoutesAsString))
            .setter(setter(Builder::persistRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutes")
                    .unmarshallLocationName("PersistRoutes").build()).build();

    private static final SdkField<Long> PERSIST_ROUTES_DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PersistRoutesDuration")
            .getter(getter(ModifyRouteServerRequest::persistRoutesDuration))
            .setter(setter(Builder::persistRoutesDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutesDuration")
                    .unmarshallLocationName("PersistRoutesDuration").build()).build();

    private static final SdkField<Boolean> SNS_NOTIFICATIONS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SnsNotificationsEnabled")
            .getter(getter(ModifyRouteServerRequest::snsNotificationsEnabled))
            .setter(setter(Builder::snsNotificationsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsNotificationsEnabled")
                    .unmarshallLocationName("SnsNotificationsEnabled").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyRouteServerRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ID_FIELD,
            PERSIST_ROUTES_FIELD, PERSIST_ROUTES_DURATION_FIELD, SNS_NOTIFICATIONS_ENABLED_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String routeServerId;

    private final String persistRoutes;

    private final Long persistRoutesDuration;

    private final Boolean snsNotificationsEnabled;

    private final Boolean dryRun;

    private ModifyRouteServerRequest(BuilderImpl builder) {
        super(builder);
        this.routeServerId = builder.routeServerId;
        this.persistRoutes = builder.persistRoutes;
        this.persistRoutesDuration = builder.persistRoutesDuration;
        this.snsNotificationsEnabled = builder.snsNotificationsEnabled;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the route server to modify.
     * </p>
     * 
     * @return The ID of the route server to modify.
     */
    public final String routeServerId() {
        return routeServerId;
    }

    /**
     * <p>
     * Specifies whether to persist routes after all BGP sessions are terminated.
     * </p>
     * <ul>
     * <li>
     * <p>
     * enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * reset: If a route server has persisted routes due to all BGP sessions having ended, reset will withdraw all
     * routes and reset route server to an empty FIB and RIB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistRoutes}
     * will return {@link RouteServerPersistRoutesAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #persistRoutesAsString}.
     * </p>
     * 
     * @return Specifies whether to persist routes after all BGP sessions are terminated.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         reset: If a route server has persisted routes due to all BGP sessions having ended, reset will withdraw
     *         all routes and reset route server to an empty FIB and RIB.
     *         </p>
     *         </li>
     * @see RouteServerPersistRoutesAction
     */
    public final RouteServerPersistRoutesAction persistRoutes() {
        return RouteServerPersistRoutesAction.fromValue(persistRoutes);
    }

    /**
     * <p>
     * Specifies whether to persist routes after all BGP sessions are terminated.
     * </p>
     * <ul>
     * <li>
     * <p>
     * enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * reset: If a route server has persisted routes due to all BGP sessions having ended, reset will withdraw all
     * routes and reset route server to an empty FIB and RIB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistRoutes}
     * will return {@link RouteServerPersistRoutesAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #persistRoutesAsString}.
     * </p>
     * 
     * @return Specifies whether to persist routes after all BGP sessions are terminated.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         reset: If a route server has persisted routes due to all BGP sessions having ended, reset will withdraw
     *         all routes and reset route server to an empty FIB and RIB.
     *         </p>
     *         </li>
     * @see RouteServerPersistRoutesAction
     */
    public final String persistRoutesAsString() {
        return persistRoutes;
    }

    /**
     * <p>
     * The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and
     * RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>.
     * </p>
     * <p>
     * If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route server, it
     * has 1 minute to relearn it's adjacent network and advertise those routes to route server before route server
     * resumes normal functionality. In most cases, 1 minute is probably sufficient. If, however, you have concerns that
     * your BGP network may not be capable of fully re-establishing and re-learning everything in 1 minute, you can
     * increase the duration up to 5 minutes.
     * </p>
     * 
     * @return The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the
     *         FIB and RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>.</p>
     *         <p>
     *         If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route
     *         server, it has 1 minute to relearn it's adjacent network and advertise those routes to route server
     *         before route server resumes normal functionality. In most cases, 1 minute is probably sufficient. If,
     *         however, you have concerns that your BGP network may not be capable of fully re-establishing and
     *         re-learning everything in 1 minute, you can increase the duration up to 5 minutes.
     */
    public final Long persistRoutesDuration() {
        return persistRoutesDuration;
    }

    /**
     * <p>
     * Specifies whether to enable SNS notifications for route server events. Enabling SNS notifications persists BGP
     * status changes to an SNS topic provisioned by Amazon Web Services.
     * </p>
     * 
     * @return Specifies whether to enable SNS notifications for route server events. Enabling SNS notifications
     *         persists BGP status changes to an SNS topic provisioned by Amazon Web Services.
     */
    public final Boolean snsNotificationsEnabled() {
        return snsNotificationsEnabled;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeServerId());
        hashCode = 31 * hashCode + Objects.hashCode(persistRoutesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(persistRoutesDuration());
        hashCode = 31 * hashCode + Objects.hashCode(snsNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRouteServerRequest)) {
            return false;
        }
        ModifyRouteServerRequest other = (ModifyRouteServerRequest) obj;
        return Objects.equals(routeServerId(), other.routeServerId())
                && Objects.equals(persistRoutesAsString(), other.persistRoutesAsString())
                && Objects.equals(persistRoutesDuration(), other.persistRoutesDuration())
                && Objects.equals(snsNotificationsEnabled(), other.snsNotificationsEnabled())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyRouteServerRequest").add("RouteServerId", routeServerId())
                .add("PersistRoutes", persistRoutesAsString()).add("PersistRoutesDuration", persistRoutesDuration())
                .add("SnsNotificationsEnabled", snsNotificationsEnabled()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerId":
            return Optional.ofNullable(clazz.cast(routeServerId()));
        case "PersistRoutes":
            return Optional.ofNullable(clazz.cast(persistRoutesAsString()));
        case "PersistRoutesDuration":
            return Optional.ofNullable(clazz.cast(persistRoutesDuration()));
        case "SnsNotificationsEnabled":
            return Optional.ofNullable(clazz.cast(snsNotificationsEnabled()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerId", ROUTE_SERVER_ID_FIELD);
        map.put("PersistRoutes", PERSIST_ROUTES_FIELD);
        map.put("PersistRoutesDuration", PERSIST_ROUTES_DURATION_FIELD);
        map.put("SnsNotificationsEnabled", SNS_NOTIFICATIONS_ENABLED_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyRouteServerRequest, T> g) {
        return obj -> g.apply((ModifyRouteServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyRouteServerRequest> {
        /**
         * <p>
         * The ID of the route server to modify.
         * </p>
         * 
         * @param routeServerId
         *        The ID of the route server to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerId(String routeServerId);

        /**
         * <p>
         * Specifies whether to persist routes after all BGP sessions are terminated.
         * </p>
         * <ul>
         * <li>
         * <p>
         * enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * reset: If a route server has persisted routes due to all BGP sessions having ended, reset will withdraw all
         * routes and reset route server to an empty FIB and RIB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param persistRoutes
         *        Specifies whether to persist routes after all BGP sessions are terminated.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        reset: If a route server has persisted routes due to all BGP sessions having ended, reset will
         *        withdraw all routes and reset route server to an empty FIB and RIB.
         *        </p>
         *        </li>
         * @see RouteServerPersistRoutesAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerPersistRoutesAction
         */
        Builder persistRoutes(String persistRoutes);

        /**
         * <p>
         * Specifies whether to persist routes after all BGP sessions are terminated.
         * </p>
         * <ul>
         * <li>
         * <p>
         * enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * reset: If a route server has persisted routes due to all BGP sessions having ended, reset will withdraw all
         * routes and reset route server to an empty FIB and RIB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param persistRoutes
         *        Specifies whether to persist routes after all BGP sessions are terminated.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        enable: Routes will be persisted in FIB and RIB after all BGP sessions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        disable: Routes will not be persisted in FIB and RIB after all BGP sessions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        reset: If a route server has persisted routes due to all BGP sessions having ended, reset will
         *        withdraw all routes and reset route server to an empty FIB and RIB.
         *        </p>
         *        </li>
         * @see RouteServerPersistRoutesAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerPersistRoutesAction
         */
        Builder persistRoutes(RouteServerPersistRoutesAction persistRoutes);

        /**
         * <p>
         * The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB
         * and RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>.
         * </p>
         * <p>
         * If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route server,
         * it has 1 minute to relearn it's adjacent network and advertise those routes to route server before route
         * server resumes normal functionality. In most cases, 1 minute is probably sufficient. If, however, you have
         * concerns that your BGP network may not be capable of fully re-establishing and re-learning everything in 1
         * minute, you can increase the duration up to 5 minutes.
         * </p>
         * 
         * @param persistRoutesDuration
         *        The number of minutes a route server will wait after BGP is re-established to unpersist the routes in
         *        the FIB and RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>
         *        .</p>
         *        <p>
         *        If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route
         *        server, it has 1 minute to relearn it's adjacent network and advertise those routes to route server
         *        before route server resumes normal functionality. In most cases, 1 minute is probably sufficient. If,
         *        however, you have concerns that your BGP network may not be capable of fully re-establishing and
         *        re-learning everything in 1 minute, you can increase the duration up to 5 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistRoutesDuration(Long persistRoutesDuration);

        /**
         * <p>
         * Specifies whether to enable SNS notifications for route server events. Enabling SNS notifications persists
         * BGP status changes to an SNS topic provisioned by Amazon Web Services.
         * </p>
         * 
         * @param snsNotificationsEnabled
         *        Specifies whether to enable SNS notifications for route server events. Enabling SNS notifications
         *        persists BGP status changes to an SNS topic provisioned by Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsNotificationsEnabled(Boolean snsNotificationsEnabled);

        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String routeServerId;

        private String persistRoutes;

        private Long persistRoutesDuration;

        private Boolean snsNotificationsEnabled;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRouteServerRequest model) {
            super(model);
            routeServerId(model.routeServerId);
            persistRoutes(model.persistRoutes);
            persistRoutesDuration(model.persistRoutesDuration);
            snsNotificationsEnabled(model.snsNotificationsEnabled);
            dryRun(model.dryRun);
        }

        public final String getRouteServerId() {
            return routeServerId;
        }

        public final void setRouteServerId(String routeServerId) {
            this.routeServerId = routeServerId;
        }

        @Override
        public final Builder routeServerId(String routeServerId) {
            this.routeServerId = routeServerId;
            return this;
        }

        public final String getPersistRoutes() {
            return persistRoutes;
        }

        public final void setPersistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
        }

        @Override
        public final Builder persistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
            return this;
        }

        @Override
        public final Builder persistRoutes(RouteServerPersistRoutesAction persistRoutes) {
            this.persistRoutes(persistRoutes == null ? null : persistRoutes.toString());
            return this;
        }

        public final Long getPersistRoutesDuration() {
            return persistRoutesDuration;
        }

        public final void setPersistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
        }

        @Override
        public final Builder persistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
            return this;
        }

        public final Boolean getSnsNotificationsEnabled() {
            return snsNotificationsEnabled;
        }

        public final void setSnsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
        }

        @Override
        public final Builder snsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyRouteServerRequest build() {
            return new ModifyRouteServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
