/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClientVpnEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyClientVpnEndpointRequest.Builder, ModifyClientVpnEndpointRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(ModifyClientVpnEndpointRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerCertificateArn")
            .getter(getter(ModifyClientVpnEndpointRequest::serverCertificateArn))
            .setter(setter(Builder::serverCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn")
                    .unmarshallLocationName("ServerCertificateArn").build()).build();

    private static final SdkField<ConnectionLogOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField
            .<ConnectionLogOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionLogOptions")
            .getter(getter(ModifyClientVpnEndpointRequest::connectionLogOptions))
            .setter(setter(Builder::connectionLogOptions))
            .constructor(ConnectionLogOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions")
                    .unmarshallLocationName("ConnectionLogOptions").build()).build();

    private static final SdkField<DnsServersOptionsModifyStructure> DNS_SERVERS_FIELD = SdkField
            .<DnsServersOptionsModifyStructure> builder(MarshallingType.SDK_POJO)
            .memberName("DnsServers")
            .getter(getter(ModifyClientVpnEndpointRequest::dnsServers))
            .setter(setter(Builder::dnsServers))
            .constructor(DnsServersOptionsModifyStructure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers")
                    .unmarshallLocationName("DnsServers").build()).build();

    private static final SdkField<Integer> VPN_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VpnPort")
            .getter(getter(ModifyClientVpnEndpointRequest::vpnPort))
            .setter(setter(Builder::vpnPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnPort")
                    .unmarshallLocationName("VpnPort").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyClientVpnEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> SPLIT_TUNNEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SplitTunnel")
            .getter(getter(ModifyClientVpnEndpointRequest::splitTunnel))
            .setter(setter(Builder::splitTunnel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitTunnel")
                    .unmarshallLocationName("SplitTunnel").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyClientVpnEndpointRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ModifyClientVpnEndpointRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(ModifyClientVpnEndpointRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<String> SELF_SERVICE_PORTAL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SelfServicePortal")
            .getter(getter(ModifyClientVpnEndpointRequest::selfServicePortalAsString))
            .setter(setter(Builder::selfServicePortal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServicePortal")
                    .unmarshallLocationName("SelfServicePortal").build()).build();

    private static final SdkField<ClientConnectOptions> CLIENT_CONNECT_OPTIONS_FIELD = SdkField
            .<ClientConnectOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ClientConnectOptions")
            .getter(getter(ModifyClientVpnEndpointRequest::clientConnectOptions))
            .setter(setter(Builder::clientConnectOptions))
            .constructor(ClientConnectOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConnectOptions")
                    .unmarshallLocationName("ClientConnectOptions").build()).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionTimeoutHours")
            .getter(getter(ModifyClientVpnEndpointRequest::sessionTimeoutHours))
            .setter(setter(Builder::sessionTimeoutHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutHours")
                    .unmarshallLocationName("SessionTimeoutHours").build()).build();

    private static final SdkField<ClientLoginBannerOptions> CLIENT_LOGIN_BANNER_OPTIONS_FIELD = SdkField
            .<ClientLoginBannerOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ClientLoginBannerOptions")
            .getter(getter(ModifyClientVpnEndpointRequest::clientLoginBannerOptions))
            .setter(setter(Builder::clientLoginBannerOptions))
            .constructor(ClientLoginBannerOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientLoginBannerOptions")
                    .unmarshallLocationName("ClientLoginBannerOptions").build()).build();

    private static final SdkField<ClientRouteEnforcementOptions> CLIENT_ROUTE_ENFORCEMENT_OPTIONS_FIELD = SdkField
            .<ClientRouteEnforcementOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ClientRouteEnforcementOptions")
            .getter(getter(ModifyClientVpnEndpointRequest::clientRouteEnforcementOptions))
            .setter(setter(Builder::clientRouteEnforcementOptions))
            .constructor(ClientRouteEnforcementOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRouteEnforcementOptions")
                    .unmarshallLocationName("ClientRouteEnforcementOptions").build()).build();

    private static final SdkField<Boolean> DISCONNECT_ON_SESSION_TIMEOUT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisconnectOnSessionTimeout")
            .getter(getter(ModifyClientVpnEndpointRequest::disconnectOnSessionTimeout))
            .setter(setter(Builder::disconnectOnSessionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectOnSessionTimeout")
                    .unmarshallLocationName("DisconnectOnSessionTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            SERVER_CERTIFICATE_ARN_FIELD, CONNECTION_LOG_OPTIONS_FIELD, DNS_SERVERS_FIELD, VPN_PORT_FIELD, DESCRIPTION_FIELD,
            SPLIT_TUNNEL_FIELD, DRY_RUN_FIELD, SECURITY_GROUP_IDS_FIELD, VPC_ID_FIELD, SELF_SERVICE_PORTAL_FIELD,
            CLIENT_CONNECT_OPTIONS_FIELD, SESSION_TIMEOUT_HOURS_FIELD, CLIENT_LOGIN_BANNER_OPTIONS_FIELD,
            CLIENT_ROUTE_ENFORCEMENT_OPTIONS_FIELD, DISCONNECT_ON_SESSION_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientVpnEndpointId;

    private final String serverCertificateArn;

    private final ConnectionLogOptions connectionLogOptions;

    private final DnsServersOptionsModifyStructure dnsServers;

    private final Integer vpnPort;

    private final String description;

    private final Boolean splitTunnel;

    private final Boolean dryRun;

    private final List<String> securityGroupIds;

    private final String vpcId;

    private final String selfServicePortal;

    private final ClientConnectOptions clientConnectOptions;

    private final Integer sessionTimeoutHours;

    private final ClientLoginBannerOptions clientLoginBannerOptions;

    private final ClientRouteEnforcementOptions clientRouteEnforcementOptions;

    private final Boolean disconnectOnSessionTimeout;

    private ModifyClientVpnEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.dnsServers = builder.dnsServers;
        this.vpnPort = builder.vpnPort;
        this.description = builder.description;
        this.splitTunnel = builder.splitTunnel;
        this.dryRun = builder.dryRun;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
        this.selfServicePortal = builder.selfServicePortal;
        this.clientConnectOptions = builder.clientConnectOptions;
        this.sessionTimeoutHours = builder.sessionTimeoutHours;
        this.clientLoginBannerOptions = builder.clientLoginBannerOptions;
        this.clientRouteEnforcementOptions = builder.clientRouteEnforcementOptions;
        this.disconnectOnSessionTimeout = builder.disconnectOnSessionTimeout;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint to modify.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint to modify.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The ARN of the server certificate to be used. The server certificate must be provisioned in Certificate Manager
     * (ACM).
     * </p>
     * 
     * @return The ARN of the server certificate to be used. The server certificate must be provisioned in Certificate
     *         Manager (ACM).
     */
    public final String serverCertificateArn() {
        return serverCertificateArn;
    }

    /**
     * <p>
     * Information about the client connection logging options.
     * </p>
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream.
     * The following information is logged:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection results (successful and unsuccessful)
     * </p>
     * </li>
     * <li>
     * <p>
     * Reasons for unsuccessful client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection termination time
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the client connection logging options.</p>
     *         <p>
     *         If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
     *         stream. The following information is logged:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection results (successful and unsuccessful)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reasons for unsuccessful client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection termination time
     *         </p>
     *         </li>
     */
    public final ConnectionLogOptions connectionLogOptions() {
        return connectionLogOptions;
    }

    /**
     * <p>
     * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to two
     * DNS servers.
     * </p>
     * 
     * @return Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up
     *         to two DNS servers.
     */
    public final DnsServersOptionsModifyStructure dnsServers() {
        return dnsServers;
    }

    /**
     * <p>
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     * </p>
     * <p>
     * Valid Values: <code>443</code> | <code>1194</code>
     * </p>
     * <p>
     * Default Value: <code>443</code>
     * </p>
     * 
     * @return The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
     *         <p>
     *         Valid Values: <code>443</code> | <code>1194</code>
     *         </p>
     *         <p>
     *         Default Value: <code>443</code>
     */
    public final Integer vpnPort() {
        return vpnPort;
    }

    /**
     * <p>
     * A brief description of the Client VPN endpoint.
     * </p>
     * 
     * @return A brief description of the Client VPN endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the VPN is split-tunnel.
     * </p>
     * <p>
     * For information about split-tunnel VPN endpoints, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN
     * endpoint</a> in the <i>Client VPN Administrator Guide</i>.
     * </p>
     * 
     * @return Indicates whether the VPN is split-tunnel.</p>
     *         <p>
     *         For information about split-tunnel VPN endpoints, see <a
     *         href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client
     *         VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.
     */
    public final Boolean splitTunnel() {
        return splitTunnel;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more security groups to apply to the target network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of one or more security groups to apply to the target network.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the VPC to associate with the Client VPN endpoint.
     * </p>
     * 
     * @return The ID of the VPC to associate with the Client VPN endpoint.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selfServicePortal}
     * will return {@link SelfServicePortal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selfServicePortalAsString}.
     * </p>
     * 
     * @return Specify whether to enable the self-service portal for the Client VPN endpoint.
     * @see SelfServicePortal
     */
    public final SelfServicePortal selfServicePortal() {
        return SelfServicePortal.fromValue(selfServicePortal);
    }

    /**
     * <p>
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selfServicePortal}
     * will return {@link SelfServicePortal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selfServicePortalAsString}.
     * </p>
     * 
     * @return Specify whether to enable the self-service portal for the Client VPN endpoint.
     * @see SelfServicePortal
     */
    public final String selfServicePortalAsString() {
        return selfServicePortal;
    }

    /**
     * <p>
     * The options for managing connection authorization for new client connections.
     * </p>
     * 
     * @return The options for managing connection authorization for new client connections.
     */
    public final ClientConnectOptions clientConnectOptions() {
        return clientConnectOptions;
    }

    /**
     * <p>
     * The maximum VPN session duration time in hours.
     * </p>
     * <p>
     * Valid values: <code>8 | 10 | 12 | 24</code>
     * </p>
     * <p>
     * Default value: <code>24</code>
     * </p>
     * 
     * @return The maximum VPN session duration time in hours.</p>
     *         <p>
     *         Valid values: <code>8 | 10 | 12 | 24</code>
     *         </p>
     *         <p>
     *         Default value: <code>24</code>
     */
    public final Integer sessionTimeoutHours() {
        return sessionTimeoutHours;
    }

    /**
     * <p>
     * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients
     * when a VPN session is established.
     * </p>
     * 
     * @return Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
     *         clients when a VPN session is established.
     */
    public final ClientLoginBannerOptions clientLoginBannerOptions() {
        return clientLoginBannerOptions;
    }

    /**
     * <p>
     * Client route enforcement is a feature of the Client VPN service that helps enforce administrator defined routes
     * on devices connected through the VPN. T his feature helps improve your security posture by ensuring that network
     * traffic originating from a connected client is not inadvertently sent outside the VPN tunnel.
     * </p>
     * <p>
     * Client route enforcement works by monitoring the route table of a connected device for routing policy changes to
     * the VPN connection. If the feature detects any VPN routing policy modifications, it will automatically force an
     * update to the route table, reverting it back to the expected route configurations.
     * </p>
     * 
     * @return Client route enforcement is a feature of the Client VPN service that helps enforce administrator defined
     *         routes on devices connected through the VPN. T his feature helps improve your security posture by
     *         ensuring that network traffic originating from a connected client is not inadvertently sent outside the
     *         VPN tunnel.</p>
     *         <p>
     *         Client route enforcement works by monitoring the route table of a connected device for routing policy
     *         changes to the VPN connection. If the feature detects any VPN routing policy modifications, it will
     *         automatically force an update to the route table, reverting it back to the expected route configurations.
     */
    public final ClientRouteEnforcementOptions clientRouteEnforcementOptions() {
        return clientRouteEnforcementOptions;
    }

    /**
     * <p>
     * Indicates whether the client VPN session is disconnected after the maximum timeout specified in
     * <code>sessionTimeoutHours</code> is reached. If <code>true</code>, users are prompted to reconnect client VPN. If
     * <code>false</code>, client VPN attempts to reconnect automatically. The default value is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the client VPN session is disconnected after the maximum timeout specified in
     *         <code>sessionTimeoutHours</code> is reached. If <code>true</code>, users are prompted to reconnect client
     *         VPN. If <code>false</code>, client VPN attempts to reconnect automatically. The default value is
     *         <code>true</code>.
     */
    public final Boolean disconnectOnSessionTimeout() {
        return disconnectOnSessionTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(vpnPort());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(splitTunnel());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(selfServicePortalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientConnectOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutHours());
        hashCode = 31 * hashCode + Objects.hashCode(clientLoginBannerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(clientRouteEnforcementOptions());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectOnSessionTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClientVpnEndpointRequest)) {
            return false;
        }
        ModifyClientVpnEndpointRequest other = (ModifyClientVpnEndpointRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(serverCertificateArn(), other.serverCertificateArn())
                && Objects.equals(connectionLogOptions(), other.connectionLogOptions())
                && Objects.equals(dnsServers(), other.dnsServers()) && Objects.equals(vpnPort(), other.vpnPort())
                && Objects.equals(description(), other.description()) && Objects.equals(splitTunnel(), other.splitTunnel())
                && Objects.equals(dryRun(), other.dryRun()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(selfServicePortalAsString(), other.selfServicePortalAsString())
                && Objects.equals(clientConnectOptions(), other.clientConnectOptions())
                && Objects.equals(sessionTimeoutHours(), other.sessionTimeoutHours())
                && Objects.equals(clientLoginBannerOptions(), other.clientLoginBannerOptions())
                && Objects.equals(clientRouteEnforcementOptions(), other.clientRouteEnforcementOptions())
                && Objects.equals(disconnectOnSessionTimeout(), other.disconnectOnSessionTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClientVpnEndpointRequest").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("ServerCertificateArn", serverCertificateArn()).add("ConnectionLogOptions", connectionLogOptions())
                .add("DnsServers", dnsServers()).add("VpnPort", vpnPort()).add("Description", description())
                .add("SplitTunnel", splitTunnel()).add("DryRun", dryRun())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("VpcId", vpcId())
                .add("SelfServicePortal", selfServicePortalAsString()).add("ClientConnectOptions", clientConnectOptions())
                .add("SessionTimeoutHours", sessionTimeoutHours()).add("ClientLoginBannerOptions", clientLoginBannerOptions())
                .add("ClientRouteEnforcementOptions", clientRouteEnforcementOptions())
                .add("DisconnectOnSessionTimeout", disconnectOnSessionTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "ServerCertificateArn":
            return Optional.ofNullable(clazz.cast(serverCertificateArn()));
        case "ConnectionLogOptions":
            return Optional.ofNullable(clazz.cast(connectionLogOptions()));
        case "DnsServers":
            return Optional.ofNullable(clazz.cast(dnsServers()));
        case "VpnPort":
            return Optional.ofNullable(clazz.cast(vpnPort()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SplitTunnel":
            return Optional.ofNullable(clazz.cast(splitTunnel()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SelfServicePortal":
            return Optional.ofNullable(clazz.cast(selfServicePortalAsString()));
        case "ClientConnectOptions":
            return Optional.ofNullable(clazz.cast(clientConnectOptions()));
        case "SessionTimeoutHours":
            return Optional.ofNullable(clazz.cast(sessionTimeoutHours()));
        case "ClientLoginBannerOptions":
            return Optional.ofNullable(clazz.cast(clientLoginBannerOptions()));
        case "ClientRouteEnforcementOptions":
            return Optional.ofNullable(clazz.cast(clientRouteEnforcementOptions()));
        case "DisconnectOnSessionTimeout":
            return Optional.ofNullable(clazz.cast(disconnectOnSessionTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientVpnEndpointId", CLIENT_VPN_ENDPOINT_ID_FIELD);
        map.put("ServerCertificateArn", SERVER_CERTIFICATE_ARN_FIELD);
        map.put("ConnectionLogOptions", CONNECTION_LOG_OPTIONS_FIELD);
        map.put("DnsServers", DNS_SERVERS_FIELD);
        map.put("VpnPort", VPN_PORT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SplitTunnel", SPLIT_TUNNEL_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SelfServicePortal", SELF_SERVICE_PORTAL_FIELD);
        map.put("ClientConnectOptions", CLIENT_CONNECT_OPTIONS_FIELD);
        map.put("SessionTimeoutHours", SESSION_TIMEOUT_HOURS_FIELD);
        map.put("ClientLoginBannerOptions", CLIENT_LOGIN_BANNER_OPTIONS_FIELD);
        map.put("ClientRouteEnforcementOptions", CLIENT_ROUTE_ENFORCEMENT_OPTIONS_FIELD);
        map.put("DisconnectOnSessionTimeout", DISCONNECT_ON_SESSION_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyClientVpnEndpointRequest, T> g) {
        return obj -> g.apply((ModifyClientVpnEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClientVpnEndpointRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint to modify.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The ARN of the server certificate to be used. The server certificate must be provisioned in Certificate
         * Manager (ACM).
         * </p>
         * 
         * @param serverCertificateArn
         *        The ARN of the server certificate to be used. The server certificate must be provisioned in
         *        Certificate Manager (ACM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateArn(String serverCertificateArn);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionLogOptions
         *        Information about the client connection logging options.</p>
         *        <p>
         *        If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs
         *        log stream. The following information is logged:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection results (successful and unsuccessful)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reasons for unsuccessful client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection termination time
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ConnectionLogOptions.Builder} avoiding
         * the need to create one manually via {@link ConnectionLogOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionLogOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionLogOptions(ConnectionLogOptions)}.
         * 
         * @param connectionLogOptions
         *        a consumer that will call methods on {@link ConnectionLogOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionLogOptions(ConnectionLogOptions)
         */
        default Builder connectionLogOptions(Consumer<ConnectionLogOptions.Builder> connectionLogOptions) {
            return connectionLogOptions(ConnectionLogOptions.builder().applyMutation(connectionLogOptions).build());
        }

        /**
         * <p>
         * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to
         * two DNS servers.
         * </p>
         * 
         * @param dnsServers
         *        Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have
         *        up to two DNS servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(DnsServersOptionsModifyStructure dnsServers);

        /**
         * <p>
         * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to
         * two DNS servers.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsServersOptionsModifyStructure.Builder}
         * avoiding the need to create one manually via {@link DnsServersOptionsModifyStructure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsServersOptionsModifyStructure.Builder#build()} is called
         * immediately and its result is passed to {@link #dnsServers(DnsServersOptionsModifyStructure)}.
         * 
         * @param dnsServers
         *        a consumer that will call methods on {@link DnsServersOptionsModifyStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsServers(DnsServersOptionsModifyStructure)
         */
        default Builder dnsServers(Consumer<DnsServersOptionsModifyStructure.Builder> dnsServers) {
            return dnsServers(DnsServersOptionsModifyStructure.builder().applyMutation(dnsServers).build());
        }

        /**
         * <p>
         * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * </p>
         * <p>
         * Valid Values: <code>443</code> | <code>1194</code>
         * </p>
         * <p>
         * Default Value: <code>443</code>
         * </p>
         * 
         * @param vpnPort
         *        The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
         *        <p>
         *        Valid Values: <code>443</code> | <code>1194</code>
         *        </p>
         *        <p>
         *        Default Value: <code>443</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnPort(Integer vpnPort);

        /**
         * <p>
         * A brief description of the Client VPN endpoint.
         * </p>
         * 
         * @param description
         *        A brief description of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the VPN is split-tunnel.
         * </p>
         * <p>
         * For information about split-tunnel VPN endpoints, see <a
         * href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN
         * endpoint</a> in the <i>Client VPN Administrator Guide</i>.
         * </p>
         * 
         * @param splitTunnel
         *        Indicates whether the VPN is split-tunnel.</p>
         *        <p>
         *        For information about split-tunnel VPN endpoints, see <a
         *        href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel
         *        Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitTunnel(Boolean splitTunnel);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The IDs of one or more security groups to apply to the target network.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups to apply to the target network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of one or more security groups to apply to the target network.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups to apply to the target network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the VPC to associate with the Client VPN endpoint.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC to associate with the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         * </p>
         * 
         * @param selfServicePortal
         *        Specify whether to enable the self-service portal for the Client VPN endpoint.
         * @see SelfServicePortal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfServicePortal
         */
        Builder selfServicePortal(String selfServicePortal);

        /**
         * <p>
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         * </p>
         * 
         * @param selfServicePortal
         *        Specify whether to enable the self-service portal for the Client VPN endpoint.
         * @see SelfServicePortal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfServicePortal
         */
        Builder selfServicePortal(SelfServicePortal selfServicePortal);

        /**
         * <p>
         * The options for managing connection authorization for new client connections.
         * </p>
         * 
         * @param clientConnectOptions
         *        The options for managing connection authorization for new client connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConnectOptions(ClientConnectOptions clientConnectOptions);

        /**
         * <p>
         * The options for managing connection authorization for new client connections.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientConnectOptions.Builder} avoiding
         * the need to create one manually via {@link ClientConnectOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientConnectOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #clientConnectOptions(ClientConnectOptions)}.
         * 
         * @param clientConnectOptions
         *        a consumer that will call methods on {@link ClientConnectOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientConnectOptions(ClientConnectOptions)
         */
        default Builder clientConnectOptions(Consumer<ClientConnectOptions.Builder> clientConnectOptions) {
            return clientConnectOptions(ClientConnectOptions.builder().applyMutation(clientConnectOptions).build());
        }

        /**
         * <p>
         * The maximum VPN session duration time in hours.
         * </p>
         * <p>
         * Valid values: <code>8 | 10 | 12 | 24</code>
         * </p>
         * <p>
         * Default value: <code>24</code>
         * </p>
         * 
         * @param sessionTimeoutHours
         *        The maximum VPN session duration time in hours.</p>
         *        <p>
         *        Valid values: <code>8 | 10 | 12 | 24</code>
         *        </p>
         *        <p>
         *        Default value: <code>24</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutHours(Integer sessionTimeoutHours);

        /**
         * <p>
         * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         * clients when a VPN session is established.
         * </p>
         * 
         * @param clientLoginBannerOptions
         *        Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         *        clients when a VPN session is established.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientLoginBannerOptions(ClientLoginBannerOptions clientLoginBannerOptions);

        /**
         * <p>
         * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         * clients when a VPN session is established.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientLoginBannerOptions.Builder}
         * avoiding the need to create one manually via {@link ClientLoginBannerOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientLoginBannerOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #clientLoginBannerOptions(ClientLoginBannerOptions)}.
         * 
         * @param clientLoginBannerOptions
         *        a consumer that will call methods on {@link ClientLoginBannerOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientLoginBannerOptions(ClientLoginBannerOptions)
         */
        default Builder clientLoginBannerOptions(Consumer<ClientLoginBannerOptions.Builder> clientLoginBannerOptions) {
            return clientLoginBannerOptions(ClientLoginBannerOptions.builder().applyMutation(clientLoginBannerOptions).build());
        }

        /**
         * <p>
         * Client route enforcement is a feature of the Client VPN service that helps enforce administrator defined
         * routes on devices connected through the VPN. T his feature helps improve your security posture by ensuring
         * that network traffic originating from a connected client is not inadvertently sent outside the VPN tunnel.
         * </p>
         * <p>
         * Client route enforcement works by monitoring the route table of a connected device for routing policy changes
         * to the VPN connection. If the feature detects any VPN routing policy modifications, it will automatically
         * force an update to the route table, reverting it back to the expected route configurations.
         * </p>
         * 
         * @param clientRouteEnforcementOptions
         *        Client route enforcement is a feature of the Client VPN service that helps enforce administrator
         *        defined routes on devices connected through the VPN. T his feature helps improve your security posture
         *        by ensuring that network traffic originating from a connected client is not inadvertently sent outside
         *        the VPN tunnel.</p>
         *        <p>
         *        Client route enforcement works by monitoring the route table of a connected device for routing policy
         *        changes to the VPN connection. If the feature detects any VPN routing policy modifications, it will
         *        automatically force an update to the route table, reverting it back to the expected route
         *        configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRouteEnforcementOptions(ClientRouteEnforcementOptions clientRouteEnforcementOptions);

        /**
         * <p>
         * Client route enforcement is a feature of the Client VPN service that helps enforce administrator defined
         * routes on devices connected through the VPN. T his feature helps improve your security posture by ensuring
         * that network traffic originating from a connected client is not inadvertently sent outside the VPN tunnel.
         * </p>
         * <p>
         * Client route enforcement works by monitoring the route table of a connected device for routing policy changes
         * to the VPN connection. If the feature detects any VPN routing policy modifications, it will automatically
         * force an update to the route table, reverting it back to the expected route configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientRouteEnforcementOptions.Builder}
         * avoiding the need to create one manually via {@link ClientRouteEnforcementOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientRouteEnforcementOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #clientRouteEnforcementOptions(ClientRouteEnforcementOptions)}.
         * 
         * @param clientRouteEnforcementOptions
         *        a consumer that will call methods on {@link ClientRouteEnforcementOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientRouteEnforcementOptions(ClientRouteEnforcementOptions)
         */
        default Builder clientRouteEnforcementOptions(
                Consumer<ClientRouteEnforcementOptions.Builder> clientRouteEnforcementOptions) {
            return clientRouteEnforcementOptions(ClientRouteEnforcementOptions.builder()
                    .applyMutation(clientRouteEnforcementOptions).build());
        }

        /**
         * <p>
         * Indicates whether the client VPN session is disconnected after the maximum timeout specified in
         * <code>sessionTimeoutHours</code> is reached. If <code>true</code>, users are prompted to reconnect client
         * VPN. If <code>false</code>, client VPN attempts to reconnect automatically. The default value is
         * <code>true</code>.
         * </p>
         * 
         * @param disconnectOnSessionTimeout
         *        Indicates whether the client VPN session is disconnected after the maximum timeout specified in
         *        <code>sessionTimeoutHours</code> is reached. If <code>true</code>, users are prompted to reconnect
         *        client VPN. If <code>false</code>, client VPN attempts to reconnect automatically. The default value
         *        is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectOnSessionTimeout(Boolean disconnectOnSessionTimeout);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String serverCertificateArn;

        private ConnectionLogOptions connectionLogOptions;

        private DnsServersOptionsModifyStructure dnsServers;

        private Integer vpnPort;

        private String description;

        private Boolean splitTunnel;

        private Boolean dryRun;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private String selfServicePortal;

        private ClientConnectOptions clientConnectOptions;

        private Integer sessionTimeoutHours;

        private ClientLoginBannerOptions clientLoginBannerOptions;

        private ClientRouteEnforcementOptions clientRouteEnforcementOptions;

        private Boolean disconnectOnSessionTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClientVpnEndpointRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            serverCertificateArn(model.serverCertificateArn);
            connectionLogOptions(model.connectionLogOptions);
            dnsServers(model.dnsServers);
            vpnPort(model.vpnPort);
            description(model.description);
            splitTunnel(model.splitTunnel);
            dryRun(model.dryRun);
            securityGroupIds(model.securityGroupIds);
            vpcId(model.vpcId);
            selfServicePortal(model.selfServicePortal);
            clientConnectOptions(model.clientConnectOptions);
            sessionTimeoutHours(model.sessionTimeoutHours);
            clientLoginBannerOptions(model.clientLoginBannerOptions);
            clientRouteEnforcementOptions(model.clientRouteEnforcementOptions);
            disconnectOnSessionTimeout(model.disconnectOnSessionTimeout);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getServerCertificateArn() {
            return serverCertificateArn;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final ConnectionLogOptions.Builder getConnectionLogOptions() {
            return connectionLogOptions != null ? connectionLogOptions.toBuilder() : null;
        }

        public final void setConnectionLogOptions(ConnectionLogOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final DnsServersOptionsModifyStructure.Builder getDnsServers() {
            return dnsServers != null ? dnsServers.toBuilder() : null;
        }

        public final void setDnsServers(DnsServersOptionsModifyStructure.BuilderImpl dnsServers) {
            this.dnsServers = dnsServers != null ? dnsServers.build() : null;
        }

        @Override
        public final Builder dnsServers(DnsServersOptionsModifyStructure dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public final Integer getVpnPort() {
            return vpnPort;
        }

        public final void setVpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
        }

        @Override
        public final Builder vpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getSplitTunnel() {
            return splitTunnel;
        }

        public final void setSplitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
        }

        @Override
        public final Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ClientVpnSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ClientVpnSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSelfServicePortal() {
            return selfServicePortal;
        }

        public final void setSelfServicePortal(String selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
        }

        @Override
        public final Builder selfServicePortal(String selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
            return this;
        }

        @Override
        public final Builder selfServicePortal(SelfServicePortal selfServicePortal) {
            this.selfServicePortal(selfServicePortal == null ? null : selfServicePortal.toString());
            return this;
        }

        public final ClientConnectOptions.Builder getClientConnectOptions() {
            return clientConnectOptions != null ? clientConnectOptions.toBuilder() : null;
        }

        public final void setClientConnectOptions(ClientConnectOptions.BuilderImpl clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions != null ? clientConnectOptions.build() : null;
        }

        @Override
        public final Builder clientConnectOptions(ClientConnectOptions clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions;
            return this;
        }

        public final Integer getSessionTimeoutHours() {
            return sessionTimeoutHours;
        }

        public final void setSessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
        }

        @Override
        public final Builder sessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        public final ClientLoginBannerOptions.Builder getClientLoginBannerOptions() {
            return clientLoginBannerOptions != null ? clientLoginBannerOptions.toBuilder() : null;
        }

        public final void setClientLoginBannerOptions(ClientLoginBannerOptions.BuilderImpl clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions != null ? clientLoginBannerOptions.build() : null;
        }

        @Override
        public final Builder clientLoginBannerOptions(ClientLoginBannerOptions clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        public final ClientRouteEnforcementOptions.Builder getClientRouteEnforcementOptions() {
            return clientRouteEnforcementOptions != null ? clientRouteEnforcementOptions.toBuilder() : null;
        }

        public final void setClientRouteEnforcementOptions(ClientRouteEnforcementOptions.BuilderImpl clientRouteEnforcementOptions) {
            this.clientRouteEnforcementOptions = clientRouteEnforcementOptions != null ? clientRouteEnforcementOptions.build()
                    : null;
        }

        @Override
        public final Builder clientRouteEnforcementOptions(ClientRouteEnforcementOptions clientRouteEnforcementOptions) {
            this.clientRouteEnforcementOptions = clientRouteEnforcementOptions;
            return this;
        }

        public final Boolean getDisconnectOnSessionTimeout() {
            return disconnectOnSessionTimeout;
        }

        public final void setDisconnectOnSessionTimeout(Boolean disconnectOnSessionTimeout) {
            this.disconnectOnSessionTimeout = disconnectOnSessionTimeout;
        }

        @Override
        public final Builder disconnectOnSessionTimeout(Boolean disconnectOnSessionTimeout) {
            this.disconnectOnSessionTimeout = disconnectOnSessionTimeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClientVpnEndpointRequest build() {
            return new ModifyClientVpnEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
