/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterImageResponse extends Ec2Response implements
        ToCopyableBuilder<DeregisterImageResponse.Builder, DeregisterImageResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Return")
            .getter(getter(DeregisterImageResponse::returnValue))
            .setter(setter(Builder::returnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return")
                    .unmarshallLocationName("return").build()).build();

    private static final SdkField<List<DeleteSnapshotReturnCode>> DELETE_SNAPSHOT_RESULTS_FIELD = SdkField
            .<List<DeleteSnapshotReturnCode>> builder(MarshallingType.LIST)
            .memberName("DeleteSnapshotResults")
            .getter(getter(DeregisterImageResponse::deleteSnapshotResults))
            .setter(setter(Builder::deleteSnapshotResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteSnapshotResultSet")
                    .unmarshallLocationName("deleteSnapshotResultSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DeleteSnapshotReturnCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteSnapshotReturnCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD,
            DELETE_SNAPSHOT_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean returnValue;

    private final List<DeleteSnapshotReturnCode> deleteSnapshotResults;

    private DeregisterImageResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.deleteSnapshotResults = builder.deleteSnapshotResults;
    }

    /**
     * <p>
     * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     * </p>
     * 
     * @return Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     */
    public final Boolean returnValue() {
        return returnValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeleteSnapshotResults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeleteSnapshotResults() {
        return deleteSnapshotResults != null && !(deleteSnapshotResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The deletion result for each snapshot associated with the AMI, including the snapshot ID and its success or error
     * code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeleteSnapshotResults} method.
     * </p>
     * 
     * @return The deletion result for each snapshot associated with the AMI, including the snapshot ID and its success
     *         or error code.
     */
    public final List<DeleteSnapshotReturnCode> deleteSnapshotResults() {
        return deleteSnapshotResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeleteSnapshotResults() ? deleteSnapshotResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterImageResponse)) {
            return false;
        }
        DeregisterImageResponse other = (DeregisterImageResponse) obj;
        return Objects.equals(returnValue(), other.returnValue())
                && hasDeleteSnapshotResults() == other.hasDeleteSnapshotResults()
                && Objects.equals(deleteSnapshotResults(), other.deleteSnapshotResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterImageResponse").add("Return", returnValue())
                .add("DeleteSnapshotResults", hasDeleteSnapshotResults() ? deleteSnapshotResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Return":
            return Optional.ofNullable(clazz.cast(returnValue()));
        case "DeleteSnapshotResults":
            return Optional.ofNullable(clazz.cast(deleteSnapshotResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Return", RETURN_FIELD);
        map.put("DeleteSnapshotResultSet", DELETE_SNAPSHOT_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterImageResponse, T> g) {
        return obj -> g.apply((DeregisterImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeregisterImageResponse> {
        /**
         * <p>
         * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * </p>
         * 
         * @param returnValue
         *        Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);

        /**
         * <p>
         * The deletion result for each snapshot associated with the AMI, including the snapshot ID and its success or
         * error code.
         * </p>
         * 
         * @param deleteSnapshotResults
         *        The deletion result for each snapshot associated with the AMI, including the snapshot ID and its
         *        success or error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteSnapshotResults(Collection<DeleteSnapshotReturnCode> deleteSnapshotResults);

        /**
         * <p>
         * The deletion result for each snapshot associated with the AMI, including the snapshot ID and its success or
         * error code.
         * </p>
         * 
         * @param deleteSnapshotResults
         *        The deletion result for each snapshot associated with the AMI, including the snapshot ID and its
         *        success or error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteSnapshotResults(DeleteSnapshotReturnCode... deleteSnapshotResults);

        /**
         * <p>
         * The deletion result for each snapshot associated with the AMI, including the snapshot ID and its success or
         * error code.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DeleteSnapshotReturnCode.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.DeleteSnapshotReturnCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DeleteSnapshotReturnCode.Builder#build()} is called
         * immediately and its result is passed to {@link #deleteSnapshotResults(List<DeleteSnapshotReturnCode>)}.
         * 
         * @param deleteSnapshotResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DeleteSnapshotReturnCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteSnapshotResults(java.util.Collection<DeleteSnapshotReturnCode>)
         */
        Builder deleteSnapshotResults(Consumer<DeleteSnapshotReturnCode.Builder>... deleteSnapshotResults);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean returnValue;

        private List<DeleteSnapshotReturnCode> deleteSnapshotResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterImageResponse model) {
            super(model);
            returnValue(model.returnValue);
            deleteSnapshotResults(model.deleteSnapshotResults);
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final List<DeleteSnapshotReturnCode.Builder> getDeleteSnapshotResults() {
            List<DeleteSnapshotReturnCode.Builder> result = DeleteSnapshotResultSetCopier
                    .copyToBuilder(this.deleteSnapshotResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeleteSnapshotResults(Collection<DeleteSnapshotReturnCode.BuilderImpl> deleteSnapshotResults) {
            this.deleteSnapshotResults = DeleteSnapshotResultSetCopier.copyFromBuilder(deleteSnapshotResults);
        }

        @Override
        public final Builder deleteSnapshotResults(Collection<DeleteSnapshotReturnCode> deleteSnapshotResults) {
            this.deleteSnapshotResults = DeleteSnapshotResultSetCopier.copy(deleteSnapshotResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteSnapshotResults(DeleteSnapshotReturnCode... deleteSnapshotResults) {
            deleteSnapshotResults(Arrays.asList(deleteSnapshotResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteSnapshotResults(Consumer<DeleteSnapshotReturnCode.Builder>... deleteSnapshotResults) {
            deleteSnapshotResults(Stream.of(deleteSnapshotResults)
                    .map(c -> DeleteSnapshotReturnCode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeregisterImageResponse build() {
            return new DeregisterImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
