/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A security group association with a VPC that you made with <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateSecurityGroupVpc.html"
 * >AssociateSecurityGroupVpc</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupVpcAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupVpcAssociation.Builder, SecurityGroupVpcAssociation> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(SecurityGroupVpcAssociation::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(SecurityGroupVpcAssociation::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> VPC_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcOwnerId")
            .getter(getter(SecurityGroupVpcAssociation::vpcOwnerId))
            .setter(setter(Builder::vpcOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOwnerId")
                    .unmarshallLocationName("vpcOwnerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(SecurityGroupVpcAssociation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateReason")
            .getter(getter(SecurityGroupVpcAssociation::stateReason))
            .setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<String> GROUP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupOwnerId")
            .getter(getter(SecurityGroupVpcAssociation::groupOwnerId))
            .setter(setter(Builder::groupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwnerId")
                    .unmarshallLocationName("groupOwnerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, VPC_ID_FIELD,
            VPC_OWNER_ID_FIELD, STATE_FIELD, STATE_REASON_FIELD, GROUP_OWNER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final String vpcId;

    private final String vpcOwnerId;

    private final String state;

    private final String stateReason;

    private final String groupOwnerId;

    private SecurityGroupVpcAssociation(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.vpcId = builder.vpcId;
        this.vpcOwnerId = builder.vpcOwnerId;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.groupOwnerId = builder.groupOwnerId;
    }

    /**
     * <p>
     * The association's security group ID.
     * </p>
     * 
     * @return The association's security group ID.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The association's VPC ID.
     * </p>
     * 
     * @return The association's VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the VPC.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the VPC.
     */
    public final String vpcOwnerId() {
        return vpcOwnerId;
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecurityGroupVpcAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The association's state.
     * @see SecurityGroupVpcAssociationState
     */
    public final SecurityGroupVpcAssociationState state() {
        return SecurityGroupVpcAssociationState.fromValue(state);
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SecurityGroupVpcAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The association's state.
     * @see SecurityGroupVpcAssociationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The association's state reason.
     * </p>
     * 
     * @return The association's state reason.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the security group.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the security group.
     */
    public final String groupOwnerId() {
        return groupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(groupOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupVpcAssociation)) {
            return false;
        }
        SecurityGroupVpcAssociation other = (SecurityGroupVpcAssociation) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(vpcOwnerId(), other.vpcOwnerId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(groupOwnerId(), other.groupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroupVpcAssociation").add("GroupId", groupId()).add("VpcId", vpcId())
                .add("VpcOwnerId", vpcOwnerId()).add("State", stateAsString()).add("StateReason", stateReason())
                .add("GroupOwnerId", groupOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcOwnerId":
            return Optional.ofNullable(clazz.cast(vpcOwnerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "GroupOwnerId":
            return Optional.ofNullable(clazz.cast(groupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcOwnerId", VPC_OWNER_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("GroupOwnerId", GROUP_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupVpcAssociation, T> g) {
        return obj -> g.apply((SecurityGroupVpcAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupVpcAssociation> {
        /**
         * <p>
         * The association's security group ID.
         * </p>
         * 
         * @param groupId
         *        The association's security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The association's VPC ID.
         * </p>
         * 
         * @param vpcId
         *        The association's VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the VPC.
         * </p>
         * 
         * @param vpcOwnerId
         *        The Amazon Web Services account ID of the owner of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOwnerId(String vpcOwnerId);

        /**
         * <p>
         * The association's state.
         * </p>
         * 
         * @param state
         *        The association's state.
         * @see SecurityGroupVpcAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityGroupVpcAssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The association's state.
         * </p>
         * 
         * @param state
         *        The association's state.
         * @see SecurityGroupVpcAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityGroupVpcAssociationState
         */
        Builder state(SecurityGroupVpcAssociationState state);

        /**
         * <p>
         * The association's state reason.
         * </p>
         * 
         * @param stateReason
         *        The association's state reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the security group.
         * </p>
         * 
         * @param groupOwnerId
         *        The Amazon Web Services account ID of the owner of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupOwnerId(String groupOwnerId);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String vpcId;

        private String vpcOwnerId;

        private String state;

        private String stateReason;

        private String groupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupVpcAssociation model) {
            groupId(model.groupId);
            vpcId(model.vpcId);
            vpcOwnerId(model.vpcOwnerId);
            state(model.state);
            stateReason(model.stateReason);
            groupOwnerId(model.groupOwnerId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcOwnerId() {
            return vpcOwnerId;
        }

        public final void setVpcOwnerId(String vpcOwnerId) {
            this.vpcOwnerId = vpcOwnerId;
        }

        @Override
        public final Builder vpcOwnerId(String vpcOwnerId) {
            this.vpcOwnerId = vpcOwnerId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecurityGroupVpcAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getGroupOwnerId() {
            return groupOwnerId;
        }

        public final void setGroupOwnerId(String groupOwnerId) {
            this.groupOwnerId = groupOwnerId;
        }

        @Override
        public final Builder groupOwnerId(String groupOwnerId) {
            this.groupOwnerId = groupOwnerId;
            return this;
        }

        @Override
        public SecurityGroupVpcAssociation build() {
            return new SecurityGroupVpcAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
