/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationFleetInstanceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationFleetInstanceSpecification> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ReservationFleetInstanceSpecification.getter(ReservationFleetInstanceSpecification::instanceTypeAsString)).setter(ReservationFleetInstanceSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstancePlatform").getter(ReservationFleetInstanceSpecification.getter(ReservationFleetInstanceSpecification::instancePlatformAsString)).setter(ReservationFleetInstanceSpecification.setter(Builder::instancePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform").unmarshallLocationName("InstancePlatform").build()}).build();
    private static final SdkField<Double> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Weight").getter(ReservationFleetInstanceSpecification.getter(ReservationFleetInstanceSpecification::weight)).setter(ReservationFleetInstanceSpecification.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").unmarshallLocationName("Weight").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ReservationFleetInstanceSpecification.getter(ReservationFleetInstanceSpecification::availabilityZone)).setter(ReservationFleetInstanceSpecification.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(ReservationFleetInstanceSpecification.getter(ReservationFleetInstanceSpecification::availabilityZoneId)).setter(ReservationFleetInstanceSpecification.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(ReservationFleetInstanceSpecification.getter(ReservationFleetInstanceSpecification::ebsOptimized)).setter(ReservationFleetInstanceSpecification.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("EbsOptimized").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(ReservationFleetInstanceSpecification.getter(ReservationFleetInstanceSpecification::priority)).setter(ReservationFleetInstanceSpecification.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("Priority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, WEIGHT_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, EBS_OPTIMIZED_FIELD, PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservationFleetInstanceSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final String instancePlatform;
    private final Double weight;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final Boolean ebsOptimized;
    private final Integer priority;

    private ReservationFleetInstanceSpecification(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.weight = builder.weight;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.ebsOptimized = builder.ebsOptimized;
        this.priority = builder.priority;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(this.instancePlatform);
    }

    public final String instancePlatformAsString() {
        return this.instancePlatform;
    }

    public final Double weight() {
        return this.weight;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final Integer priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationFleetInstanceSpecification)) {
            return false;
        }
        ReservationFleetInstanceSpecification other = (ReservationFleetInstanceSpecification)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instancePlatformAsString(), other.instancePlatformAsString()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.priority(), other.priority());
    }

    public final String toString() {
        return ToString.builder((String)"ReservationFleetInstanceSpecification").add("InstanceType", (Object)this.instanceTypeAsString()).add("InstancePlatform", (Object)this.instancePlatformAsString()).add("Weight", (Object)this.weight()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("EbsOptimized", (Object)this.ebsOptimized()).add("Priority", (Object)this.priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstancePlatform": {
                return Optional.ofNullable(clazz.cast(this.instancePlatformAsString()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservationFleetInstanceSpecification, T> g) {
        return obj -> g.apply((ReservationFleetInstanceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String instancePlatform;
        private Double weight;
        private String availabilityZone;
        private String availabilityZoneId;
        private Boolean ebsOptimized;
        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationFleetInstanceSpecification model) {
            this.instanceType(model.instanceType);
            this.instancePlatform(model.instancePlatform);
            this.weight(model.weight);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.ebsOptimized(model.ebsOptimized);
            this.priority(model.priority);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getInstancePlatform() {
            return this.instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final Double getWeight() {
            return this.weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public ReservationFleetInstanceSpecification build() {
            return new ReservationFleetInstanceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationFleetInstanceSpecification> {
        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder instancePlatform(String var1);

        public Builder instancePlatform(CapacityReservationInstancePlatform var1);

        public Builder weight(Double var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder priority(Integer var1);
    }
}

