/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVerifiedAccessGroupRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVerifiedAccessGroupRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(CreateVerifiedAccessGroupRequest.getter(CreateVerifiedAccessGroupRequest::verifiedAccessInstanceId)).setter(CreateVerifiedAccessGroupRequest.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("VerifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateVerifiedAccessGroupRequest.getter(CreateVerifiedAccessGroupRequest::description)).setter(CreateVerifiedAccessGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(CreateVerifiedAccessGroupRequest.getter(CreateVerifiedAccessGroupRequest::policyDocument)).setter(CreateVerifiedAccessGroupRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("PolicyDocument").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVerifiedAccessGroupRequest.getter(CreateVerifiedAccessGroupRequest::tagSpecifications)).setter(CreateVerifiedAccessGroupRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVerifiedAccessGroupRequest.getter(CreateVerifiedAccessGroupRequest::clientToken)).setter(CreateVerifiedAccessGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVerifiedAccessGroupRequest.getter(CreateVerifiedAccessGroupRequest::dryRun)).setter(CreateVerifiedAccessGroupRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<VerifiedAccessSseSpecificationRequest> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseSpecification").getter(CreateVerifiedAccessGroupRequest.getter(CreateVerifiedAccessGroupRequest::sseSpecification)).setter(CreateVerifiedAccessGroupRequest.setter(Builder::sseSpecification)).constructor(VerifiedAccessSseSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification").unmarshallLocationName("SseSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_INSTANCE_ID_FIELD, DESCRIPTION_FIELD, POLICY_DOCUMENT_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, SSE_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVerifiedAccessGroupRequest.memberNameToFieldInitializer();
    private final String verifiedAccessInstanceId;
    private final String description;
    private final String policyDocument;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final Boolean dryRun;
    private final VerifiedAccessSseSpecificationRequest sseSpecification;

    private CreateVerifiedAccessGroupRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.description = builder.description;
        this.policyDocument = builder.policyDocument;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.sseSpecification = builder.sseSpecification;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String description() {
        return this.description;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final VerifiedAccessSseSpecificationRequest sseSpecification() {
        return this.sseSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessGroupRequest)) {
            return false;
        }
        CreateVerifiedAccessGroupRequest other = (CreateVerifiedAccessGroupRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.policyDocument(), other.policyDocument()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.sseSpecification(), other.sseSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVerifiedAccessGroupRequest").add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("Description", (Object)this.description()).add("PolicyDocument", (Object)this.policyDocument()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("SseSpecification", (Object)this.sseSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SseSpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessGroupRequest, T> g) {
        return obj -> g.apply((CreateVerifiedAccessGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessInstanceId;
        private String description;
        private String policyDocument;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Boolean dryRun;
        private VerifiedAccessSseSpecificationRequest sseSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessGroupRequest model) {
            super(model);
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.description(model.description);
            this.policyDocument(model.policyDocument);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.sseSpecification(model.sseSpecification);
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final VerifiedAccessSseSpecificationRequest.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationRequest.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVerifiedAccessGroupRequest build() {
            return new CreateVerifiedAccessGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVerifiedAccessGroupRequest> {
        public Builder verifiedAccessInstanceId(String var1);

        public Builder description(String var1);

        public Builder policyDocument(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder sseSpecification(VerifiedAccessSseSpecificationRequest var1);

        default public Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationRequest.Builder> sseSpecification) {
            return this.sseSpecification((VerifiedAccessSseSpecificationRequest)((VerifiedAccessSseSpecificationRequest.Builder)VerifiedAccessSseSpecificationRequest.builder().applyMutation(sseSpecification)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

