/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEbsEncryptionByDefaultResponse extends Ec2Response implements
        ToCopyableBuilder<GetEbsEncryptionByDefaultResponse.Builder, GetEbsEncryptionByDefaultResponse> {
    private static final SdkField<Boolean> EBS_ENCRYPTION_BY_DEFAULT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsEncryptionByDefault")
            .getter(getter(GetEbsEncryptionByDefaultResponse::ebsEncryptionByDefault))
            .setter(setter(Builder::ebsEncryptionByDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsEncryptionByDefault")
                    .unmarshallLocationName("ebsEncryptionByDefault").build()).build();

    private static final SdkField<String> SSE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SseType")
            .getter(getter(GetEbsEncryptionByDefaultResponse::sseTypeAsString))
            .setter(setter(Builder::sseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType")
                    .unmarshallLocationName("sseType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EBS_ENCRYPTION_BY_DEFAULT_FIELD, SSE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean ebsEncryptionByDefault;

    private final String sseType;

    private GetEbsEncryptionByDefaultResponse(BuilderImpl builder) {
        super(builder);
        this.ebsEncryptionByDefault = builder.ebsEncryptionByDefault;
        this.sseType = builder.sseType;
    }

    /**
     * <p>
     * Indicates whether encryption by default is enabled.
     * </p>
     * 
     * @return Indicates whether encryption by default is enabled.
     */
    public final Boolean ebsEncryptionByDefault() {
        return ebsEncryptionByDefault;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see SSEType
     */
    public final SSEType sseType() {
        return SSEType.fromValue(sseType);
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see SSEType
     */
    public final String sseTypeAsString() {
        return sseType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionByDefault());
        hashCode = 31 * hashCode + Objects.hashCode(sseTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEbsEncryptionByDefaultResponse)) {
            return false;
        }
        GetEbsEncryptionByDefaultResponse other = (GetEbsEncryptionByDefaultResponse) obj;
        return Objects.equals(ebsEncryptionByDefault(), other.ebsEncryptionByDefault())
                && Objects.equals(sseTypeAsString(), other.sseTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEbsEncryptionByDefaultResponse").add("EbsEncryptionByDefault", ebsEncryptionByDefault())
                .add("SseType", sseTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsEncryptionByDefault":
            return Optional.ofNullable(clazz.cast(ebsEncryptionByDefault()));
        case "SseType":
            return Optional.ofNullable(clazz.cast(sseTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EbsEncryptionByDefault", EBS_ENCRYPTION_BY_DEFAULT_FIELD);
        map.put("SseType", SSE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEbsEncryptionByDefaultResponse, T> g) {
        return obj -> g.apply((GetEbsEncryptionByDefaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetEbsEncryptionByDefaultResponse> {
        /**
         * <p>
         * Indicates whether encryption by default is enabled.
         * </p>
         * 
         * @param ebsEncryptionByDefault
         *        Indicates whether encryption by default is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsEncryptionByDefault(Boolean ebsEncryptionByDefault);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(String sseType);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(SSEType sseType);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean ebsEncryptionByDefault;

        private String sseType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEbsEncryptionByDefaultResponse model) {
            super(model);
            ebsEncryptionByDefault(model.ebsEncryptionByDefault);
            sseType(model.sseType);
        }

        public final Boolean getEbsEncryptionByDefault() {
            return ebsEncryptionByDefault;
        }

        public final void setEbsEncryptionByDefault(Boolean ebsEncryptionByDefault) {
            this.ebsEncryptionByDefault = ebsEncryptionByDefault;
        }

        @Override
        public final Builder ebsEncryptionByDefault(Boolean ebsEncryptionByDefault) {
            this.ebsEncryptionByDefault = ebsEncryptionByDefault;
            return this;
        }

        public final String getSseType() {
            return sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        @Override
        public GetEbsEncryptionByDefaultResponse build() {
            return new GetEbsEncryptionByDefaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
