/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFastLaunchImagesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeFastLaunchImagesResponse.Builder, DescribeFastLaunchImagesResponse> {
    private static final SdkField<List<DescribeFastLaunchImagesSuccessItem>> FAST_LAUNCH_IMAGES_FIELD = SdkField
            .<List<DescribeFastLaunchImagesSuccessItem>> builder(MarshallingType.LIST)
            .memberName("FastLaunchImages")
            .getter(getter(DescribeFastLaunchImagesResponse::fastLaunchImages))
            .setter(setter(Builder::fastLaunchImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastLaunchImageSet")
                    .unmarshallLocationName("fastLaunchImageSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DescribeFastLaunchImagesSuccessItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeFastLaunchImagesSuccessItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeFastLaunchImagesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAST_LAUNCH_IMAGES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DescribeFastLaunchImagesSuccessItem> fastLaunchImages;

    private final String nextToken;

    private DescribeFastLaunchImagesResponse(BuilderImpl builder) {
        super(builder);
        this.fastLaunchImages = builder.fastLaunchImages;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FastLaunchImages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFastLaunchImages() {
        return fastLaunchImages != null && !(fastLaunchImages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of details about the fast-launch enabled Windows images that meet the requested criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFastLaunchImages} method.
     * </p>
     * 
     * @return A collection of details about the fast-launch enabled Windows images that meet the requested criteria.
     */
    public final List<DescribeFastLaunchImagesSuccessItem> fastLaunchImages() {
        return fastLaunchImages;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFastLaunchImages() ? fastLaunchImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFastLaunchImagesResponse)) {
            return false;
        }
        DescribeFastLaunchImagesResponse other = (DescribeFastLaunchImagesResponse) obj;
        return hasFastLaunchImages() == other.hasFastLaunchImages()
                && Objects.equals(fastLaunchImages(), other.fastLaunchImages()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFastLaunchImagesResponse")
                .add("FastLaunchImages", hasFastLaunchImages() ? fastLaunchImages() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FastLaunchImages":
            return Optional.ofNullable(clazz.cast(fastLaunchImages()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FastLaunchImageSet", FAST_LAUNCH_IMAGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFastLaunchImagesResponse, T> g) {
        return obj -> g.apply((DescribeFastLaunchImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFastLaunchImagesResponse> {
        /**
         * <p>
         * A collection of details about the fast-launch enabled Windows images that meet the requested criteria.
         * </p>
         * 
         * @param fastLaunchImages
         *        A collection of details about the fast-launch enabled Windows images that meet the requested criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastLaunchImages(Collection<DescribeFastLaunchImagesSuccessItem> fastLaunchImages);

        /**
         * <p>
         * A collection of details about the fast-launch enabled Windows images that meet the requested criteria.
         * </p>
         * 
         * @param fastLaunchImages
         *        A collection of details about the fast-launch enabled Windows images that meet the requested criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastLaunchImages(DescribeFastLaunchImagesSuccessItem... fastLaunchImages);

        /**
         * <p>
         * A collection of details about the fast-launch enabled Windows images that meet the requested criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #fastLaunchImages(List<DescribeFastLaunchImagesSuccessItem>)}.
         * 
         * @param fastLaunchImages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fastLaunchImages(java.util.Collection<DescribeFastLaunchImagesSuccessItem>)
         */
        Builder fastLaunchImages(Consumer<DescribeFastLaunchImagesSuccessItem.Builder>... fastLaunchImages);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<DescribeFastLaunchImagesSuccessItem> fastLaunchImages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFastLaunchImagesResponse model) {
            super(model);
            fastLaunchImages(model.fastLaunchImages);
            nextToken(model.nextToken);
        }

        public final List<DescribeFastLaunchImagesSuccessItem.Builder> getFastLaunchImages() {
            List<DescribeFastLaunchImagesSuccessItem.Builder> result = DescribeFastLaunchImagesSuccessSetCopier
                    .copyToBuilder(this.fastLaunchImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFastLaunchImages(Collection<DescribeFastLaunchImagesSuccessItem.BuilderImpl> fastLaunchImages) {
            this.fastLaunchImages = DescribeFastLaunchImagesSuccessSetCopier.copyFromBuilder(fastLaunchImages);
        }

        @Override
        public final Builder fastLaunchImages(Collection<DescribeFastLaunchImagesSuccessItem> fastLaunchImages) {
            this.fastLaunchImages = DescribeFastLaunchImagesSuccessSetCopier.copy(fastLaunchImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchImages(DescribeFastLaunchImagesSuccessItem... fastLaunchImages) {
            fastLaunchImages(Arrays.asList(fastLaunchImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchImages(Consumer<DescribeFastLaunchImagesSuccessItem.Builder>... fastLaunchImages) {
            fastLaunchImages(Stream.of(fastLaunchImages)
                    .map(c -> DescribeFastLaunchImagesSuccessItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFastLaunchImagesResponse build() {
            return new DescribeFastLaunchImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
