/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommended Capacity Block extension that fits your search requirements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityBlockExtensionOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityBlockExtensionOffering.Builder, CapacityBlockExtensionOffering> {
    private static final SdkField<String> CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityBlockExtensionOfferingId")
            .getter(getter(CapacityBlockExtensionOffering::capacityBlockExtensionOfferingId))
            .setter(setter(Builder::capacityBlockExtensionOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionOfferingId")
                    .unmarshallLocationName("capacityBlockExtensionOfferingId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(CapacityBlockExtensionOffering::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(CapacityBlockExtensionOffering::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CapacityBlockExtensionOffering::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(CapacityBlockExtensionOffering::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate")
            .getter(getter(CapacityBlockExtensionOffering::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate")
                    .unmarshallLocationName("startDate").build()).build();

    private static final SdkField<Instant> CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CapacityBlockExtensionStartDate")
            .getter(getter(CapacityBlockExtensionOffering::capacityBlockExtensionStartDate))
            .setter(setter(Builder::capacityBlockExtensionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionStartDate")
                    .unmarshallLocationName("capacityBlockExtensionStartDate").build()).build();

    private static final SdkField<Instant> CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CapacityBlockExtensionEndDate")
            .getter(getter(CapacityBlockExtensionOffering::capacityBlockExtensionEndDate))
            .setter(setter(Builder::capacityBlockExtensionEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionEndDate")
                    .unmarshallLocationName("capacityBlockExtensionEndDate").build()).build();

    private static final SdkField<Integer> CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CapacityBlockExtensionDurationHours")
            .getter(getter(CapacityBlockExtensionOffering::capacityBlockExtensionDurationHours))
            .setter(setter(Builder::capacityBlockExtensionDurationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CapacityBlockExtensionDurationHours")
                    .unmarshallLocationName("capacityBlockExtensionDurationHours").build()).build();

    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UpfrontFee")
            .getter(getter(CapacityBlockExtensionOffering::upfrontFee))
            .setter(setter(Builder::upfrontFee))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee")
                    .unmarshallLocationName("upfrontFee").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(CapacityBlockExtensionOffering::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Tenancy")
            .getter(getter(CapacityBlockExtensionOffering::tenancyAsString))
            .setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy")
                    .unmarshallLocationName("tenancy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, START_DATE_FIELD, CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD,
            CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD, CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD, UPFRONT_FEE_FIELD,
            CURRENCY_CODE_FIELD, TENANCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityBlockExtensionOfferingId;

    private final String instanceType;

    private final Integer instanceCount;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Instant startDate;

    private final Instant capacityBlockExtensionStartDate;

    private final Instant capacityBlockExtensionEndDate;

    private final Integer capacityBlockExtensionDurationHours;

    private final String upfrontFee;

    private final String currencyCode;

    private final String tenancy;

    private CapacityBlockExtensionOffering(BuilderImpl builder) {
        this.capacityBlockExtensionOfferingId = builder.capacityBlockExtensionOfferingId;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.startDate = builder.startDate;
        this.capacityBlockExtensionStartDate = builder.capacityBlockExtensionStartDate;
        this.capacityBlockExtensionEndDate = builder.capacityBlockExtensionEndDate;
        this.capacityBlockExtensionDurationHours = builder.capacityBlockExtensionDurationHours;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * The ID of the Capacity Block extension offering.
     * </p>
     * 
     * @return The ID of the Capacity Block extension offering.
     */
    public final String capacityBlockExtensionOfferingId() {
        return capacityBlockExtensionOfferingId;
    }

    /**
     * <p>
     * The instance type of the Capacity Block that will be extended.
     * </p>
     * 
     * @return The instance type of the Capacity Block that will be extended.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances in the Capacity Block extension offering.
     * </p>
     * 
     * @return The number of instances in the Capacity Block extension offering.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The Availability Zone of the Capacity Block that will be extended.
     * </p>
     * 
     * @return The Availability Zone of the Capacity Block that will be extended.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Availability Zone ID of the Capacity Block that will be extended.
     * </p>
     * 
     * @return The Availability Zone ID of the Capacity Block that will be extended.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The start date of the Capacity Block that will be extended.
     * </p>
     * 
     * @return The start date of the Capacity Block that will be extended.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date and time at which the Capacity Block extension will start. This date is also the same as the end date of
     * the Capacity Block that will be extended.
     * </p>
     * 
     * @return The date and time at which the Capacity Block extension will start. This date is also the same as the end
     *         date of the Capacity Block that will be extended.
     */
    public final Instant capacityBlockExtensionStartDate() {
        return capacityBlockExtensionStartDate;
    }

    /**
     * <p>
     * The date and time at which the Capacity Block extension expires. When a Capacity Block expires, the reserved
     * capacity is released and you can no longer launch instances into it. The Capacity Block's state changes to
     * <code>expired</code> when it reaches its end date
     * </p>
     * 
     * @return The date and time at which the Capacity Block extension expires. When a Capacity Block expires, the
     *         reserved capacity is released and you can no longer launch instances into it. The Capacity Block's state
     *         changes to <code>expired</code> when it reaches its end date
     */
    public final Instant capacityBlockExtensionEndDate() {
        return capacityBlockExtensionEndDate;
    }

    /**
     * <p>
     * The amount of time of the Capacity Block extension offering in hours.
     * </p>
     * 
     * @return The amount of time of the Capacity Block extension offering in hours.
     */
    public final Integer capacityBlockExtensionDurationHours() {
        return capacityBlockExtensionDurationHours;
    }

    /**
     * <p>
     * The total price of the Capacity Block extension offering, to be paid up front.
     * </p>
     * 
     * @return The total price of the Capacity Block extension offering, to be paid up front.
     */
    public final String upfrontFee() {
        return upfrontFee;
    }

    /**
     * <p>
     * The currency of the payment for the Capacity Block extension offering.
     * </p>
     * 
     * @return The currency of the payment for the Capacity Block extension offering.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the following
     * tenancy settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web Services
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to a single
     * Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the
     *         following tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web
     *         Services accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to a
     *         single Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public final CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the following
     * tenancy settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web Services
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to a single
     * Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the
     *         following tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web
     *         Services accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to a
     *         single Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityBlockExtensionOffering)) {
            return false;
        }
        CapacityBlockExtensionOffering other = (CapacityBlockExtensionOffering) obj;
        return Objects.equals(capacityBlockExtensionOfferingId(), other.capacityBlockExtensionOfferingId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(startDate(), other.startDate())
                && Objects.equals(capacityBlockExtensionStartDate(), other.capacityBlockExtensionStartDate())
                && Objects.equals(capacityBlockExtensionEndDate(), other.capacityBlockExtensionEndDate())
                && Objects.equals(capacityBlockExtensionDurationHours(), other.capacityBlockExtensionDurationHours())
                && Objects.equals(upfrontFee(), other.upfrontFee()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(tenancyAsString(), other.tenancyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityBlockExtensionOffering")
                .add("CapacityBlockExtensionOfferingId", capacityBlockExtensionOfferingId()).add("InstanceType", instanceType())
                .add("InstanceCount", instanceCount()).add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("StartDate", startDate())
                .add("CapacityBlockExtensionStartDate", capacityBlockExtensionStartDate())
                .add("CapacityBlockExtensionEndDate", capacityBlockExtensionEndDate())
                .add("CapacityBlockExtensionDurationHours", capacityBlockExtensionDurationHours())
                .add("UpfrontFee", upfrontFee()).add("CurrencyCode", currencyCode()).add("Tenancy", tenancyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityBlockExtensionOfferingId":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionOfferingId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "CapacityBlockExtensionStartDate":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionStartDate()));
        case "CapacityBlockExtensionEndDate":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionEndDate()));
        case "CapacityBlockExtensionDurationHours":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionDurationHours()));
        case "UpfrontFee":
            return Optional.ofNullable(clazz.cast(upfrontFee()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityBlockExtensionOfferingId", CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("CapacityBlockExtensionStartDate", CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD);
        map.put("CapacityBlockExtensionEndDate", CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD);
        map.put("CapacityBlockExtensionDurationHours", CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD);
        map.put("UpfrontFee", UPFRONT_FEE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityBlockExtensionOffering, T> g) {
        return obj -> g.apply((CapacityBlockExtensionOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityBlockExtensionOffering> {
        /**
         * <p>
         * The ID of the Capacity Block extension offering.
         * </p>
         * 
         * @param capacityBlockExtensionOfferingId
         *        The ID of the Capacity Block extension offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId);

        /**
         * <p>
         * The instance type of the Capacity Block that will be extended.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the Capacity Block that will be extended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of instances in the Capacity Block extension offering.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances in the Capacity Block extension offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The Availability Zone of the Capacity Block that will be extended.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the Capacity Block that will be extended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Availability Zone ID of the Capacity Block that will be extended.
         * </p>
         * 
         * @param availabilityZoneId
         *        The Availability Zone ID of the Capacity Block that will be extended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The start date of the Capacity Block that will be extended.
         * </p>
         * 
         * @param startDate
         *        The start date of the Capacity Block that will be extended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date and time at which the Capacity Block extension will start. This date is also the same as the end
         * date of the Capacity Block that will be extended.
         * </p>
         * 
         * @param capacityBlockExtensionStartDate
         *        The date and time at which the Capacity Block extension will start. This date is also the same as the
         *        end date of the Capacity Block that will be extended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate);

        /**
         * <p>
         * The date and time at which the Capacity Block extension expires. When a Capacity Block expires, the reserved
         * capacity is released and you can no longer launch instances into it. The Capacity Block's state changes to
         * <code>expired</code> when it reaches its end date
         * </p>
         * 
         * @param capacityBlockExtensionEndDate
         *        The date and time at which the Capacity Block extension expires. When a Capacity Block expires, the
         *        reserved capacity is released and you can no longer launch instances into it. The Capacity Block's
         *        state changes to <code>expired</code> when it reaches its end date
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate);

        /**
         * <p>
         * The amount of time of the Capacity Block extension offering in hours.
         * </p>
         * 
         * @param capacityBlockExtensionDurationHours
         *        The amount of time of the Capacity Block extension offering in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours);

        /**
         * <p>
         * The total price of the Capacity Block extension offering, to be paid up front.
         * </p>
         * 
         * @param upfrontFee
         *        The total price of the Capacity Block extension offering, to be paid up front.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontFee(String upfrontFee);

        /**
         * <p>
         * The currency of the payment for the Capacity Block extension offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the payment for the Capacity Block extension offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the
         * following tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web
         *        Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to
         *        a single Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the
         * following tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Block extension offering. A Capacity Block can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Block is created on hardware that is shared with other Amazon Web
         *        Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Block is created on single-tenant hardware that is dedicated to
         *        a single Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(CapacityReservationTenancy tenancy);
    }

    static final class BuilderImpl implements Builder {
        private String capacityBlockExtensionOfferingId;

        private String instanceType;

        private Integer instanceCount;

        private String availabilityZone;

        private String availabilityZoneId;

        private Instant startDate;

        private Instant capacityBlockExtensionStartDate;

        private Instant capacityBlockExtensionEndDate;

        private Integer capacityBlockExtensionDurationHours;

        private String upfrontFee;

        private String currencyCode;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityBlockExtensionOffering model) {
            capacityBlockExtensionOfferingId(model.capacityBlockExtensionOfferingId);
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            startDate(model.startDate);
            capacityBlockExtensionStartDate(model.capacityBlockExtensionStartDate);
            capacityBlockExtensionEndDate(model.capacityBlockExtensionEndDate);
            capacityBlockExtensionDurationHours(model.capacityBlockExtensionDurationHours);
            upfrontFee(model.upfrontFee);
            currencyCode(model.currencyCode);
            tenancy(model.tenancy);
        }

        public final String getCapacityBlockExtensionOfferingId() {
            return capacityBlockExtensionOfferingId;
        }

        public final void setCapacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
        }

        @Override
        public final Builder capacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getCapacityBlockExtensionStartDate() {
            return capacityBlockExtensionStartDate;
        }

        public final void setCapacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate) {
            this.capacityBlockExtensionStartDate = capacityBlockExtensionStartDate;
        }

        @Override
        public final Builder capacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate) {
            this.capacityBlockExtensionStartDate = capacityBlockExtensionStartDate;
            return this;
        }

        public final Instant getCapacityBlockExtensionEndDate() {
            return capacityBlockExtensionEndDate;
        }

        public final void setCapacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate) {
            this.capacityBlockExtensionEndDate = capacityBlockExtensionEndDate;
        }

        @Override
        public final Builder capacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate) {
            this.capacityBlockExtensionEndDate = capacityBlockExtensionEndDate;
            return this;
        }

        public final Integer getCapacityBlockExtensionDurationHours() {
            return capacityBlockExtensionDurationHours;
        }

        public final void setCapacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
        }

        @Override
        public final Builder capacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
            return this;
        }

        public final String getUpfrontFee() {
            return upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        @Override
        public CapacityBlockExtensionOffering build() {
            return new CapacityBlockExtensionOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
