/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup;

public class SearchTransitGatewayMulticastGroupsIterable
implements SdkIterable<SearchTransitGatewayMulticastGroupsResponse> {
    private final Ec2Client client;
    private final SearchTransitGatewayMulticastGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchTransitGatewayMulticastGroupsIterable(Ec2Client client, SearchTransitGatewayMulticastGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchTransitGatewayMulticastGroupsResponseFetcher();
    }

    public Iterator<SearchTransitGatewayMulticastGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayMulticastGroup> multicastGroups() {
        Function<SearchTransitGatewayMulticastGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.multicastGroups() != null) {
                return response.multicastGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchTransitGatewayMulticastGroupsResponseFetcher
    implements SyncPageFetcher<SearchTransitGatewayMulticastGroupsResponse> {
        private SearchTransitGatewayMulticastGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchTransitGatewayMulticastGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchTransitGatewayMulticastGroupsResponse nextPage(SearchTransitGatewayMulticastGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchTransitGatewayMulticastGroupsIterable.this.client.searchTransitGatewayMulticastGroups(SearchTransitGatewayMulticastGroupsIterable.this.firstRequest);
            }
            return SearchTransitGatewayMulticastGroupsIterable.this.client.searchTransitGatewayMulticastGroups((SearchTransitGatewayMulticastGroupsRequest)((Object)SearchTransitGatewayMulticastGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

