/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VerificationMethod {
    REMARKS_X509("remarks-x509"),
    DNS_TOKEN("dns-token"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VerificationMethod> VALUE_MAP;
    private final String value;

    private VerificationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerificationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerificationMethod> knownValues() {
        EnumSet<VerificationMethod> knownValues = EnumSet.allOf(VerificationMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VerificationMethod.class, VerificationMethod::toString);
    }
}

