/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsResponse;

public class DescribeCapacityReservationBillingRequestsIterable
implements SdkIterable<DescribeCapacityReservationBillingRequestsResponse> {
    private final Ec2Client client;
    private final DescribeCapacityReservationBillingRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityReservationBillingRequestsIterable(Ec2Client client, DescribeCapacityReservationBillingRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityReservationBillingRequestsResponseFetcher();
    }

    public Iterator<DescribeCapacityReservationBillingRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityReservationBillingRequest> capacityReservationBillingRequests() {
        Function<DescribeCapacityReservationBillingRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityReservationBillingRequests() != null) {
                return response.capacityReservationBillingRequests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityReservationBillingRequestsResponseFetcher
    implements SyncPageFetcher<DescribeCapacityReservationBillingRequestsResponse> {
        private DescribeCapacityReservationBillingRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityReservationBillingRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityReservationBillingRequestsResponse nextPage(DescribeCapacityReservationBillingRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityReservationBillingRequestsIterable.this.client.describeCapacityReservationBillingRequests(DescribeCapacityReservationBillingRequestsIterable.this.firstRequest);
            }
            return DescribeCapacityReservationBillingRequestsIterable.this.client.describeCapacityReservationBillingRequests((DescribeCapacityReservationBillingRequestsRequest)((Object)DescribeCapacityReservationBillingRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

