/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressTag;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPublicAddressTags
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPublicAddressTags> {
    private static final SdkField<List<IpamPublicAddressTag>> EIP_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EipTags").getter(IpamPublicAddressTags.getter(IpamPublicAddressTags::eipTags)).setter(IpamPublicAddressTags.setter(Builder::eipTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EipTagSet").unmarshallLocationName("eipTagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPublicAddressTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EIP_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPublicAddressTags.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<IpamPublicAddressTag> eipTags;

    private IpamPublicAddressTags(BuilderImpl builder) {
        this.eipTags = builder.eipTags;
    }

    public final boolean hasEipTags() {
        return this.eipTags != null && !(this.eipTags instanceof SdkAutoConstructList);
    }

    public final List<IpamPublicAddressTag> eipTags() {
        return this.eipTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEipTags() ? this.eipTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPublicAddressTags)) {
            return false;
        }
        IpamPublicAddressTags other = (IpamPublicAddressTags)obj;
        return this.hasEipTags() == other.hasEipTags() && Objects.equals(this.eipTags(), other.eipTags());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPublicAddressTags").add("EipTags", this.hasEipTags() ? this.eipTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EipTags": {
                return Optional.ofNullable(clazz.cast(this.eipTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<IpamPublicAddressTag>>> map = new HashMap<String, SdkField<List<IpamPublicAddressTag>>>();
        map.put("EipTagSet", EIP_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPublicAddressTags, T> g) {
        return obj -> g.apply((IpamPublicAddressTags)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IpamPublicAddressTag> eipTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPublicAddressTags model) {
            this.eipTags(model.eipTags);
        }

        public final List<IpamPublicAddressTag.Builder> getEipTags() {
            List<IpamPublicAddressTag.Builder> result = IpamPublicAddressTagListCopier.copyToBuilder(this.eipTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEipTags(Collection<IpamPublicAddressTag.BuilderImpl> eipTags) {
            this.eipTags = IpamPublicAddressTagListCopier.copyFromBuilder(eipTags);
        }

        @Override
        public final Builder eipTags(Collection<IpamPublicAddressTag> eipTags) {
            this.eipTags = IpamPublicAddressTagListCopier.copy(eipTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eipTags(IpamPublicAddressTag ... eipTags) {
            this.eipTags(Arrays.asList(eipTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eipTags(Consumer<IpamPublicAddressTag.Builder> ... eipTags) {
            this.eipTags(Stream.of(eipTags).map(c -> (IpamPublicAddressTag)((IpamPublicAddressTag.Builder)IpamPublicAddressTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamPublicAddressTags build() {
            return new IpamPublicAddressTags(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPublicAddressTags> {
        public Builder eipTags(Collection<IpamPublicAddressTag> var1);

        public Builder eipTags(IpamPublicAddressTag ... var1);

        public Builder eipTags(Consumer<IpamPublicAddressTag.Builder> ... var1);
    }
}

