/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateFleetError;
import software.amazon.awssdk.services.ec2.model.CreateFleetErrorsSetCopier;
import software.amazon.awssdk.services.ec2.model.CreateFleetInstance;
import software.amazon.awssdk.services.ec2.model.CreateFleetInstancesSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateFleetResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(CreateFleetResponse.getter(CreateFleetResponse::fleetId)).setter(CreateFleetResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").unmarshallLocationName("fleetId").build()}).build();
    private static final SdkField<List<CreateFleetError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(CreateFleetResponse.getter(CreateFleetResponse::errors)).setter(CreateFleetResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorSet").unmarshallLocationName("errorSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateFleetError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<CreateFleetInstance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(CreateFleetResponse.getter(CreateFleetResponse::instances)).setter(CreateFleetResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetInstanceSet").unmarshallLocationName("fleetInstanceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateFleetInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ERRORS_FIELD, INSTANCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFleetResponse.memberNameToFieldInitializer();
    private final String fleetId;
    private final List<CreateFleetError> errors;
    private final List<CreateFleetInstance> instances;

    private CreateFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.errors = builder.errors;
        this.instances = builder.instances;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<CreateFleetError> errors() {
        return this.errors;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<CreateFleetInstance> instances() {
        return this.instances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetResponse)) {
            return false;
        }
        CreateFleetResponse other = (CreateFleetResponse)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFleetResponse").add("FleetId", (Object)this.fleetId()).add("Errors", this.hasErrors() ? this.errors() : null).add("Instances", this.hasInstances() ? this.instances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("ErrorSet", ERRORS_FIELD);
        map.put("FleetInstanceSet", INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetResponse, T> g) {
        return obj -> g.apply((CreateFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String fleetId;
        private List<CreateFleetError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<CreateFleetInstance> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetResponse model) {
            super(model);
            this.fleetId(model.fleetId);
            this.errors(model.errors);
            this.instances(model.instances);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final List<CreateFleetError.Builder> getErrors() {
            List<CreateFleetError.Builder> result = CreateFleetErrorsSetCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CreateFleetError.BuilderImpl> errors) {
            this.errors = CreateFleetErrorsSetCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CreateFleetError> errors) {
            this.errors = CreateFleetErrorsSetCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CreateFleetError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CreateFleetError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (CreateFleetError)((CreateFleetError.Builder)CreateFleetError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CreateFleetInstance.Builder> getInstances() {
            List<CreateFleetInstance.Builder> result = CreateFleetInstancesSetCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<CreateFleetInstance.BuilderImpl> instances) {
            this.instances = CreateFleetInstancesSetCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<CreateFleetInstance> instances) {
            this.instances = CreateFleetInstancesSetCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(CreateFleetInstance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<CreateFleetInstance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (CreateFleetInstance)((CreateFleetInstance.Builder)CreateFleetInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateFleetResponse build() {
            return new CreateFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFleetResponse> {
        public Builder fleetId(String var1);

        public Builder errors(Collection<CreateFleetError> var1);

        public Builder errors(CreateFleetError ... var1);

        public Builder errors(Consumer<CreateFleetError.Builder> ... var1);

        public Builder instances(Collection<CreateFleetInstance> var1);

        public Builder instances(CreateFleetInstance ... var1);

        public Builder instances(Consumer<CreateFleetInstance.Builder> ... var1);
    }
}

