/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IKEVersionsRequestListCopier;
import software.amazon.awssdk.services.ec2.model.IKEVersionsRequestListValue;
import software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersRequestListCopier;
import software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersRequestListValue;
import software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsRequestListCopier;
import software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue;
import software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsRequestListCopier;
import software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue;
import software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersRequestListCopier;
import software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersRequestListValue;
import software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsRequestListCopier;
import software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue;
import software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsRequestListCopier;
import software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue;
import software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptionsSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnTunnelOptionsSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnTunnelOptionsSpecification> {
    private static final SdkField<String> TUNNEL_INSIDE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelInsideCidr").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::tunnelInsideCidr)).setter(VpnTunnelOptionsSpecification.setter(Builder::tunnelInsideCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideCidr").unmarshallLocationName("TunnelInsideCidr").build()}).build();
    private static final SdkField<String> TUNNEL_INSIDE_IPV6_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelInsideIpv6Cidr").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::tunnelInsideIpv6Cidr)).setter(VpnTunnelOptionsSpecification.setter(Builder::tunnelInsideIpv6Cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpv6Cidr").unmarshallLocationName("TunnelInsideIpv6Cidr").build()}).build();
    private static final SdkField<String> PRE_SHARED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSharedKey").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::preSharedKey)).setter(VpnTunnelOptionsSpecification.setter(Builder::preSharedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSharedKey").unmarshallLocationName("PreSharedKey").build()}).build();
    private static final SdkField<Integer> PHASE1_LIFETIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase1LifetimeSeconds").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase1LifetimeSeconds)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase1LifetimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1LifetimeSeconds").unmarshallLocationName("Phase1LifetimeSeconds").build()}).build();
    private static final SdkField<Integer> PHASE2_LIFETIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase2LifetimeSeconds").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase2LifetimeSeconds)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase2LifetimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2LifetimeSeconds").unmarshallLocationName("Phase2LifetimeSeconds").build()}).build();
    private static final SdkField<Integer> REKEY_MARGIN_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RekeyMarginTimeSeconds").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::rekeyMarginTimeSeconds)).setter(VpnTunnelOptionsSpecification.setter(Builder::rekeyMarginTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyMarginTimeSeconds").unmarshallLocationName("RekeyMarginTimeSeconds").build()}).build();
    private static final SdkField<Integer> REKEY_FUZZ_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RekeyFuzzPercentage").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::rekeyFuzzPercentage)).setter(VpnTunnelOptionsSpecification.setter(Builder::rekeyFuzzPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyFuzzPercentage").unmarshallLocationName("RekeyFuzzPercentage").build()}).build();
    private static final SdkField<Integer> REPLAY_WINDOW_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplayWindowSize").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::replayWindowSize)).setter(VpnTunnelOptionsSpecification.setter(Builder::replayWindowSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayWindowSize").unmarshallLocationName("ReplayWindowSize").build()}).build();
    private static final SdkField<Integer> DPD_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DPDTimeoutSeconds").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::dpdTimeoutSeconds)).setter(VpnTunnelOptionsSpecification.setter(Builder::dpdTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPDTimeoutSeconds").unmarshallLocationName("DPDTimeoutSeconds").build()}).build();
    private static final SdkField<String> DPD_TIMEOUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DPDTimeoutAction").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::dpdTimeoutAction)).setter(VpnTunnelOptionsSpecification.setter(Builder::dpdTimeoutAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPDTimeoutAction").unmarshallLocationName("DPDTimeoutAction").build()}).build();
    private static final SdkField<List<Phase1EncryptionAlgorithmsRequestListValue>> PHASE1_ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1EncryptionAlgorithms").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase1EncryptionAlgorithms)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase1EncryptionAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithm").unmarshallLocationName("Phase1EncryptionAlgorithm").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase1EncryptionAlgorithmsRequestListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase2EncryptionAlgorithmsRequestListValue>> PHASE2_ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2EncryptionAlgorithms").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase2EncryptionAlgorithms)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase2EncryptionAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithm").unmarshallLocationName("Phase2EncryptionAlgorithm").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase2EncryptionAlgorithmsRequestListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase1IntegrityAlgorithmsRequestListValue>> PHASE1_INTEGRITY_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1IntegrityAlgorithms").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase1IntegrityAlgorithms)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase1IntegrityAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithm").unmarshallLocationName("Phase1IntegrityAlgorithm").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase1IntegrityAlgorithmsRequestListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase2IntegrityAlgorithmsRequestListValue>> PHASE2_INTEGRITY_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2IntegrityAlgorithms").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase2IntegrityAlgorithms)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase2IntegrityAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithm").unmarshallLocationName("Phase2IntegrityAlgorithm").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase2IntegrityAlgorithmsRequestListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase1DHGroupNumbersRequestListValue>> PHASE1_DH_GROUP_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1DHGroupNumbers").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase1DHGroupNumbers)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase1DHGroupNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DHGroupNumber").unmarshallLocationName("Phase1DHGroupNumber").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase1DHGroupNumbersRequestListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase2DHGroupNumbersRequestListValue>> PHASE2_DH_GROUP_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2DHGroupNumbers").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::phase2DHGroupNumbers)).setter(VpnTunnelOptionsSpecification.setter(Builder::phase2DHGroupNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DHGroupNumber").unmarshallLocationName("Phase2DHGroupNumber").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase2DHGroupNumbersRequestListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<IKEVersionsRequestListValue>> IKE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IKEVersions").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::ikeVersions)).setter(VpnTunnelOptionsSpecification.setter(Builder::ikeVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IKEVersion").unmarshallLocationName("IKEVersion").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IKEVersionsRequestListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STARTUP_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupAction").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::startupAction)).setter(VpnTunnelOptionsSpecification.setter(Builder::startupAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupAction").unmarshallLocationName("StartupAction").build()}).build();
    private static final SdkField<VpnTunnelLogOptionsSpecification> LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogOptions").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::logOptions)).setter(VpnTunnelOptionsSpecification.setter(Builder::logOptions)).constructor(VpnTunnelLogOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogOptions").unmarshallLocationName("LogOptions").build()}).build();
    private static final SdkField<Boolean> ENABLE_TUNNEL_LIFECYCLE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableTunnelLifecycleControl").getter(VpnTunnelOptionsSpecification.getter(VpnTunnelOptionsSpecification::enableTunnelLifecycleControl)).setter(VpnTunnelOptionsSpecification.setter(Builder::enableTunnelLifecycleControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTunnelLifecycleControl").unmarshallLocationName("EnableTunnelLifecycleControl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_INSIDE_CIDR_FIELD, TUNNEL_INSIDE_IPV6_CIDR_FIELD, PRE_SHARED_KEY_FIELD, PHASE1_LIFETIME_SECONDS_FIELD, PHASE2_LIFETIME_SECONDS_FIELD, REKEY_MARGIN_TIME_SECONDS_FIELD, REKEY_FUZZ_PERCENTAGE_FIELD, REPLAY_WINDOW_SIZE_FIELD, DPD_TIMEOUT_SECONDS_FIELD, DPD_TIMEOUT_ACTION_FIELD, PHASE1_ENCRYPTION_ALGORITHMS_FIELD, PHASE2_ENCRYPTION_ALGORITHMS_FIELD, PHASE1_INTEGRITY_ALGORITHMS_FIELD, PHASE2_INTEGRITY_ALGORITHMS_FIELD, PHASE1_DH_GROUP_NUMBERS_FIELD, PHASE2_DH_GROUP_NUMBERS_FIELD, IKE_VERSIONS_FIELD, STARTUP_ACTION_FIELD, LOG_OPTIONS_FIELD, ENABLE_TUNNEL_LIFECYCLE_CONTROL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpnTunnelOptionsSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tunnelInsideCidr;
    private final String tunnelInsideIpv6Cidr;
    private final String preSharedKey;
    private final Integer phase1LifetimeSeconds;
    private final Integer phase2LifetimeSeconds;
    private final Integer rekeyMarginTimeSeconds;
    private final Integer rekeyFuzzPercentage;
    private final Integer replayWindowSize;
    private final Integer dpdTimeoutSeconds;
    private final String dpdTimeoutAction;
    private final List<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms;
    private final List<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms;
    private final List<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms;
    private final List<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms;
    private final List<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers;
    private final List<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers;
    private final List<IKEVersionsRequestListValue> ikeVersions;
    private final String startupAction;
    private final VpnTunnelLogOptionsSpecification logOptions;
    private final Boolean enableTunnelLifecycleControl;

    private VpnTunnelOptionsSpecification(BuilderImpl builder) {
        this.tunnelInsideCidr = builder.tunnelInsideCidr;
        this.tunnelInsideIpv6Cidr = builder.tunnelInsideIpv6Cidr;
        this.preSharedKey = builder.preSharedKey;
        this.phase1LifetimeSeconds = builder.phase1LifetimeSeconds;
        this.phase2LifetimeSeconds = builder.phase2LifetimeSeconds;
        this.rekeyMarginTimeSeconds = builder.rekeyMarginTimeSeconds;
        this.rekeyFuzzPercentage = builder.rekeyFuzzPercentage;
        this.replayWindowSize = builder.replayWindowSize;
        this.dpdTimeoutSeconds = builder.dpdTimeoutSeconds;
        this.dpdTimeoutAction = builder.dpdTimeoutAction;
        this.phase1EncryptionAlgorithms = builder.phase1EncryptionAlgorithms;
        this.phase2EncryptionAlgorithms = builder.phase2EncryptionAlgorithms;
        this.phase1IntegrityAlgorithms = builder.phase1IntegrityAlgorithms;
        this.phase2IntegrityAlgorithms = builder.phase2IntegrityAlgorithms;
        this.phase1DHGroupNumbers = builder.phase1DHGroupNumbers;
        this.phase2DHGroupNumbers = builder.phase2DHGroupNumbers;
        this.ikeVersions = builder.ikeVersions;
        this.startupAction = builder.startupAction;
        this.logOptions = builder.logOptions;
        this.enableTunnelLifecycleControl = builder.enableTunnelLifecycleControl;
    }

    public final String tunnelInsideCidr() {
        return this.tunnelInsideCidr;
    }

    public final String tunnelInsideIpv6Cidr() {
        return this.tunnelInsideIpv6Cidr;
    }

    public final String preSharedKey() {
        return this.preSharedKey;
    }

    public final Integer phase1LifetimeSeconds() {
        return this.phase1LifetimeSeconds;
    }

    public final Integer phase2LifetimeSeconds() {
        return this.phase2LifetimeSeconds;
    }

    public final Integer rekeyMarginTimeSeconds() {
        return this.rekeyMarginTimeSeconds;
    }

    public final Integer rekeyFuzzPercentage() {
        return this.rekeyFuzzPercentage;
    }

    public final Integer replayWindowSize() {
        return this.replayWindowSize;
    }

    public final Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    public final String dpdTimeoutAction() {
        return this.dpdTimeoutAction;
    }

    public final boolean hasPhase1EncryptionAlgorithms() {
        return this.phase1EncryptionAlgorithms != null && !(this.phase1EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms() {
        return this.phase1EncryptionAlgorithms;
    }

    public final boolean hasPhase2EncryptionAlgorithms() {
        return this.phase2EncryptionAlgorithms != null && !(this.phase2EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms() {
        return this.phase2EncryptionAlgorithms;
    }

    public final boolean hasPhase1IntegrityAlgorithms() {
        return this.phase1IntegrityAlgorithms != null && !(this.phase1IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms() {
        return this.phase1IntegrityAlgorithms;
    }

    public final boolean hasPhase2IntegrityAlgorithms() {
        return this.phase2IntegrityAlgorithms != null && !(this.phase2IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms() {
        return this.phase2IntegrityAlgorithms;
    }

    public final boolean hasPhase1DHGroupNumbers() {
        return this.phase1DHGroupNumbers != null && !(this.phase1DHGroupNumbers instanceof SdkAutoConstructList);
    }

    public final List<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers() {
        return this.phase1DHGroupNumbers;
    }

    public final boolean hasPhase2DHGroupNumbers() {
        return this.phase2DHGroupNumbers != null && !(this.phase2DHGroupNumbers instanceof SdkAutoConstructList);
    }

    public final List<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers() {
        return this.phase2DHGroupNumbers;
    }

    public final boolean hasIkeVersions() {
        return this.ikeVersions != null && !(this.ikeVersions instanceof SdkAutoConstructList);
    }

    public final List<IKEVersionsRequestListValue> ikeVersions() {
        return this.ikeVersions;
    }

    public final String startupAction() {
        return this.startupAction;
    }

    public final VpnTunnelLogOptionsSpecification logOptions() {
        return this.logOptions;
    }

    public final Boolean enableTunnelLifecycleControl() {
        return this.enableTunnelLifecycleControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelInsideCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelInsideIpv6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSharedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase1LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase2LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rekeyMarginTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rekeyFuzzPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayWindowSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpdTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpdTimeoutAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1EncryptionAlgorithms() ? this.phase1EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2EncryptionAlgorithms() ? this.phase2EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1IntegrityAlgorithms() ? this.phase1IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2IntegrityAlgorithms() ? this.phase2IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1DHGroupNumbers() ? this.phase1DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2DHGroupNumbers() ? this.phase2DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIkeVersions() ? this.ikeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startupAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.logOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTunnelLifecycleControl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnTunnelOptionsSpecification)) {
            return false;
        }
        VpnTunnelOptionsSpecification other = (VpnTunnelOptionsSpecification)obj;
        return Objects.equals(this.tunnelInsideCidr(), other.tunnelInsideCidr()) && Objects.equals(this.tunnelInsideIpv6Cidr(), other.tunnelInsideIpv6Cidr()) && Objects.equals(this.preSharedKey(), other.preSharedKey()) && Objects.equals(this.phase1LifetimeSeconds(), other.phase1LifetimeSeconds()) && Objects.equals(this.phase2LifetimeSeconds(), other.phase2LifetimeSeconds()) && Objects.equals(this.rekeyMarginTimeSeconds(), other.rekeyMarginTimeSeconds()) && Objects.equals(this.rekeyFuzzPercentage(), other.rekeyFuzzPercentage()) && Objects.equals(this.replayWindowSize(), other.replayWindowSize()) && Objects.equals(this.dpdTimeoutSeconds(), other.dpdTimeoutSeconds()) && Objects.equals(this.dpdTimeoutAction(), other.dpdTimeoutAction()) && this.hasPhase1EncryptionAlgorithms() == other.hasPhase1EncryptionAlgorithms() && Objects.equals(this.phase1EncryptionAlgorithms(), other.phase1EncryptionAlgorithms()) && this.hasPhase2EncryptionAlgorithms() == other.hasPhase2EncryptionAlgorithms() && Objects.equals(this.phase2EncryptionAlgorithms(), other.phase2EncryptionAlgorithms()) && this.hasPhase1IntegrityAlgorithms() == other.hasPhase1IntegrityAlgorithms() && Objects.equals(this.phase1IntegrityAlgorithms(), other.phase1IntegrityAlgorithms()) && this.hasPhase2IntegrityAlgorithms() == other.hasPhase2IntegrityAlgorithms() && Objects.equals(this.phase2IntegrityAlgorithms(), other.phase2IntegrityAlgorithms()) && this.hasPhase1DHGroupNumbers() == other.hasPhase1DHGroupNumbers() && Objects.equals(this.phase1DHGroupNumbers(), other.phase1DHGroupNumbers()) && this.hasPhase2DHGroupNumbers() == other.hasPhase2DHGroupNumbers() && Objects.equals(this.phase2DHGroupNumbers(), other.phase2DHGroupNumbers()) && this.hasIkeVersions() == other.hasIkeVersions() && Objects.equals(this.ikeVersions(), other.ikeVersions()) && Objects.equals(this.startupAction(), other.startupAction()) && Objects.equals(this.logOptions(), other.logOptions()) && Objects.equals(this.enableTunnelLifecycleControl(), other.enableTunnelLifecycleControl());
    }

    public final String toString() {
        return ToString.builder((String)"VpnTunnelOptionsSpecification").add("TunnelInsideCidr", (Object)this.tunnelInsideCidr()).add("TunnelInsideIpv6Cidr", (Object)this.tunnelInsideIpv6Cidr()).add("PreSharedKey", (Object)(this.preSharedKey() == null ? null : "*** Sensitive Data Redacted ***")).add("Phase1LifetimeSeconds", (Object)this.phase1LifetimeSeconds()).add("Phase2LifetimeSeconds", (Object)this.phase2LifetimeSeconds()).add("RekeyMarginTimeSeconds", (Object)this.rekeyMarginTimeSeconds()).add("RekeyFuzzPercentage", (Object)this.rekeyFuzzPercentage()).add("ReplayWindowSize", (Object)this.replayWindowSize()).add("DPDTimeoutSeconds", (Object)this.dpdTimeoutSeconds()).add("DPDTimeoutAction", (Object)this.dpdTimeoutAction()).add("Phase1EncryptionAlgorithms", this.hasPhase1EncryptionAlgorithms() ? this.phase1EncryptionAlgorithms() : null).add("Phase2EncryptionAlgorithms", this.hasPhase2EncryptionAlgorithms() ? this.phase2EncryptionAlgorithms() : null).add("Phase1IntegrityAlgorithms", this.hasPhase1IntegrityAlgorithms() ? this.phase1IntegrityAlgorithms() : null).add("Phase2IntegrityAlgorithms", this.hasPhase2IntegrityAlgorithms() ? this.phase2IntegrityAlgorithms() : null).add("Phase1DHGroupNumbers", this.hasPhase1DHGroupNumbers() ? this.phase1DHGroupNumbers() : null).add("Phase2DHGroupNumbers", this.hasPhase2DHGroupNumbers() ? this.phase2DHGroupNumbers() : null).add("IKEVersions", this.hasIkeVersions() ? this.ikeVersions() : null).add("StartupAction", (Object)this.startupAction()).add("LogOptions", (Object)this.logOptions()).add("EnableTunnelLifecycleControl", (Object)this.enableTunnelLifecycleControl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TunnelInsideCidr": {
                return Optional.ofNullable(clazz.cast(this.tunnelInsideCidr()));
            }
            case "TunnelInsideIpv6Cidr": {
                return Optional.ofNullable(clazz.cast(this.tunnelInsideIpv6Cidr()));
            }
            case "PreSharedKey": {
                return Optional.ofNullable(clazz.cast(this.preSharedKey()));
            }
            case "Phase1LifetimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.phase1LifetimeSeconds()));
            }
            case "Phase2LifetimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.phase2LifetimeSeconds()));
            }
            case "RekeyMarginTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.rekeyMarginTimeSeconds()));
            }
            case "RekeyFuzzPercentage": {
                return Optional.ofNullable(clazz.cast(this.rekeyFuzzPercentage()));
            }
            case "ReplayWindowSize": {
                return Optional.ofNullable(clazz.cast(this.replayWindowSize()));
            }
            case "DPDTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.dpdTimeoutSeconds()));
            }
            case "DPDTimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.dpdTimeoutAction()));
            }
            case "Phase1EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase1EncryptionAlgorithms()));
            }
            case "Phase2EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase2EncryptionAlgorithms()));
            }
            case "Phase1IntegrityAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase1IntegrityAlgorithms()));
            }
            case "Phase2IntegrityAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase2IntegrityAlgorithms()));
            }
            case "Phase1DHGroupNumbers": {
                return Optional.ofNullable(clazz.cast(this.phase1DHGroupNumbers()));
            }
            case "Phase2DHGroupNumbers": {
                return Optional.ofNullable(clazz.cast(this.phase2DHGroupNumbers()));
            }
            case "IKEVersions": {
                return Optional.ofNullable(clazz.cast(this.ikeVersions()));
            }
            case "StartupAction": {
                return Optional.ofNullable(clazz.cast(this.startupAction()));
            }
            case "LogOptions": {
                return Optional.ofNullable(clazz.cast(this.logOptions()));
            }
            case "EnableTunnelLifecycleControl": {
                return Optional.ofNullable(clazz.cast(this.enableTunnelLifecycleControl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TunnelInsideCidr", TUNNEL_INSIDE_CIDR_FIELD);
        map.put("TunnelInsideIpv6Cidr", TUNNEL_INSIDE_IPV6_CIDR_FIELD);
        map.put("PreSharedKey", PRE_SHARED_KEY_FIELD);
        map.put("Phase1LifetimeSeconds", PHASE1_LIFETIME_SECONDS_FIELD);
        map.put("Phase2LifetimeSeconds", PHASE2_LIFETIME_SECONDS_FIELD);
        map.put("RekeyMarginTimeSeconds", REKEY_MARGIN_TIME_SECONDS_FIELD);
        map.put("RekeyFuzzPercentage", REKEY_FUZZ_PERCENTAGE_FIELD);
        map.put("ReplayWindowSize", REPLAY_WINDOW_SIZE_FIELD);
        map.put("DPDTimeoutSeconds", DPD_TIMEOUT_SECONDS_FIELD);
        map.put("DPDTimeoutAction", DPD_TIMEOUT_ACTION_FIELD);
        map.put("Phase1EncryptionAlgorithm", PHASE1_ENCRYPTION_ALGORITHMS_FIELD);
        map.put("Phase2EncryptionAlgorithm", PHASE2_ENCRYPTION_ALGORITHMS_FIELD);
        map.put("Phase1IntegrityAlgorithm", PHASE1_INTEGRITY_ALGORITHMS_FIELD);
        map.put("Phase2IntegrityAlgorithm", PHASE2_INTEGRITY_ALGORITHMS_FIELD);
        map.put("Phase1DHGroupNumber", PHASE1_DH_GROUP_NUMBERS_FIELD);
        map.put("Phase2DHGroupNumber", PHASE2_DH_GROUP_NUMBERS_FIELD);
        map.put("IKEVersion", IKE_VERSIONS_FIELD);
        map.put("StartupAction", STARTUP_ACTION_FIELD);
        map.put("LogOptions", LOG_OPTIONS_FIELD);
        map.put("EnableTunnelLifecycleControl", ENABLE_TUNNEL_LIFECYCLE_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpnTunnelOptionsSpecification, T> g) {
        return obj -> g.apply((VpnTunnelOptionsSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tunnelInsideCidr;
        private String tunnelInsideIpv6Cidr;
        private String preSharedKey;
        private Integer phase1LifetimeSeconds;
        private Integer phase2LifetimeSeconds;
        private Integer rekeyMarginTimeSeconds;
        private Integer rekeyFuzzPercentage;
        private Integer replayWindowSize;
        private Integer dpdTimeoutSeconds;
        private String dpdTimeoutAction;
        private List<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<IKEVersionsRequestListValue> ikeVersions = DefaultSdkAutoConstructList.getInstance();
        private String startupAction;
        private VpnTunnelLogOptionsSpecification logOptions;
        private Boolean enableTunnelLifecycleControl;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnTunnelOptionsSpecification model) {
            this.tunnelInsideCidr(model.tunnelInsideCidr);
            this.tunnelInsideIpv6Cidr(model.tunnelInsideIpv6Cidr);
            this.preSharedKey(model.preSharedKey);
            this.phase1LifetimeSeconds(model.phase1LifetimeSeconds);
            this.phase2LifetimeSeconds(model.phase2LifetimeSeconds);
            this.rekeyMarginTimeSeconds(model.rekeyMarginTimeSeconds);
            this.rekeyFuzzPercentage(model.rekeyFuzzPercentage);
            this.replayWindowSize(model.replayWindowSize);
            this.dpdTimeoutSeconds(model.dpdTimeoutSeconds);
            this.dpdTimeoutAction(model.dpdTimeoutAction);
            this.phase1EncryptionAlgorithms(model.phase1EncryptionAlgorithms);
            this.phase2EncryptionAlgorithms(model.phase2EncryptionAlgorithms);
            this.phase1IntegrityAlgorithms(model.phase1IntegrityAlgorithms);
            this.phase2IntegrityAlgorithms(model.phase2IntegrityAlgorithms);
            this.phase1DHGroupNumbers(model.phase1DHGroupNumbers);
            this.phase2DHGroupNumbers(model.phase2DHGroupNumbers);
            this.ikeVersions(model.ikeVersions);
            this.startupAction(model.startupAction);
            this.logOptions(model.logOptions);
            this.enableTunnelLifecycleControl(model.enableTunnelLifecycleControl);
        }

        public final String getTunnelInsideCidr() {
            return this.tunnelInsideCidr;
        }

        public final void setTunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        @Override
        public final Builder tunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        public final String getTunnelInsideIpv6Cidr() {
            return this.tunnelInsideIpv6Cidr;
        }

        public final void setTunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
        }

        @Override
        public final Builder tunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
            return this;
        }

        public final String getPreSharedKey() {
            return this.preSharedKey;
        }

        public final void setPreSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
        }

        @Override
        public final Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        public final Integer getPhase1LifetimeSeconds() {
            return this.phase1LifetimeSeconds;
        }

        public final void setPhase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
        }

        @Override
        public final Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
            return this;
        }

        public final Integer getPhase2LifetimeSeconds() {
            return this.phase2LifetimeSeconds;
        }

        public final void setPhase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
        }

        @Override
        public final Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
            return this;
        }

        public final Integer getRekeyMarginTimeSeconds() {
            return this.rekeyMarginTimeSeconds;
        }

        public final void setRekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
        }

        @Override
        public final Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
            return this;
        }

        public final Integer getRekeyFuzzPercentage() {
            return this.rekeyFuzzPercentage;
        }

        public final void setRekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
        }

        @Override
        public final Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
            return this;
        }

        public final Integer getReplayWindowSize() {
            return this.replayWindowSize;
        }

        public final void setReplayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
        }

        @Override
        public final Builder replayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
            return this;
        }

        public final Integer getDpdTimeoutSeconds() {
            return this.dpdTimeoutSeconds;
        }

        public final void setDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        }

        @Override
        public final Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
            return this;
        }

        public final String getDpdTimeoutAction() {
            return this.dpdTimeoutAction;
        }

        public final void setDpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
        }

        @Override
        public final Builder dpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
            return this;
        }

        public final List<Phase1EncryptionAlgorithmsRequestListValue.Builder> getPhase1EncryptionAlgorithms() {
            List<Phase1EncryptionAlgorithmsRequestListValue.Builder> result = Phase1EncryptionAlgorithmsRequestListCopier.copyToBuilder(this.phase1EncryptionAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsRequestListValue.BuilderImpl> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsRequestListCopier.copyFromBuilder(phase1EncryptionAlgorithms);
        }

        @Override
        public final Builder phase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsRequestListCopier.copy(phase1EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsRequestListValue ... phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms(Arrays.asList(phase1EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(Consumer<Phase1EncryptionAlgorithmsRequestListValue.Builder> ... phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms(Stream.of(phase1EncryptionAlgorithms).map(c -> (Phase1EncryptionAlgorithmsRequestListValue)((Phase1EncryptionAlgorithmsRequestListValue.Builder)Phase1EncryptionAlgorithmsRequestListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2EncryptionAlgorithmsRequestListValue.Builder> getPhase2EncryptionAlgorithms() {
            List<Phase2EncryptionAlgorithmsRequestListValue.Builder> result = Phase2EncryptionAlgorithmsRequestListCopier.copyToBuilder(this.phase2EncryptionAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsRequestListValue.BuilderImpl> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsRequestListCopier.copyFromBuilder(phase2EncryptionAlgorithms);
        }

        @Override
        public final Builder phase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsRequestListCopier.copy(phase2EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsRequestListValue ... phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms(Arrays.asList(phase2EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(Consumer<Phase2EncryptionAlgorithmsRequestListValue.Builder> ... phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms(Stream.of(phase2EncryptionAlgorithms).map(c -> (Phase2EncryptionAlgorithmsRequestListValue)((Phase2EncryptionAlgorithmsRequestListValue.Builder)Phase2EncryptionAlgorithmsRequestListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase1IntegrityAlgorithmsRequestListValue.Builder> getPhase1IntegrityAlgorithms() {
            List<Phase1IntegrityAlgorithmsRequestListValue.Builder> result = Phase1IntegrityAlgorithmsRequestListCopier.copyToBuilder(this.phase1IntegrityAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsRequestListValue.BuilderImpl> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsRequestListCopier.copyFromBuilder(phase1IntegrityAlgorithms);
        }

        @Override
        public final Builder phase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsRequestListCopier.copy(phase1IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsRequestListValue ... phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms(Arrays.asList(phase1IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(Consumer<Phase1IntegrityAlgorithmsRequestListValue.Builder> ... phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms(Stream.of(phase1IntegrityAlgorithms).map(c -> (Phase1IntegrityAlgorithmsRequestListValue)((Phase1IntegrityAlgorithmsRequestListValue.Builder)Phase1IntegrityAlgorithmsRequestListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2IntegrityAlgorithmsRequestListValue.Builder> getPhase2IntegrityAlgorithms() {
            List<Phase2IntegrityAlgorithmsRequestListValue.Builder> result = Phase2IntegrityAlgorithmsRequestListCopier.copyToBuilder(this.phase2IntegrityAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsRequestListValue.BuilderImpl> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsRequestListCopier.copyFromBuilder(phase2IntegrityAlgorithms);
        }

        @Override
        public final Builder phase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsRequestListCopier.copy(phase2IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsRequestListValue ... phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms(Arrays.asList(phase2IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(Consumer<Phase2IntegrityAlgorithmsRequestListValue.Builder> ... phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms(Stream.of(phase2IntegrityAlgorithms).map(c -> (Phase2IntegrityAlgorithmsRequestListValue)((Phase2IntegrityAlgorithmsRequestListValue.Builder)Phase2IntegrityAlgorithmsRequestListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase1DHGroupNumbersRequestListValue.Builder> getPhase1DHGroupNumbers() {
            List<Phase1DHGroupNumbersRequestListValue.Builder> result = Phase1DHGroupNumbersRequestListCopier.copyToBuilder(this.phase1DHGroupNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1DHGroupNumbers(Collection<Phase1DHGroupNumbersRequestListValue.BuilderImpl> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersRequestListCopier.copyFromBuilder(phase1DHGroupNumbers);
        }

        @Override
        public final Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersRequestListCopier.copy(phase1DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Phase1DHGroupNumbersRequestListValue ... phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers(Arrays.asList(phase1DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersRequestListValue.Builder> ... phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers(Stream.of(phase1DHGroupNumbers).map(c -> (Phase1DHGroupNumbersRequestListValue)((Phase1DHGroupNumbersRequestListValue.Builder)Phase1DHGroupNumbersRequestListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2DHGroupNumbersRequestListValue.Builder> getPhase2DHGroupNumbers() {
            List<Phase2DHGroupNumbersRequestListValue.Builder> result = Phase2DHGroupNumbersRequestListCopier.copyToBuilder(this.phase2DHGroupNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2DHGroupNumbers(Collection<Phase2DHGroupNumbersRequestListValue.BuilderImpl> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersRequestListCopier.copyFromBuilder(phase2DHGroupNumbers);
        }

        @Override
        public final Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersRequestListCopier.copy(phase2DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Phase2DHGroupNumbersRequestListValue ... phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers(Arrays.asList(phase2DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersRequestListValue.Builder> ... phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers(Stream.of(phase2DHGroupNumbers).map(c -> (Phase2DHGroupNumbersRequestListValue)((Phase2DHGroupNumbersRequestListValue.Builder)Phase2DHGroupNumbersRequestListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IKEVersionsRequestListValue.Builder> getIkeVersions() {
            List<IKEVersionsRequestListValue.Builder> result = IKEVersionsRequestListCopier.copyToBuilder(this.ikeVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIkeVersions(Collection<IKEVersionsRequestListValue.BuilderImpl> ikeVersions) {
            this.ikeVersions = IKEVersionsRequestListCopier.copyFromBuilder(ikeVersions);
        }

        @Override
        public final Builder ikeVersions(Collection<IKEVersionsRequestListValue> ikeVersions) {
            this.ikeVersions = IKEVersionsRequestListCopier.copy(ikeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(IKEVersionsRequestListValue ... ikeVersions) {
            this.ikeVersions(Arrays.asList(ikeVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(Consumer<IKEVersionsRequestListValue.Builder> ... ikeVersions) {
            this.ikeVersions(Stream.of(ikeVersions).map(c -> (IKEVersionsRequestListValue)((IKEVersionsRequestListValue.Builder)IKEVersionsRequestListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStartupAction() {
            return this.startupAction;
        }

        public final void setStartupAction(String startupAction) {
            this.startupAction = startupAction;
        }

        @Override
        public final Builder startupAction(String startupAction) {
            this.startupAction = startupAction;
            return this;
        }

        public final VpnTunnelLogOptionsSpecification.Builder getLogOptions() {
            return this.logOptions != null ? this.logOptions.toBuilder() : null;
        }

        public final void setLogOptions(VpnTunnelLogOptionsSpecification.BuilderImpl logOptions) {
            this.logOptions = logOptions != null ? logOptions.build() : null;
        }

        @Override
        public final Builder logOptions(VpnTunnelLogOptionsSpecification logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        public final Boolean getEnableTunnelLifecycleControl() {
            return this.enableTunnelLifecycleControl;
        }

        public final void setEnableTunnelLifecycleControl(Boolean enableTunnelLifecycleControl) {
            this.enableTunnelLifecycleControl = enableTunnelLifecycleControl;
        }

        @Override
        public final Builder enableTunnelLifecycleControl(Boolean enableTunnelLifecycleControl) {
            this.enableTunnelLifecycleControl = enableTunnelLifecycleControl;
            return this;
        }

        public VpnTunnelOptionsSpecification build() {
            return new VpnTunnelOptionsSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnTunnelOptionsSpecification> {
        public Builder tunnelInsideCidr(String var1);

        public Builder tunnelInsideIpv6Cidr(String var1);

        public Builder preSharedKey(String var1);

        public Builder phase1LifetimeSeconds(Integer var1);

        public Builder phase2LifetimeSeconds(Integer var1);

        public Builder rekeyMarginTimeSeconds(Integer var1);

        public Builder rekeyFuzzPercentage(Integer var1);

        public Builder replayWindowSize(Integer var1);

        public Builder dpdTimeoutSeconds(Integer var1);

        public Builder dpdTimeoutAction(String var1);

        public Builder phase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsRequestListValue> var1);

        public Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsRequestListValue ... var1);

        public Builder phase1EncryptionAlgorithms(Consumer<Phase1EncryptionAlgorithmsRequestListValue.Builder> ... var1);

        public Builder phase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsRequestListValue> var1);

        public Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsRequestListValue ... var1);

        public Builder phase2EncryptionAlgorithms(Consumer<Phase2EncryptionAlgorithmsRequestListValue.Builder> ... var1);

        public Builder phase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsRequestListValue> var1);

        public Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsRequestListValue ... var1);

        public Builder phase1IntegrityAlgorithms(Consumer<Phase1IntegrityAlgorithmsRequestListValue.Builder> ... var1);

        public Builder phase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsRequestListValue> var1);

        public Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsRequestListValue ... var1);

        public Builder phase2IntegrityAlgorithms(Consumer<Phase2IntegrityAlgorithmsRequestListValue.Builder> ... var1);

        public Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersRequestListValue> var1);

        public Builder phase1DHGroupNumbers(Phase1DHGroupNumbersRequestListValue ... var1);

        public Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersRequestListValue.Builder> ... var1);

        public Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersRequestListValue> var1);

        public Builder phase2DHGroupNumbers(Phase2DHGroupNumbersRequestListValue ... var1);

        public Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersRequestListValue.Builder> ... var1);

        public Builder ikeVersions(Collection<IKEVersionsRequestListValue> var1);

        public Builder ikeVersions(IKEVersionsRequestListValue ... var1);

        public Builder ikeVersions(Consumer<IKEVersionsRequestListValue.Builder> ... var1);

        public Builder startupAction(String var1);

        public Builder logOptions(VpnTunnelLogOptionsSpecification var1);

        default public Builder logOptions(Consumer<VpnTunnelLogOptionsSpecification.Builder> logOptions) {
            return this.logOptions((VpnTunnelLogOptionsSpecification)((VpnTunnelLogOptionsSpecification.Builder)VpnTunnelLogOptionsSpecification.builder().applyMutation(logOptions)).build());
        }

        public Builder enableTunnelLifecycleControl(Boolean var1);
    }
}

