/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConnectionNotificationIdsListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVpcEndpointConnectionNotificationsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteVpcEndpointConnectionNotificationsRequest.getter(DeleteVpcEndpointConnectionNotificationsRequest::dryRun)).setter(DeleteVpcEndpointConnectionNotificationsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<String>> CONNECTION_NOTIFICATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionNotificationIds").getter(DeleteVpcEndpointConnectionNotificationsRequest.getter(DeleteVpcEndpointConnectionNotificationsRequest::connectionNotificationIds)).setter(DeleteVpcEndpointConnectionNotificationsRequest.setter(Builder::connectionNotificationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationId").unmarshallLocationName("ConnectionNotificationId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, CONNECTION_NOTIFICATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteVpcEndpointConnectionNotificationsRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final List<String> connectionNotificationIds;

    private DeleteVpcEndpointConnectionNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.connectionNotificationIds = builder.connectionNotificationIds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasConnectionNotificationIds() {
        return this.connectionNotificationIds != null && !(this.connectionNotificationIds instanceof SdkAutoConstructList);
    }

    public final List<String> connectionNotificationIds() {
        return this.connectionNotificationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionNotificationIds() ? this.connectionNotificationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointConnectionNotificationsRequest)) {
            return false;
        }
        DeleteVpcEndpointConnectionNotificationsRequest other = (DeleteVpcEndpointConnectionNotificationsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasConnectionNotificationIds() == other.hasConnectionNotificationIds() && Objects.equals(this.connectionNotificationIds(), other.connectionNotificationIds());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteVpcEndpointConnectionNotificationsRequest").add("DryRun", (Object)this.dryRun()).add("ConnectionNotificationIds", this.hasConnectionNotificationIds() ? this.connectionNotificationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ConnectionNotificationIds": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ConnectionNotificationId", CONNECTION_NOTIFICATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointConnectionNotificationsRequest, T> g) {
        return obj -> g.apply((DeleteVpcEndpointConnectionNotificationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<String> connectionNotificationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointConnectionNotificationsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.connectionNotificationIds(model.connectionNotificationIds);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getConnectionNotificationIds() {
            if (this.connectionNotificationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectionNotificationIds;
        }

        public final void setConnectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ConnectionNotificationIdsListCopier.copy(connectionNotificationIds);
        }

        @Override
        public final Builder connectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ConnectionNotificationIdsListCopier.copy(connectionNotificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationIds(String ... connectionNotificationIds) {
            this.connectionNotificationIds(Arrays.asList(connectionNotificationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointConnectionNotificationsRequest build() {
            return new DeleteVpcEndpointConnectionNotificationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder connectionNotificationIds(Collection<String> var1);

        public Builder connectionNotificationIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

