/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceTransitGatewayRouteResponse extends Ec2Response implements
        ToCopyableBuilder<ReplaceTransitGatewayRouteResponse.Builder, ReplaceTransitGatewayRouteResponse> {
    private static final SdkField<TransitGatewayRoute> ROUTE_FIELD = SdkField
            .<TransitGatewayRoute> builder(MarshallingType.SDK_POJO)
            .memberName("Route")
            .getter(getter(ReplaceTransitGatewayRouteResponse::route))
            .setter(setter(Builder::route))
            .constructor(TransitGatewayRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Route")
                    .unmarshallLocationName("route").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransitGatewayRoute route;

    private ReplaceTransitGatewayRouteResponse(BuilderImpl builder) {
        super(builder);
        this.route = builder.route;
    }

    /**
     * <p>
     * Information about the modified route.
     * </p>
     * 
     * @return Information about the modified route.
     */
    public final TransitGatewayRoute route() {
        return route;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(route());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceTransitGatewayRouteResponse)) {
            return false;
        }
        ReplaceTransitGatewayRouteResponse other = (ReplaceTransitGatewayRouteResponse) obj;
        return Objects.equals(route(), other.route());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplaceTransitGatewayRouteResponse").add("Route", route()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Route":
            return Optional.ofNullable(clazz.cast(route()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Route", ROUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplaceTransitGatewayRouteResponse, T> g) {
        return obj -> g.apply((ReplaceTransitGatewayRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ReplaceTransitGatewayRouteResponse> {
        /**
         * <p>
         * Information about the modified route.
         * </p>
         * 
         * @param route
         *        Information about the modified route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder route(TransitGatewayRoute route);

        /**
         * <p>
         * Information about the modified route.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayRoute.Builder} avoiding the
         * need to create one manually via {@link TransitGatewayRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayRoute.Builder#build()} is called immediately and
         * its result is passed to {@link #route(TransitGatewayRoute)}.
         * 
         * @param route
         *        a consumer that will call methods on {@link TransitGatewayRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #route(TransitGatewayRoute)
         */
        default Builder route(Consumer<TransitGatewayRoute.Builder> route) {
            return route(TransitGatewayRoute.builder().applyMutation(route).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayRoute route;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceTransitGatewayRouteResponse model) {
            super(model);
            route(model.route);
        }

        public final TransitGatewayRoute.Builder getRoute() {
            return route != null ? route.toBuilder() : null;
        }

        public final void setRoute(TransitGatewayRoute.BuilderImpl route) {
            this.route = route != null ? route.build() : null;
        }

        @Override
        public final Builder route(TransitGatewayRoute route) {
            this.route = route;
            return this;
        }

        @Override
        public ReplaceTransitGatewayRouteResponse build() {
            return new ReplaceTransitGatewayRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
