/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the authentication methods used by a Client VPN endpoint. For more information, see <a
 * href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html">Authentication</a> in the
 * <i>Client VPN Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientVpnAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientVpnAuthentication.Builder, ClientVpnAuthentication> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(ClientVpnAuthentication::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<DirectoryServiceAuthentication> ACTIVE_DIRECTORY_FIELD = SdkField
            .<DirectoryServiceAuthentication> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveDirectory")
            .getter(getter(ClientVpnAuthentication::activeDirectory))
            .setter(setter(Builder::activeDirectory))
            .constructor(DirectoryServiceAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectory")
                    .unmarshallLocationName("activeDirectory").build()).build();

    private static final SdkField<CertificateAuthentication> MUTUAL_AUTHENTICATION_FIELD = SdkField
            .<CertificateAuthentication> builder(MarshallingType.SDK_POJO)
            .memberName("MutualAuthentication")
            .getter(getter(ClientVpnAuthentication::mutualAuthentication))
            .setter(setter(Builder::mutualAuthentication))
            .constructor(CertificateAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutualAuthentication")
                    .unmarshallLocationName("mutualAuthentication").build()).build();

    private static final SdkField<FederatedAuthentication> FEDERATED_AUTHENTICATION_FIELD = SdkField
            .<FederatedAuthentication> builder(MarshallingType.SDK_POJO)
            .memberName("FederatedAuthentication")
            .getter(getter(ClientVpnAuthentication::federatedAuthentication))
            .setter(setter(Builder::federatedAuthentication))
            .constructor(FederatedAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederatedAuthentication")
                    .unmarshallLocationName("federatedAuthentication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            ACTIVE_DIRECTORY_FIELD, MUTUAL_AUTHENTICATION_FIELD, FEDERATED_AUTHENTICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final DirectoryServiceAuthentication activeDirectory;

    private final CertificateAuthentication mutualAuthentication;

    private final FederatedAuthentication federatedAuthentication;

    private ClientVpnAuthentication(BuilderImpl builder) {
        this.type = builder.type;
        this.activeDirectory = builder.activeDirectory;
        this.mutualAuthentication = builder.mutualAuthentication;
        this.federatedAuthentication = builder.federatedAuthentication;
    }

    /**
     * <p>
     * The authentication type used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientVpnAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The authentication type used.
     * @see ClientVpnAuthenticationType
     */
    public final ClientVpnAuthenticationType type() {
        return ClientVpnAuthenticationType.fromValue(type);
    }

    /**
     * <p>
     * The authentication type used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientVpnAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The authentication type used.
     * @see ClientVpnAuthenticationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the Active Directory, if applicable.
     * </p>
     * 
     * @return Information about the Active Directory, if applicable.
     */
    public final DirectoryServiceAuthentication activeDirectory() {
        return activeDirectory;
    }

    /**
     * <p>
     * Information about the authentication certificates, if applicable.
     * </p>
     * 
     * @return Information about the authentication certificates, if applicable.
     */
    public final CertificateAuthentication mutualAuthentication() {
        return mutualAuthentication;
    }

    /**
     * <p>
     * Information about the IAM SAML identity provider, if applicable.
     * </p>
     * 
     * @return Information about the IAM SAML identity provider, if applicable.
     */
    public final FederatedAuthentication federatedAuthentication() {
        return federatedAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(mutualAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(federatedAuthentication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnAuthentication)) {
            return false;
        }
        ClientVpnAuthentication other = (ClientVpnAuthentication) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(activeDirectory(), other.activeDirectory())
                && Objects.equals(mutualAuthentication(), other.mutualAuthentication())
                && Objects.equals(federatedAuthentication(), other.federatedAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientVpnAuthentication").add("Type", typeAsString()).add("ActiveDirectory", activeDirectory())
                .add("MutualAuthentication", mutualAuthentication()).add("FederatedAuthentication", federatedAuthentication())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ActiveDirectory":
            return Optional.ofNullable(clazz.cast(activeDirectory()));
        case "MutualAuthentication":
            return Optional.ofNullable(clazz.cast(mutualAuthentication()));
        case "FederatedAuthentication":
            return Optional.ofNullable(clazz.cast(federatedAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ActiveDirectory", ACTIVE_DIRECTORY_FIELD);
        map.put("MutualAuthentication", MUTUAL_AUTHENTICATION_FIELD);
        map.put("FederatedAuthentication", FEDERATED_AUTHENTICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnAuthentication, T> g) {
        return obj -> g.apply((ClientVpnAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientVpnAuthentication> {
        /**
         * <p>
         * The authentication type used.
         * </p>
         * 
         * @param type
         *        The authentication type used.
         * @see ClientVpnAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnAuthenticationType
         */
        Builder type(String type);

        /**
         * <p>
         * The authentication type used.
         * </p>
         * 
         * @param type
         *        The authentication type used.
         * @see ClientVpnAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnAuthenticationType
         */
        Builder type(ClientVpnAuthenticationType type);

        /**
         * <p>
         * Information about the Active Directory, if applicable.
         * </p>
         * 
         * @param activeDirectory
         *        Information about the Active Directory, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectory(DirectoryServiceAuthentication activeDirectory);

        /**
         * <p>
         * Information about the Active Directory, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectoryServiceAuthentication.Builder}
         * avoiding the need to create one manually via {@link DirectoryServiceAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectoryServiceAuthentication.Builder#build()} is called
         * immediately and its result is passed to {@link #activeDirectory(DirectoryServiceAuthentication)}.
         * 
         * @param activeDirectory
         *        a consumer that will call methods on {@link DirectoryServiceAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectory(DirectoryServiceAuthentication)
         */
        default Builder activeDirectory(Consumer<DirectoryServiceAuthentication.Builder> activeDirectory) {
            return activeDirectory(DirectoryServiceAuthentication.builder().applyMutation(activeDirectory).build());
        }

        /**
         * <p>
         * Information about the authentication certificates, if applicable.
         * </p>
         * 
         * @param mutualAuthentication
         *        Information about the authentication certificates, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualAuthentication(CertificateAuthentication mutualAuthentication);

        /**
         * <p>
         * Information about the authentication certificates, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateAuthentication.Builder}
         * avoiding the need to create one manually via {@link CertificateAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateAuthentication.Builder#build()} is called immediately
         * and its result is passed to {@link #mutualAuthentication(CertificateAuthentication)}.
         * 
         * @param mutualAuthentication
         *        a consumer that will call methods on {@link CertificateAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualAuthentication(CertificateAuthentication)
         */
        default Builder mutualAuthentication(Consumer<CertificateAuthentication.Builder> mutualAuthentication) {
            return mutualAuthentication(CertificateAuthentication.builder().applyMutation(mutualAuthentication).build());
        }

        /**
         * <p>
         * Information about the IAM SAML identity provider, if applicable.
         * </p>
         * 
         * @param federatedAuthentication
         *        Information about the IAM SAML identity provider, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federatedAuthentication(FederatedAuthentication federatedAuthentication);

        /**
         * <p>
         * Information about the IAM SAML identity provider, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link FederatedAuthentication.Builder} avoiding
         * the need to create one manually via {@link FederatedAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FederatedAuthentication.Builder#build()} is called immediately
         * and its result is passed to {@link #federatedAuthentication(FederatedAuthentication)}.
         * 
         * @param federatedAuthentication
         *        a consumer that will call methods on {@link FederatedAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federatedAuthentication(FederatedAuthentication)
         */
        default Builder federatedAuthentication(Consumer<FederatedAuthentication.Builder> federatedAuthentication) {
            return federatedAuthentication(FederatedAuthentication.builder().applyMutation(federatedAuthentication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private DirectoryServiceAuthentication activeDirectory;

        private CertificateAuthentication mutualAuthentication;

        private FederatedAuthentication federatedAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnAuthentication model) {
            type(model.type);
            activeDirectory(model.activeDirectory);
            mutualAuthentication(model.mutualAuthentication);
            federatedAuthentication(model.federatedAuthentication);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ClientVpnAuthenticationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DirectoryServiceAuthentication.Builder getActiveDirectory() {
            return activeDirectory != null ? activeDirectory.toBuilder() : null;
        }

        public final void setActiveDirectory(DirectoryServiceAuthentication.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        @Override
        public final Builder activeDirectory(DirectoryServiceAuthentication activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final CertificateAuthentication.Builder getMutualAuthentication() {
            return mutualAuthentication != null ? mutualAuthentication.toBuilder() : null;
        }

        public final void setMutualAuthentication(CertificateAuthentication.BuilderImpl mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication != null ? mutualAuthentication.build() : null;
        }

        @Override
        public final Builder mutualAuthentication(CertificateAuthentication mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication;
            return this;
        }

        public final FederatedAuthentication.Builder getFederatedAuthentication() {
            return federatedAuthentication != null ? federatedAuthentication.toBuilder() : null;
        }

        public final void setFederatedAuthentication(FederatedAuthentication.BuilderImpl federatedAuthentication) {
            this.federatedAuthentication = federatedAuthentication != null ? federatedAuthentication.build() : null;
        }

        @Override
        public final Builder federatedAuthentication(FederatedAuthentication federatedAuthentication) {
            this.federatedAuthentication = federatedAuthentication;
            return this;
        }

        @Override
        public ClientVpnAuthentication build() {
            return new ClientVpnAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
