/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NatGateway;
import software.amazon.awssdk.services.ec2.model.NatGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNatGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeNatGatewaysResponse> {
    private static final SdkField<List<NatGateway>> NAT_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NatGateways").getter(DescribeNatGatewaysResponse.getter(DescribeNatGatewaysResponse::natGateways)).setter(DescribeNatGatewaysResponse.setter(Builder::natGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewaySet").unmarshallLocationName("natGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NatGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNatGatewaysResponse.getter(DescribeNatGatewaysResponse::nextToken)).setter(DescribeNatGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNatGatewaysResponse.memberNameToFieldInitializer();
    private final List<NatGateway> natGateways;
    private final String nextToken;

    private DescribeNatGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.natGateways = builder.natGateways;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNatGateways() {
        return this.natGateways != null && !(this.natGateways instanceof SdkAutoConstructList);
    }

    public final List<NatGateway> natGateways() {
        return this.natGateways;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNatGateways() ? this.natGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysResponse)) {
            return false;
        }
        DescribeNatGatewaysResponse other = (DescribeNatGatewaysResponse)((Object)obj);
        return this.hasNatGateways() == other.hasNatGateways() && Objects.equals(this.natGateways(), other.natGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNatGatewaysResponse").add("NatGateways", this.hasNatGateways() ? this.natGateways() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGateways": {
                return Optional.ofNullable(clazz.cast(this.natGateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NatGatewaySet", NAT_GATEWAYS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNatGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeNatGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<NatGateway> natGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysResponse model) {
            super(model);
            this.natGateways(model.natGateways);
            this.nextToken(model.nextToken);
        }

        public final List<NatGateway.Builder> getNatGateways() {
            List<NatGateway.Builder> result = NatGatewayListCopier.copyToBuilder(this.natGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNatGateways(Collection<NatGateway.BuilderImpl> natGateways) {
            this.natGateways = NatGatewayListCopier.copyFromBuilder(natGateways);
        }

        @Override
        public final Builder natGateways(Collection<NatGateway> natGateways) {
            this.natGateways = NatGatewayListCopier.copy(natGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(NatGateway ... natGateways) {
            this.natGateways(Arrays.asList(natGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(Consumer<NatGateway.Builder> ... natGateways) {
            this.natGateways(Stream.of(natGateways).map(c -> (NatGateway)((NatGateway.Builder)NatGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeNatGatewaysResponse build() {
            return new DescribeNatGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNatGatewaysResponse> {
        public Builder natGateways(Collection<NatGateway> var1);

        public Builder natGateways(NatGateway ... var1);

        public Builder natGateways(Consumer<NatGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

