/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayPolicyTableAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayPolicyTableAssociation> {
    private static final SdkField<String> TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayPolicyTableId").getter(TransitGatewayPolicyTableAssociation.getter(TransitGatewayPolicyTableAssociation::transitGatewayPolicyTableId)).setter(TransitGatewayPolicyTableAssociation.setter(Builder::transitGatewayPolicyTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPolicyTableId").unmarshallLocationName("transitGatewayPolicyTableId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayPolicyTableAssociation.getter(TransitGatewayPolicyTableAssociation::transitGatewayAttachmentId)).setter(TransitGatewayPolicyTableAssociation.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(TransitGatewayPolicyTableAssociation.getter(TransitGatewayPolicyTableAssociation::resourceId)).setter(TransitGatewayPolicyTableAssociation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TransitGatewayPolicyTableAssociation.getter(TransitGatewayPolicyTableAssociation::resourceTypeAsString)).setter(TransitGatewayPolicyTableAssociation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayPolicyTableAssociation.getter(TransitGatewayPolicyTableAssociation::stateAsString)).setter(TransitGatewayPolicyTableAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayPolicyTableAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayPolicyTableId;
    private final String transitGatewayAttachmentId;
    private final String resourceId;
    private final String resourceType;
    private final String state;

    private TransitGatewayPolicyTableAssociation(BuilderImpl builder) {
        this.transitGatewayPolicyTableId = builder.transitGatewayPolicyTableId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
    }

    public final String transitGatewayPolicyTableId() {
        return this.transitGatewayPolicyTableId;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final TransitGatewayAssociationState state() {
        return TransitGatewayAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayPolicyTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPolicyTableAssociation)) {
            return false;
        }
        TransitGatewayPolicyTableAssociation other = (TransitGatewayPolicyTableAssociation)obj;
        return Objects.equals(this.transitGatewayPolicyTableId(), other.transitGatewayPolicyTableId()) && Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayPolicyTableAssociation").add("TransitGatewayPolicyTableId", (Object)this.transitGatewayPolicyTableId()).add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayPolicyTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayPolicyTableId()));
            }
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TransitGatewayPolicyTableId", TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD);
        map.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPolicyTableAssociation, T> g) {
        return obj -> g.apply((TransitGatewayPolicyTableAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayPolicyTableId;
        private String transitGatewayAttachmentId;
        private String resourceId;
        private String resourceType;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPolicyTableAssociation model) {
            this.transitGatewayPolicyTableId(model.transitGatewayPolicyTableId);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.state(model.state);
        }

        public final String getTransitGatewayPolicyTableId() {
            return this.transitGatewayPolicyTableId;
        }

        public final void setTransitGatewayPolicyTableId(String transitGatewayPolicyTableId) {
            this.transitGatewayPolicyTableId = transitGatewayPolicyTableId;
        }

        @Override
        public final Builder transitGatewayPolicyTableId(String transitGatewayPolicyTableId) {
            this.transitGatewayPolicyTableId = transitGatewayPolicyTableId;
            return this;
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public TransitGatewayPolicyTableAssociation build() {
            return new TransitGatewayPolicyTableAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayPolicyTableAssociation> {
        public Builder transitGatewayPolicyTableId(String var1);

        public Builder transitGatewayAttachmentId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayAssociationState var1);
    }
}

