/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EkPubKeyType {
    RSA_2048("rsa-2048"),
    ECC_SEC_P384("ecc-sec-p384"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EkPubKeyType> VALUE_MAP;
    private final String value;

    private EkPubKeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EkPubKeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EkPubKeyType> knownValues() {
        EnumSet<EkPubKeyType> knownValues = EnumSet.allOf(EkPubKeyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EkPubKeyType.class, EkPubKeyType::toString);
    }
}

