/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.RecurringChargesListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceState;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstances
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstances> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedInstances.getter(ReservedInstances::currencyCodeAsString)).setter(ReservedInstances.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceTenancy").getter(ReservedInstances.getter(ReservedInstances::instanceTenancyAsString)).setter(ReservedInstances.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingClass").getter(ReservedInstances.getter(ReservedInstances::offeringClassAsString)).setter(ReservedInstances.setter(Builder::offeringClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass").unmarshallLocationName("offeringClass").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(ReservedInstances.getter(ReservedInstances::offeringTypeAsString)).setter(ReservedInstances.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").unmarshallLocationName("offeringType").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedInstances.getter(ReservedInstances::recurringCharges)).setter(ReservedInstances.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").unmarshallLocationName("recurringCharges").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(ReservedInstances.getter(ReservedInstances::scopeAsString)).setter(ReservedInstances.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").unmarshallLocationName("scope").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ReservedInstances.getter(ReservedInstances::tags)).setter(ReservedInstances.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstancesId").getter(ReservedInstances.getter(ReservedInstances::reservedInstancesId)).setter(ReservedInstances.setter(Builder::reservedInstancesId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("reservedInstancesId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ReservedInstances.getter(ReservedInstances::instanceTypeAsString)).setter(ReservedInstances.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ReservedInstances.getter(ReservedInstances::availabilityZone)).setter(ReservedInstances.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Instant> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Start").getter(ReservedInstances.getter(ReservedInstances::start)).setter(ReservedInstances.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").unmarshallLocationName("start").build()}).build();
    private static final SdkField<Instant> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("End").getter(ReservedInstances.getter(ReservedInstances::end)).setter(ReservedInstances.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").unmarshallLocationName("end").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(ReservedInstances.getter(ReservedInstances::duration)).setter(ReservedInstances.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").unmarshallLocationName("duration").build()}).build();
    private static final SdkField<Float> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("UsagePrice").getter(ReservedInstances.getter(ReservedInstances::usagePrice)).setter(ReservedInstances.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").unmarshallLocationName("usagePrice").build()}).build();
    private static final SdkField<Float> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("FixedPrice").getter(ReservedInstances.getter(ReservedInstances::fixedPrice)).setter(ReservedInstances.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").unmarshallLocationName("fixedPrice").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ReservedInstances.getter(ReservedInstances::instanceCount)).setter(ReservedInstances.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(ReservedInstances.getter(ReservedInstances::productDescriptionAsString)).setter(ReservedInstances.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").unmarshallLocationName("productDescription").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ReservedInstances.getter(ReservedInstances::stateAsString)).setter(ReservedInstances.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, INSTANCE_TENANCY_FIELD, OFFERING_CLASS_FIELD, OFFERING_TYPE_FIELD, RECURRING_CHARGES_FIELD, SCOPE_FIELD, TAGS_FIELD, RESERVED_INSTANCES_ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, START_FIELD, END_FIELD, DURATION_FIELD, USAGE_PRICE_FIELD, FIXED_PRICE_FIELD, INSTANCE_COUNT_FIELD, PRODUCT_DESCRIPTION_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedInstances.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final String instanceTenancy;
    private final String offeringClass;
    private final String offeringType;
    private final List<RecurringCharge> recurringCharges;
    private final String scope;
    private final List<Tag> tags;
    private final String reservedInstancesId;
    private final String instanceType;
    private final String availabilityZone;
    private final Instant start;
    private final Instant end;
    private final Long duration;
    private final Float usagePrice;
    private final Float fixedPrice;
    private final Integer instanceCount;
    private final String productDescription;
    private final String state;

    private ReservedInstances(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.tags = builder.tags;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.start = builder.start;
        this.end = builder.end;
        this.duration = builder.duration;
        this.usagePrice = builder.usagePrice;
        this.fixedPrice = builder.fixedPrice;
        this.instanceCount = builder.instanceCount;
        this.productDescription = builder.productDescription;
        this.state = builder.state;
    }

    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public final String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public final OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public final String offeringClassAsString() {
        return this.offeringClass;
    }

    public final OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public final String offeringTypeAsString() {
        return this.offeringType;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Instant start() {
        return this.start;
    }

    public final Instant end() {
        return this.end;
    }

    public final Long duration() {
        return this.duration;
    }

    public final Float usagePrice() {
        return this.usagePrice;
    }

    public final Float fixedPrice() {
        return this.fixedPrice;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public final String productDescriptionAsString() {
        return this.productDescription;
    }

    public final ReservedInstanceState state() {
        return ReservedInstanceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstances)) {
            return false;
        }
        ReservedInstances other = (ReservedInstances)obj;
        return Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.offeringClassAsString(), other.offeringClassAsString()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.productDescriptionAsString(), other.productDescriptionAsString()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedInstances").add("CurrencyCode", (Object)this.currencyCodeAsString()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("OfferingClass", (Object)this.offeringClassAsString()).add("OfferingType", (Object)this.offeringTypeAsString()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).add("Scope", (Object)this.scopeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ReservedInstancesId", (Object)this.reservedInstancesId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Start", (Object)this.start()).add("End", (Object)this.end()).add("Duration", (Object)this.duration()).add("UsagePrice", (Object)this.usagePrice()).add("FixedPrice", (Object)this.fixedPrice()).add("InstanceCount", (Object)this.instanceCount()).add("ProductDescription", (Object)this.productDescriptionAsString()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
            case "OfferingClass": {
                return Optional.ofNullable(clazz.cast(this.offeringClassAsString()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ReservedInstancesId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescriptionAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("InstanceTenancy", INSTANCE_TENANCY_FIELD);
        map.put("OfferingClass", OFFERING_CLASS_FIELD);
        map.put("OfferingType", OFFERING_TYPE_FIELD);
        map.put("RecurringCharges", RECURRING_CHARGES_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ReservedInstancesId", RESERVED_INSTANCES_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Start", START_FIELD);
        map.put("End", END_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("UsagePrice", USAGE_PRICE_FIELD);
        map.put("FixedPrice", FIXED_PRICE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("ProductDescription", PRODUCT_DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstances, T> g) {
        return obj -> g.apply((ReservedInstances)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private String instanceTenancy;
        private String offeringClass;
        private String offeringType;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();
        private String scope;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String reservedInstancesId;
        private String instanceType;
        private String availabilityZone;
        private Instant start;
        private Instant end;
        private Long duration;
        private Float usagePrice;
        private Float fixedPrice;
        private Integer instanceCount;
        private String productDescription;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstances model) {
            this.currencyCode(model.currencyCode);
            this.instanceTenancy(model.instanceTenancy);
            this.offeringClass(model.offeringClass);
            this.offeringType(model.offeringType);
            this.recurringCharges(model.recurringCharges);
            this.scope(model.scope);
            this.tags(model.tags);
            this.reservedInstancesId(model.reservedInstancesId);
            this.instanceType(model.instanceType);
            this.availabilityZone(model.availabilityZone);
            this.start(model.start);
            this.end(model.end);
            this.duration(model.duration);
            this.usagePrice(model.usagePrice);
            this.fixedPrice(model.fixedPrice);
            this.instanceCount(model.instanceCount);
            this.productDescription(model.productDescription);
            this.state(model.state);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargesListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Instant getStart() {
            return this.start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return this.end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Float getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final Float getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservedInstanceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public ReservedInstances build() {
            return new ReservedInstances(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstances> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder availabilityZone(String var1);

        public Builder start(Instant var1);

        public Builder end(Instant var1);

        public Builder duration(Long var1);

        public Builder usagePrice(Float var1);

        public Builder fixedPrice(Float var1);

        public Builder instanceCount(Integer var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder state(String var1);

        public Builder state(ReservedInstanceState var1);
    }
}

