/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.HostOffering;

public class DescribeHostReservationOfferingsIterable
implements SdkIterable<DescribeHostReservationOfferingsResponse> {
    private final Ec2Client client;
    private final DescribeHostReservationOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHostReservationOfferingsIterable(Ec2Client client, DescribeHostReservationOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeHostReservationOfferingsResponseFetcher();
    }

    public Iterator<DescribeHostReservationOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HostOffering> offeringSet() {
        Function<DescribeHostReservationOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.offeringSet() != null) {
                return response.offeringSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeHostReservationOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeHostReservationOfferingsResponse> {
        private DescribeHostReservationOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHostReservationOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeHostReservationOfferingsResponse nextPage(DescribeHostReservationOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHostReservationOfferingsIterable.this.client.describeHostReservationOfferings(DescribeHostReservationOfferingsIterable.this.firstRequest);
            }
            return DescribeHostReservationOfferingsIterable.this.client.describeHostReservationOfferings((DescribeHostReservationOfferingsRequest)((Object)DescribeHostReservationOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

