/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Verified Access group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessGroup.Builder, VerifiedAccessGroup> {
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessGroupId")
            .getter(getter(VerifiedAccessGroup::verifiedAccessGroupId))
            .setter(setter(Builder::verifiedAccessGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId")
                    .unmarshallLocationName("verifiedAccessGroupId").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessInstanceId")
            .getter(getter(VerifiedAccessGroup::verifiedAccessInstanceId))
            .setter(setter(Builder::verifiedAccessInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId")
                    .unmarshallLocationName("verifiedAccessInstanceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(VerifiedAccessGroup::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Owner")
            .getter(getter(VerifiedAccessGroup::owner))
            .setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("owner").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessGroupArn")
            .getter(getter(VerifiedAccessGroup::verifiedAccessGroupArn))
            .setter(setter(Builder::verifiedAccessGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupArn")
                    .unmarshallLocationName("verifiedAccessGroupArn").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreationTime")
            .getter(getter(VerifiedAccessGroup::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedTime")
            .getter(getter(VerifiedAccessGroup::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime")
                    .unmarshallLocationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> DELETION_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeletionTime")
            .getter(getter(VerifiedAccessGroup::deletionTime))
            .setter(setter(Builder::deletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime")
                    .unmarshallLocationName("deletionTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VerifiedAccessGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<VerifiedAccessSseSpecificationResponse> SSE_SPECIFICATION_FIELD = SdkField
            .<VerifiedAccessSseSpecificationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("SseSpecification")
            .getter(getter(VerifiedAccessGroup::sseSpecification))
            .setter(setter(Builder::sseSpecification))
            .constructor(VerifiedAccessSseSpecificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification")
                    .unmarshallLocationName("sseSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_GROUP_ID_FIELD, VERIFIED_ACCESS_INSTANCE_ID_FIELD, DESCRIPTION_FIELD, OWNER_FIELD,
            VERIFIED_ACCESS_GROUP_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, DELETION_TIME_FIELD, TAGS_FIELD,
            SSE_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String verifiedAccessGroupId;

    private final String verifiedAccessInstanceId;

    private final String description;

    private final String owner;

    private final String verifiedAccessGroupArn;

    private final String creationTime;

    private final String lastUpdatedTime;

    private final String deletionTime;

    private final List<Tag> tags;

    private final VerifiedAccessSseSpecificationResponse sseSpecification;

    private VerifiedAccessGroup(BuilderImpl builder) {
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.description = builder.description;
        this.owner = builder.owner;
        this.verifiedAccessGroupArn = builder.verifiedAccessGroupArn;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.deletionTime = builder.deletionTime;
        this.tags = builder.tags;
        this.sseSpecification = builder.sseSpecification;
    }

    /**
     * <p>
     * The ID of the Verified Access group.
     * </p>
     * 
     * @return The ID of the Verified Access group.
     */
    public final String verifiedAccessGroupId() {
        return verifiedAccessGroupId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Verified Access instance.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Verified Access instance.
     */
    public final String verifiedAccessInstanceId() {
        return verifiedAccessInstanceId;
    }

    /**
     * <p>
     * A description for the Amazon Web Services Verified Access group.
     * </p>
     * 
     * @return A description for the Amazon Web Services Verified Access group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Web Services account number that owns the group.
     * </p>
     * 
     * @return The Amazon Web Services account number that owns the group.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The ARN of the Verified Access group.
     * </p>
     * 
     * @return The ARN of the Verified Access group.
     */
    public final String verifiedAccessGroupArn() {
        return verifiedAccessGroupArn;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last updated time.
     * </p>
     * 
     * @return The last updated time.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The deletion time.
     * </p>
     * 
     * @return The deletion time.
     */
    public final String deletionTime() {
        return deletionTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The options in use for server side encryption.
     * </p>
     * 
     * @return The options in use for server side encryption.
     */
    public final VerifiedAccessSseSpecificationResponse sseSpecification() {
        return sseSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessGroup)) {
            return false;
        }
        VerifiedAccessGroup other = (VerifiedAccessGroup) obj;
        return Objects.equals(verifiedAccessGroupId(), other.verifiedAccessGroupId())
                && Objects.equals(verifiedAccessInstanceId(), other.verifiedAccessInstanceId())
                && Objects.equals(description(), other.description()) && Objects.equals(owner(), other.owner())
                && Objects.equals(verifiedAccessGroupArn(), other.verifiedAccessGroupArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(deletionTime(), other.deletionTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(sseSpecification(), other.sseSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessGroup").add("VerifiedAccessGroupId", verifiedAccessGroupId())
                .add("VerifiedAccessInstanceId", verifiedAccessInstanceId()).add("Description", description())
                .add("Owner", owner()).add("VerifiedAccessGroupArn", verifiedAccessGroupArn())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("DeletionTime", deletionTime()).add("Tags", hasTags() ? tags() : null)
                .add("SseSpecification", sseSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessGroupId":
            return Optional.ofNullable(clazz.cast(verifiedAccessGroupId()));
        case "VerifiedAccessInstanceId":
            return Optional.ofNullable(clazz.cast(verifiedAccessInstanceId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "VerifiedAccessGroupArn":
            return Optional.ofNullable(clazz.cast(verifiedAccessGroupArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "DeletionTime":
            return Optional.ofNullable(clazz.cast(deletionTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SseSpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedAccessGroupId", VERIFIED_ACCESS_GROUP_ID_FIELD);
        map.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("VerifiedAccessGroupArn", VERIFIED_ACCESS_GROUP_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("DeletionTime", DELETION_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessGroup, T> g) {
        return obj -> g.apply((VerifiedAccessGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessGroup> {
        /**
         * <p>
         * The ID of the Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroupId
         *        The ID of the Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroupId(String verifiedAccessGroupId);

        /**
         * <p>
         * The ID of the Amazon Web Services Verified Access instance.
         * </p>
         * 
         * @param verifiedAccessInstanceId
         *        The ID of the Amazon Web Services Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessInstanceId(String verifiedAccessInstanceId);

        /**
         * <p>
         * A description for the Amazon Web Services Verified Access group.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Web Services Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Web Services account number that owns the group.
         * </p>
         * 
         * @param owner
         *        The Amazon Web Services account number that owns the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The ARN of the Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroupArn
         *        The ARN of the Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroupArn(String verifiedAccessGroupArn);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The last updated time.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last updated time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The deletion time.
         * </p>
         * 
         * @param deletionTime
         *        The deletion time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionTime(String deletionTime);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The options in use for server side encryption.
         * </p>
         * 
         * @param sseSpecification
         *        The options in use for server side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification);

        /**
         * <p>
         * The options in use for server side encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessSseSpecificationResponse.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessSseSpecificationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessSseSpecificationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #sseSpecification(VerifiedAccessSseSpecificationResponse)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link VerifiedAccessSseSpecificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(VerifiedAccessSseSpecificationResponse)
         */
        default Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationResponse.Builder> sseSpecification) {
            return sseSpecification(VerifiedAccessSseSpecificationResponse.builder().applyMutation(sseSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String verifiedAccessGroupId;

        private String verifiedAccessInstanceId;

        private String description;

        private String owner;

        private String verifiedAccessGroupArn;

        private String creationTime;

        private String lastUpdatedTime;

        private String deletionTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private VerifiedAccessSseSpecificationResponse sseSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessGroup model) {
            verifiedAccessGroupId(model.verifiedAccessGroupId);
            verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            description(model.description);
            owner(model.owner);
            verifiedAccessGroupArn(model.verifiedAccessGroupArn);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            deletionTime(model.deletionTime);
            tags(model.tags);
            sseSpecification(model.sseSpecification);
        }

        public final String getVerifiedAccessGroupId() {
            return verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final String getVerifiedAccessInstanceId() {
            return verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getVerifiedAccessGroupArn() {
            return verifiedAccessGroupArn;
        }

        public final void setVerifiedAccessGroupArn(String verifiedAccessGroupArn) {
            this.verifiedAccessGroupArn = verifiedAccessGroupArn;
        }

        @Override
        public final Builder verifiedAccessGroupArn(String verifiedAccessGroupArn) {
            this.verifiedAccessGroupArn = verifiedAccessGroupArn;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getDeletionTime() {
            return deletionTime;
        }

        public final void setDeletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
        }

        @Override
        public final Builder deletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final VerifiedAccessSseSpecificationResponse.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationResponse.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        @Override
        public VerifiedAccessGroup build() {
            return new VerifiedAccessGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
