/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportVolumeRequest extends Ec2Request implements
        ToCopyableBuilder<ImportVolumeRequest.Builder, ImportVolumeRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ImportVolumeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(ImportVolumeRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<DiskImageDetail> IMAGE_FIELD = SdkField
            .<DiskImageDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Image")
            .getter(getter(ImportVolumeRequest::image))
            .setter(setter(Builder::image))
            .constructor(DiskImageDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image")
                    .unmarshallLocationName("image").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportVolumeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<VolumeDetail> VOLUME_FIELD = SdkField
            .<VolumeDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Volume")
            .getter(getter(ImportVolumeRequest::volume))
            .setter(setter(Builder::volume))
            .constructor(VolumeDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volume")
                    .unmarshallLocationName("volume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            AVAILABILITY_ZONE_FIELD, IMAGE_FIELD, DESCRIPTION_FIELD, VOLUME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String availabilityZone;

    private final DiskImageDetail image;

    private final String description;

    private final VolumeDetail volume;

    private ImportVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.availabilityZone = builder.availabilityZone;
        this.image = builder.image;
        this.description = builder.description;
        this.volume = builder.volume;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The Availability Zone for the resulting EBS volume.
     * </p>
     * 
     * @return The Availability Zone for the resulting EBS volume.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The disk image.
     * </p>
     * 
     * @return The disk image.
     */
    public final DiskImageDetail image() {
        return image;
    }

    /**
     * <p>
     * A description of the volume.
     * </p>
     * 
     * @return A description of the volume.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The volume size.
     * </p>
     * 
     * @return The volume size.
     */
    public final VolumeDetail volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(volume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeRequest)) {
            return false;
        }
        ImportVolumeRequest other = (ImportVolumeRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(image(), other.image()) && Objects.equals(description(), other.description())
                && Objects.equals(volume(), other.volume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportVolumeRequest").add("DryRun", dryRun()).add("AvailabilityZone", availabilityZone())
                .add("Image", image()).add("Description", description()).add("Volume", volume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Volume":
            return Optional.ofNullable(clazz.cast(volume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Volume", VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportVolumeRequest, T> g) {
        return obj -> g.apply((ImportVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ImportVolumeRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The Availability Zone for the resulting EBS volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the resulting EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The disk image.
         * </p>
         * 
         * @param image
         *        The disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(DiskImageDetail image);

        /**
         * <p>
         * The disk image.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiskImageDetail.Builder} avoiding the
         * need to create one manually via {@link DiskImageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskImageDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #image(DiskImageDetail)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link DiskImageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(DiskImageDetail)
         */
        default Builder image(Consumer<DiskImageDetail.Builder> image) {
            return image(DiskImageDetail.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * A description of the volume.
         * </p>
         * 
         * @param description
         *        A description of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The volume size.
         * </p>
         * 
         * @param volume
         *        The volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(VolumeDetail volume);

        /**
         * <p>
         * The volume size.
         * </p>
         * This is a convenience method that creates an instance of the {@link VolumeDetail.Builder} avoiding the need
         * to create one manually via {@link VolumeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VolumeDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #volume(VolumeDetail)}.
         * 
         * @param volume
         *        a consumer that will call methods on {@link VolumeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volume(VolumeDetail)
         */
        default Builder volume(Consumer<VolumeDetail.Builder> volume) {
            return volume(VolumeDetail.builder().applyMutation(volume).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String availabilityZone;

        private DiskImageDetail image;

        private String description;

        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeRequest model) {
            super(model);
            dryRun(model.dryRun);
            availabilityZone(model.availabilityZone);
            image(model.image);
            description(model.description);
            volume(model.volume);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final DiskImageDetail.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(DiskImageDetail.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final VolumeDetail.Builder getVolume() {
            return volume != null ? volume.toBuilder() : null;
        }

        public final void setVolume(VolumeDetail.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportVolumeRequest build() {
            return new ImportVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
