/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.VolumeIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSpecification> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceSpecification.getter(InstanceSpecification::instanceId)).setter(InstanceSpecification.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeBootVolume").getter(InstanceSpecification.getter(InstanceSpecification::excludeBootVolume)).setter(InstanceSpecification.setter(Builder::excludeBootVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolume").unmarshallLocationName("ExcludeBootVolume").build()}).build();
    private static final SdkField<List<String>> EXCLUDE_DATA_VOLUME_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeDataVolumeIds").getter(InstanceSpecification.getter(InstanceSpecification::excludeDataVolumeIds)).setter(InstanceSpecification.setter(Builder::excludeDataVolumeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeDataVolumeId").unmarshallLocationName("ExcludeDataVolumeId").build(), ListTrait.builder().memberLocationName("VolumeId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("VolumeId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, EXCLUDE_BOOT_VOLUME_FIELD, EXCLUDE_DATA_VOLUME_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final Boolean excludeBootVolume;
    private final List<String> excludeDataVolumeIds;

    private InstanceSpecification(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.excludeBootVolume = builder.excludeBootVolume;
        this.excludeDataVolumeIds = builder.excludeDataVolumeIds;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Boolean excludeBootVolume() {
        return this.excludeBootVolume;
    }

    public final boolean hasExcludeDataVolumeIds() {
        return this.excludeDataVolumeIds != null && !(this.excludeDataVolumeIds instanceof SdkAutoConstructList);
    }

    public final List<String> excludeDataVolumeIds() {
        return this.excludeDataVolumeIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeBootVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeDataVolumeIds() ? this.excludeDataVolumeIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification other = (InstanceSpecification)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.excludeBootVolume(), other.excludeBootVolume()) && this.hasExcludeDataVolumeIds() == other.hasExcludeDataVolumeIds() && Objects.equals(this.excludeDataVolumeIds(), other.excludeDataVolumeIds());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSpecification").add("InstanceId", (Object)this.instanceId()).add("ExcludeBootVolume", (Object)this.excludeBootVolume()).add("ExcludeDataVolumeIds", this.hasExcludeDataVolumeIds() ? this.excludeDataVolumeIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ExcludeBootVolume": {
                return Optional.ofNullable(clazz.cast(this.excludeBootVolume()));
            }
            case "ExcludeDataVolumeIds": {
                return Optional.ofNullable(clazz.cast(this.excludeDataVolumeIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ExcludeBootVolume", EXCLUDE_BOOT_VOLUME_FIELD);
        map.put("ExcludeDataVolumeId", EXCLUDE_DATA_VOLUME_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSpecification, T> g) {
        return obj -> g.apply((InstanceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean excludeBootVolume;
        private List<String> excludeDataVolumeIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSpecification model) {
            this.instanceId(model.instanceId);
            this.excludeBootVolume(model.excludeBootVolume);
            this.excludeDataVolumeIds(model.excludeDataVolumeIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Boolean getExcludeBootVolume() {
            return this.excludeBootVolume;
        }

        public final void setExcludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
        }

        @Override
        public final Builder excludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
            return this;
        }

        public final Collection<String> getExcludeDataVolumeIds() {
            if (this.excludeDataVolumeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeDataVolumeIds;
        }

        public final void setExcludeDataVolumeIds(Collection<String> excludeDataVolumeIds) {
            this.excludeDataVolumeIds = VolumeIdStringListCopier.copy(excludeDataVolumeIds);
        }

        @Override
        public final Builder excludeDataVolumeIds(Collection<String> excludeDataVolumeIds) {
            this.excludeDataVolumeIds = VolumeIdStringListCopier.copy(excludeDataVolumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeDataVolumeIds(String ... excludeDataVolumeIds) {
            this.excludeDataVolumeIds(Arrays.asList(excludeDataVolumeIds));
            return this;
        }

        public InstanceSpecification build() {
            return new InstanceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSpecification> {
        public Builder instanceId(String var1);

        public Builder excludeBootVolume(Boolean var1);

        public Builder excludeDataVolumeIds(Collection<String> var1);

        public Builder excludeDataVolumeIds(String ... var1);
    }
}

