/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchTemplateVersionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateLaunchTemplateVersionRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::dryRun)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::clientToken)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateId").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::launchTemplateId)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::launchTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId").unmarshallLocationName("LaunchTemplateId").build()}).build();
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateName").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::launchTemplateName)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::launchTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName").unmarshallLocationName("LaunchTemplateName").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceVersion").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::sourceVersion)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersion").unmarshallLocationName("SourceVersion").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::versionDescription)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").unmarshallLocationName("VersionDescription").build()}).build();
    private static final SdkField<RequestLaunchTemplateData> LAUNCH_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateData").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::launchTemplateData)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::launchTemplateData)).constructor(RequestLaunchTemplateData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData").unmarshallLocationName("LaunchTemplateData").build()}).build();
    private static final SdkField<Boolean> RESOLVE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResolveAlias").getter(CreateLaunchTemplateVersionRequest.getter(CreateLaunchTemplateVersionRequest::resolveAlias)).setter(CreateLaunchTemplateVersionRequest.setter(Builder::resolveAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolveAlias").unmarshallLocationName("ResolveAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, CLIENT_TOKEN_FIELD, LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_TEMPLATE_NAME_FIELD, SOURCE_VERSION_FIELD, VERSION_DESCRIPTION_FIELD, LAUNCH_TEMPLATE_DATA_FIELD, RESOLVE_ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLaunchTemplateVersionRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String clientToken;
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final String sourceVersion;
    private final String versionDescription;
    private final RequestLaunchTemplateData launchTemplateData;
    private final Boolean resolveAlias;

    private CreateLaunchTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.sourceVersion = builder.sourceVersion;
        this.versionDescription = builder.versionDescription;
        this.launchTemplateData = builder.launchTemplateData;
        this.resolveAlias = builder.resolveAlias;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String launchTemplateId() {
        return this.launchTemplateId;
    }

    public final String launchTemplateName() {
        return this.launchTemplateName;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final RequestLaunchTemplateData launchTemplateData() {
        return this.launchTemplateData;
    }

    public final Boolean resolveAlias() {
        return this.resolveAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateVersionRequest)) {
            return false;
        }
        CreateLaunchTemplateVersionRequest other = (CreateLaunchTemplateVersionRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.launchTemplateData(), other.launchTemplateData()) && Objects.equals(this.resolveAlias(), other.resolveAlias());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLaunchTemplateVersionRequest").add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("SourceVersion", (Object)this.sourceVersion()).add("VersionDescription", (Object)this.versionDescription()).add("LaunchTemplateData", (Object)this.launchTemplateData()).add("ResolveAlias", (Object)this.resolveAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "SourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "LaunchTemplateData": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateData()));
            }
            case "ResolveAlias": {
                return Optional.ofNullable(clazz.cast(this.resolveAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("LaunchTemplateId", LAUNCH_TEMPLATE_ID_FIELD);
        map.put("LaunchTemplateName", LAUNCH_TEMPLATE_NAME_FIELD);
        map.put("SourceVersion", SOURCE_VERSION_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("LaunchTemplateData", LAUNCH_TEMPLATE_DATA_FIELD);
        map.put("ResolveAlias", RESOLVE_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateVersionRequest, T> g) {
        return obj -> g.apply((CreateLaunchTemplateVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String clientToken;
        private String launchTemplateId;
        private String launchTemplateName;
        private String sourceVersion;
        private String versionDescription;
        private RequestLaunchTemplateData launchTemplateData;
        private Boolean resolveAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateVersionRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.sourceVersion(model.sourceVersion);
            this.versionDescription(model.versionDescription);
            this.launchTemplateData(model.launchTemplateData);
            this.resolveAlias(model.resolveAlias);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final RequestLaunchTemplateData.Builder getLaunchTemplateData() {
            return this.launchTemplateData != null ? this.launchTemplateData.toBuilder() : null;
        }

        public final void setLaunchTemplateData(RequestLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public final Builder launchTemplateData(RequestLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final Boolean getResolveAlias() {
            return this.resolveAlias;
        }

        public final void setResolveAlias(Boolean resolveAlias) {
            this.resolveAlias = resolveAlias;
        }

        @Override
        public final Builder resolveAlias(Boolean resolveAlias) {
            this.resolveAlias = resolveAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchTemplateVersionRequest build() {
            return new CreateLaunchTemplateVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchTemplateVersionRequest> {
        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder sourceVersion(String var1);

        public Builder versionDescription(String var1);

        public Builder launchTemplateData(RequestLaunchTemplateData var1);

        default public Builder launchTemplateData(Consumer<RequestLaunchTemplateData.Builder> launchTemplateData) {
            return this.launchTemplateData((RequestLaunchTemplateData)((RequestLaunchTemplateData.Builder)RequestLaunchTemplateData.builder().applyMutation(launchTemplateData)).build());
        }

        public Builder resolveAlias(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

