/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.UserData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportInstanceLaunchSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::architectureAsString)).setter(ImportInstanceLaunchSpecification.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").unmarshallLocationName("architecture").build()}).build();
    private static final SdkField<List<String>> GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupNames").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::groupNames)).setter(ImportInstanceLaunchSpecification.setter(Builder::groupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("GroupName").build(), ListTrait.builder().memberLocationName("SecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("SecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupIds").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::groupIds)).setter(ImportInstanceLaunchSpecification.setter(Builder::groupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("GroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalInfo").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::additionalInfo)).setter(ImportInstanceLaunchSpecification.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").unmarshallLocationName("additionalInfo").build()}).build();
    private static final SdkField<UserData> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserData").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::userData)).setter(ImportInstanceLaunchSpecification.setter(Builder::userData)).constructor(UserData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("userData").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::instanceTypeAsString)).setter(ImportInstanceLaunchSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::placement)).setter(ImportInstanceLaunchSpecification.setter(Builder::placement)).constructor(Placement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("placement").build()}).build();
    private static final SdkField<Boolean> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Monitoring").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::monitoring)).setter(ImportInstanceLaunchSpecification.setter(Builder::monitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("monitoring").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::subnetId)).setter(ImportInstanceLaunchSpecification.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInitiatedShutdownBehavior").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::instanceInitiatedShutdownBehaviorAsString)).setter(ImportInstanceLaunchSpecification.setter(Builder::instanceInitiatedShutdownBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior").unmarshallLocationName("instanceInitiatedShutdownBehavior").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(ImportInstanceLaunchSpecification.getter(ImportInstanceLaunchSpecification::privateIpAddress)).setter(ImportInstanceLaunchSpecification.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD, GROUP_NAMES_FIELD, GROUP_IDS_FIELD, ADDITIONAL_INFO_FIELD, USER_DATA_FIELD, INSTANCE_TYPE_FIELD, PLACEMENT_FIELD, MONITORING_FIELD, SUBNET_ID_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, PRIVATE_IP_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportInstanceLaunchSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String architecture;
    private final List<String> groupNames;
    private final List<String> groupIds;
    private final String additionalInfo;
    private final UserData userData;
    private final String instanceType;
    private final Placement placement;
    private final Boolean monitoring;
    private final String subnetId;
    private final String instanceInitiatedShutdownBehavior;
    private final String privateIpAddress;

    private ImportInstanceLaunchSpecification(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.groupNames = builder.groupNames;
        this.groupIds = builder.groupIds;
        this.additionalInfo = builder.additionalInfo;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.placement = builder.placement;
        this.monitoring = builder.monitoring;
        this.subnetId = builder.subnetId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public final ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(this.architecture);
    }

    public final String architectureAsString() {
        return this.architecture;
    }

    public final boolean hasGroupNames() {
        return this.groupNames != null && !(this.groupNames instanceof SdkAutoConstructList);
    }

    public final List<String> groupNames() {
        return this.groupNames;
    }

    public final boolean hasGroupIds() {
        return this.groupIds != null && !(this.groupIds instanceof SdkAutoConstructList);
    }

    public final List<String> groupIds() {
        return this.groupIds;
    }

    public final String additionalInfo() {
        return this.additionalInfo;
    }

    public final UserData userData() {
        return this.userData;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Placement placement() {
        return this.placement;
    }

    public final Boolean monitoring() {
        return this.monitoring;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public final String instanceInitiatedShutdownBehaviorAsString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupNames() ? this.groupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupIds() ? this.groupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceLaunchSpecification)) {
            return false;
        }
        ImportInstanceLaunchSpecification other = (ImportInstanceLaunchSpecification)obj;
        return Objects.equals(this.architectureAsString(), other.architectureAsString()) && this.hasGroupNames() == other.hasGroupNames() && Objects.equals(this.groupNames(), other.groupNames()) && this.hasGroupIds() == other.hasGroupIds() && Objects.equals(this.groupIds(), other.groupIds()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress());
    }

    public final String toString() {
        return ToString.builder((String)"ImportInstanceLaunchSpecification").add("Architecture", (Object)this.architectureAsString()).add("GroupNames", this.hasGroupNames() ? this.groupNames() : null).add("GroupIds", this.hasGroupIds() ? this.groupIds() : null).add("AdditionalInfo", (Object)this.additionalInfo()).add("UserData", (Object)(this.userData() == null ? null : "*** Sensitive Data Redacted ***")).add("InstanceType", (Object)this.instanceTypeAsString()).add("Placement", (Object)this.placement()).add("Monitoring", (Object)this.monitoring()).add("SubnetId", (Object)this.subnetId()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehaviorAsString()).add("PrivateIpAddress", (Object)this.privateIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "GroupNames": {
                return Optional.ofNullable(clazz.cast(this.groupNames()));
            }
            case "GroupIds": {
                return Optional.ofNullable(clazz.cast(this.groupIds()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehaviorAsString()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Architecture", ARCHITECTURE_FIELD);
        map.put("GroupName", GROUP_NAMES_FIELD);
        map.put("GroupId", GROUP_IDS_FIELD);
        map.put("AdditionalInfo", ADDITIONAL_INFO_FIELD);
        map.put("UserData", USER_DATA_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("Monitoring", MONITORING_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("InstanceInitiatedShutdownBehavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportInstanceLaunchSpecification, T> g) {
        return obj -> g.apply((ImportInstanceLaunchSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String architecture;
        private List<String> groupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> groupIds = DefaultSdkAutoConstructList.getInstance();
        private String additionalInfo;
        private UserData userData;
        private String instanceType;
        private Placement placement;
        private Boolean monitoring;
        private String subnetId;
        private String instanceInitiatedShutdownBehavior;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceLaunchSpecification model) {
            this.architecture(model.architecture);
            this.groupNames(model.groupNames);
            this.groupIds(model.groupIds);
            this.additionalInfo(model.additionalInfo);
            this.userData(model.userData);
            this.instanceType(model.instanceType);
            this.placement(model.placement);
            this.monitoring(model.monitoring);
            this.subnetId(model.subnetId);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.privateIpAddress(model.privateIpAddress);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final Collection<String> getGroupNames() {
            if (this.groupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupNames;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final Collection<String> getGroupIds() {
            if (this.groupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupIds;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String ... groupIds) {
            this.groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final UserData.Builder getUserData() {
            return this.userData != null ? this.userData.toBuilder() : null;
        }

        public final void setUserData(UserData.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final Boolean getMonitoring() {
            return this.monitoring;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public ImportInstanceLaunchSpecification build() {
            return new ImportInstanceLaunchSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);

        public Builder groupIds(Collection<String> var1);

        public Builder groupIds(String ... var1);

        public Builder additionalInfo(String var1);

        public Builder userData(UserData var1);

        default public Builder userData(Consumer<UserData.Builder> userData) {
            return this.userData((UserData)((UserData.Builder)UserData.builder().applyMutation(userData)).build());
        }

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().applyMutation(placement)).build());
        }

        public Builder monitoring(Boolean var1);

        public Builder subnetId(String var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder privateIpAddress(String var1);
    }
}

