/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayRouteTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayRouteTable> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableId").getter(TransitGatewayRouteTable.getter(TransitGatewayRouteTable::transitGatewayRouteTableId)).setter(TransitGatewayRouteTable.setter(Builder::transitGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId").unmarshallLocationName("transitGatewayRouteTableId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(TransitGatewayRouteTable.getter(TransitGatewayRouteTable::transitGatewayId)).setter(TransitGatewayRouteTable.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayRouteTable.getter(TransitGatewayRouteTable::stateAsString)).setter(TransitGatewayRouteTable.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Boolean> DEFAULT_ASSOCIATION_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultAssociationRouteTable").getter(TransitGatewayRouteTable.getter(TransitGatewayRouteTable::defaultAssociationRouteTable)).setter(TransitGatewayRouteTable.setter(Builder::defaultAssociationRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAssociationRouteTable").unmarshallLocationName("defaultAssociationRouteTable").build()}).build();
    private static final SdkField<Boolean> DEFAULT_PROPAGATION_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultPropagationRouteTable").getter(TransitGatewayRouteTable.getter(TransitGatewayRouteTable::defaultPropagationRouteTable)).setter(TransitGatewayRouteTable.setter(Builder::defaultPropagationRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPropagationRouteTable").unmarshallLocationName("defaultPropagationRouteTable").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TransitGatewayRouteTable.getter(TransitGatewayRouteTable::creationTime)).setter(TransitGatewayRouteTable.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TransitGatewayRouteTable.getter(TransitGatewayRouteTable::tags)).setter(TransitGatewayRouteTable.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, STATE_FIELD, DEFAULT_ASSOCIATION_ROUTE_TABLE_FIELD, DEFAULT_PROPAGATION_ROUTE_TABLE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayRouteTable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayRouteTableId;
    private final String transitGatewayId;
    private final String state;
    private final Boolean defaultAssociationRouteTable;
    private final Boolean defaultPropagationRouteTable;
    private final Instant creationTime;
    private final List<Tag> tags;

    private TransitGatewayRouteTable(BuilderImpl builder) {
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.transitGatewayId = builder.transitGatewayId;
        this.state = builder.state;
        this.defaultAssociationRouteTable = builder.defaultAssociationRouteTable;
        this.defaultPropagationRouteTable = builder.defaultPropagationRouteTable;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final TransitGatewayRouteTableState state() {
        return TransitGatewayRouteTableState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Boolean defaultAssociationRouteTable() {
        return this.defaultAssociationRouteTable;
    }

    public final Boolean defaultPropagationRouteTable() {
        return this.defaultPropagationRouteTable;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAssociationRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPropagationRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteTable)) {
            return false;
        }
        TransitGatewayRouteTable other = (TransitGatewayRouteTable)obj;
        return Objects.equals(this.transitGatewayRouteTableId(), other.transitGatewayRouteTableId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.defaultAssociationRouteTable(), other.defaultAssociationRouteTable()) && Objects.equals(this.defaultPropagationRouteTable(), other.defaultPropagationRouteTable()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayRouteTable").add("TransitGatewayRouteTableId", (Object)this.transitGatewayRouteTableId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("State", (Object)this.stateAsString()).add("DefaultAssociationRouteTable", (Object)this.defaultAssociationRouteTable()).add("DefaultPropagationRouteTable", (Object)this.defaultPropagationRouteTable()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "DefaultAssociationRouteTable": {
                return Optional.ofNullable(clazz.cast(this.defaultAssociationRouteTable()));
            }
            case "DefaultPropagationRouteTable": {
                return Optional.ofNullable(clazz.cast(this.defaultPropagationRouteTable()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayRouteTableId", TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("DefaultAssociationRouteTable", DEFAULT_ASSOCIATION_ROUTE_TABLE_FIELD);
        map.put("DefaultPropagationRouteTable", DEFAULT_PROPAGATION_ROUTE_TABLE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteTable, T> g) {
        return obj -> g.apply((TransitGatewayRouteTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayRouteTableId;
        private String transitGatewayId;
        private String state;
        private Boolean defaultAssociationRouteTable;
        private Boolean defaultPropagationRouteTable;
        private Instant creationTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteTable model) {
            this.transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            this.transitGatewayId(model.transitGatewayId);
            this.state(model.state);
            this.defaultAssociationRouteTable(model.defaultAssociationRouteTable);
            this.defaultPropagationRouteTable(model.defaultPropagationRouteTable);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getTransitGatewayRouteTableId() {
            return this.transitGatewayRouteTableId;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayRouteTableState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Boolean getDefaultAssociationRouteTable() {
            return this.defaultAssociationRouteTable;
        }

        public final void setDefaultAssociationRouteTable(Boolean defaultAssociationRouteTable) {
            this.defaultAssociationRouteTable = defaultAssociationRouteTable;
        }

        @Override
        public final Builder defaultAssociationRouteTable(Boolean defaultAssociationRouteTable) {
            this.defaultAssociationRouteTable = defaultAssociationRouteTable;
            return this;
        }

        public final Boolean getDefaultPropagationRouteTable() {
            return this.defaultPropagationRouteTable;
        }

        public final void setDefaultPropagationRouteTable(Boolean defaultPropagationRouteTable) {
            this.defaultPropagationRouteTable = defaultPropagationRouteTable;
        }

        @Override
        public final Builder defaultPropagationRouteTable(Boolean defaultPropagationRouteTable) {
            this.defaultPropagationRouteTable = defaultPropagationRouteTable;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransitGatewayRouteTable build() {
            return new TransitGatewayRouteTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayRouteTable> {
        public Builder transitGatewayRouteTableId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayRouteTableState var1);

        public Builder defaultAssociationRouteTable(Boolean var1);

        public Builder defaultPropagationRouteTable(Boolean var1);

        public Builder creationTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

