/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreManagedPrefixListVersionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RestoreManagedPrefixListVersionRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(RestoreManagedPrefixListVersionRequest.getter(RestoreManagedPrefixListVersionRequest::dryRun)).setter(RestoreManagedPrefixListVersionRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(RestoreManagedPrefixListVersionRequest.getter(RestoreManagedPrefixListVersionRequest::prefixListId)).setter(RestoreManagedPrefixListVersionRequest.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("PrefixListId").build()}).build();
    private static final SdkField<Long> PREVIOUS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PreviousVersion").getter(RestoreManagedPrefixListVersionRequest.getter(RestoreManagedPrefixListVersionRequest::previousVersion)).setter(RestoreManagedPrefixListVersionRequest.setter(Builder::previousVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousVersion").unmarshallLocationName("PreviousVersion").build()}).build();
    private static final SdkField<Long> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentVersion").getter(RestoreManagedPrefixListVersionRequest.getter(RestoreManagedPrefixListVersionRequest::currentVersion)).setter(RestoreManagedPrefixListVersionRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").unmarshallLocationName("CurrentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, PREFIX_LIST_ID_FIELD, PREVIOUS_VERSION_FIELD, CURRENT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreManagedPrefixListVersionRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String prefixListId;
    private final Long previousVersion;
    private final Long currentVersion;

    private RestoreManagedPrefixListVersionRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.prefixListId = builder.prefixListId;
        this.previousVersion = builder.previousVersion;
        this.currentVersion = builder.currentVersion;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final Long previousVersion() {
        return this.previousVersion;
    }

    public final Long currentVersion() {
        return this.currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreManagedPrefixListVersionRequest)) {
            return false;
        }
        RestoreManagedPrefixListVersionRequest other = (RestoreManagedPrefixListVersionRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.previousVersion(), other.previousVersion()) && Objects.equals(this.currentVersion(), other.currentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreManagedPrefixListVersionRequest").add("DryRun", (Object)this.dryRun()).add("PrefixListId", (Object)this.prefixListId()).add("PreviousVersion", (Object)this.previousVersion()).add("CurrentVersion", (Object)this.currentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "PreviousVersion": {
                return Optional.ofNullable(clazz.cast(this.previousVersion()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("PreviousVersion", PREVIOUS_VERSION_FIELD);
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreManagedPrefixListVersionRequest, T> g) {
        return obj -> g.apply((RestoreManagedPrefixListVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String prefixListId;
        private Long previousVersion;
        private Long currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreManagedPrefixListVersionRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.prefixListId(model.prefixListId);
            this.previousVersion(model.previousVersion);
            this.currentVersion(model.currentVersion);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final Long getPreviousVersion() {
            return this.previousVersion;
        }

        public final void setPreviousVersion(Long previousVersion) {
            this.previousVersion = previousVersion;
        }

        @Override
        public final Builder previousVersion(Long previousVersion) {
            this.previousVersion = previousVersion;
            return this;
        }

        public final Long getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreManagedPrefixListVersionRequest build() {
            return new RestoreManagedPrefixListVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreManagedPrefixListVersionRequest> {
        public Builder dryRun(Boolean var1);

        public Builder prefixListId(String var1);

        public Builder previousVersion(Long var1);

        public Builder currentVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

