/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FleetBlockDeviceMappingRequest;
import software.amazon.awssdk.services.ec2.model.FleetBlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetLaunchTemplateOverridesRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetLaunchTemplateOverridesRequest> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::instanceTypeAsString)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxPrice").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::maxPrice)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").unmarshallLocationName("MaxPrice").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::subnetId)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::availabilityZone)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<Double> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("WeightedCapacity").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::weightedCapacity)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").unmarshallLocationName("WeightedCapacity").build()}).build();
    private static final SdkField<Double> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Priority").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::priority)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("Priority").build()}).build();
    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::placement)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::placement)).constructor(Placement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("Placement").build()}).build();
    private static final SdkField<List<FleetBlockDeviceMappingRequest>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::blockDeviceMappings)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build(), ListTrait.builder().memberLocationName("BlockDeviceMapping").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetBlockDeviceMappingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build()}).build()).build()}).build();
    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::instanceRequirements)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::instanceRequirements)).constructor(InstanceRequirementsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").unmarshallLocationName("InstanceRequirements").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::imageId)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, MAX_PRICE_FIELD, SUBNET_ID_FIELD, AVAILABILITY_ZONE_FIELD, WEIGHTED_CAPACITY_FIELD, PRIORITY_FIELD, PLACEMENT_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, INSTANCE_REQUIREMENTS_FIELD, IMAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FleetLaunchTemplateOverridesRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final String maxPrice;
    private final String subnetId;
    private final String availabilityZone;
    private final Double weightedCapacity;
    private final Double priority;
    private final Placement placement;
    private final List<FleetBlockDeviceMappingRequest> blockDeviceMappings;
    private final InstanceRequirementsRequest instanceRequirements;
    private final String imageId;

    private FleetLaunchTemplateOverridesRequest(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.maxPrice = builder.maxPrice;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.weightedCapacity = builder.weightedCapacity;
        this.priority = builder.priority;
        this.placement = builder.placement;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceRequirements = builder.instanceRequirements;
        this.imageId = builder.imageId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String maxPrice() {
        return this.maxPrice;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Double weightedCapacity() {
        return this.weightedCapacity;
    }

    public final Double priority() {
        return this.priority;
    }

    public final Placement placement() {
        return this.placement;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<FleetBlockDeviceMappingRequest> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final InstanceRequirementsRequest instanceRequirements() {
        return this.instanceRequirements;
    }

    public final String imageId() {
        return this.imageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateOverridesRequest)) {
            return false;
        }
        FleetLaunchTemplateOverridesRequest other = (FleetLaunchTemplateOverridesRequest)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.placement(), other.placement()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements()) && Objects.equals(this.imageId(), other.imageId());
    }

    public final String toString() {
        return ToString.builder((String)"FleetLaunchTemplateOverridesRequest").add("InstanceType", (Object)this.instanceTypeAsString()).add("MaxPrice", (Object)this.maxPrice()).add("SubnetId", (Object)this.subnetId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("Priority", (Object)this.priority()).add("Placement", (Object)this.placement()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("InstanceRequirements", (Object)this.instanceRequirements()).add("ImageId", (Object)this.imageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("WeightedCapacity", WEIGHTED_CAPACITY_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateOverridesRequest, T> g) {
        return obj -> g.apply((FleetLaunchTemplateOverridesRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String maxPrice;
        private String subnetId;
        private String availabilityZone;
        private Double weightedCapacity;
        private Double priority;
        private Placement placement;
        private List<FleetBlockDeviceMappingRequest> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private InstanceRequirementsRequest instanceRequirements;
        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateOverridesRequest model) {
            this.instanceType(model.instanceType);
            this.maxPrice(model.maxPrice);
            this.subnetId(model.subnetId);
            this.availabilityZone(model.availabilityZone);
            this.weightedCapacity(model.weightedCapacity);
            this.priority(model.priority);
            this.placement(model.placement);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.instanceRequirements(model.instanceRequirements);
            this.imageId(model.imageId);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Double getWeightedCapacity() {
            return this.weightedCapacity;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final Double getPriority() {
            return this.priority;
        }

        public final void setPriority(Double priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Double priority) {
            this.priority = priority;
            return this;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final List<FleetBlockDeviceMappingRequest.Builder> getBlockDeviceMappings() {
            List<FleetBlockDeviceMappingRequest.Builder> result = FleetBlockDeviceMappingRequestListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<FleetBlockDeviceMappingRequest.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = FleetBlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<FleetBlockDeviceMappingRequest> blockDeviceMappings) {
            this.blockDeviceMappings = FleetBlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(FleetBlockDeviceMappingRequest ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<FleetBlockDeviceMappingRequest.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (FleetBlockDeviceMappingRequest)((FleetBlockDeviceMappingRequest.Builder)FleetBlockDeviceMappingRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public FleetLaunchTemplateOverridesRequest build() {
            return new FleetLaunchTemplateOverridesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetLaunchTemplateOverridesRequest> {
        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder maxPrice(String var1);

        public Builder subnetId(String var1);

        public Builder availabilityZone(String var1);

        public Builder weightedCapacity(Double var1);

        public Builder priority(Double var1);

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().applyMutation(placement)).build());
        }

        public Builder blockDeviceMappings(Collection<FleetBlockDeviceMappingRequest> var1);

        public Builder blockDeviceMappings(FleetBlockDeviceMappingRequest ... var1);

        public Builder blockDeviceMappings(Consumer<FleetBlockDeviceMappingRequest.Builder> ... var1);

        public Builder instanceRequirements(InstanceRequirementsRequest var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirementsRequest)((InstanceRequirementsRequest.Builder)InstanceRequirementsRequest.builder().applyMutation(instanceRequirements)).build());
        }

        public Builder imageId(String var1);
    }
}

